/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.EnumSignedState;
import ghidra.program.model.data.BitGroup;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumValuePartitioner;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.UniversalID;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class EnumDataType
extends GenericDataType
implements Enum {
    private static final SettingsDefinition[] ENUM_SETTINGS_DEFINITIONS = new SettingsDefinition[]{MutabilitySettingsDefinition.DEF};
    private Map<String, Long> nameMap;
    private Map<String, String> commentMap;
    private SortedMap<Long, List<String>> valueMap;
    private int length;
    private String description;
    private List<BitGroup> bitGroups;
    private EnumSignedState signedState = EnumSignedState.NONE;

    public EnumDataType(String name, int length) {
        this(CategoryPath.ROOT, name, length, null);
    }

    public EnumDataType(CategoryPath path, String name, int length) {
        this(path, name, length, null);
    }

    public EnumDataType(CategoryPath path, String name, int length, DataTypeManager dtm) {
        super(path, name, dtm);
        if (length < 1 || length > 8) {
            throw new IllegalArgumentException("unsupported enum length: " + length);
        }
        this.nameMap = new HashMap<String, Long>();
        this.valueMap = new TreeMap<Long, List<String>>();
        this.commentMap = new HashMap<String, String>();
        this.length = length;
    }

    public EnumDataType(CategoryPath path, String name, int length, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        if (length < 1 || length > 8) {
            throw new IllegalArgumentException("unsupported enum length: " + length);
        }
        this.nameMap = new HashMap<String, Long>();
        this.valueMap = new TreeMap<Long, List<String>>();
        this.commentMap = new HashMap<String, String>();
        this.length = length;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return ENUM_SETTINGS_DEFINITIONS;
    }

    @Override
    public long getValue(String valueName) throws NoSuchElementException {
        Long value = this.nameMap.get(valueName);
        if (value == null) {
            throw new NoSuchElementException("No value for " + valueName);
        }
        return value;
    }

    @Override
    public String getName(long value) {
        List list = (List)this.valueMap.get(value);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (String)list.get(0);
    }

    @Override
    public String[] getNames(long value) {
        List list = (List)this.valueMap.get(value);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getComment(String valueName) {
        String comment = this.commentMap.get(valueName);
        if (comment == null) {
            comment = "";
        }
        return comment;
    }

    @Override
    public long[] getValues() {
        long[] values = this.valueMap.keySet().stream().mapToLong(Long::longValue).toArray();
        return values;
    }

    @Override
    public String[] getNames() {
        ArrayList<String> names = new ArrayList<String>();
        Collection<List<String>> values = this.valueMap.values();
        for (List<String> list : values) {
            Collections.sort(list);
            names.addAll(list);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public int getCount() {
        return this.nameMap.size();
    }

    @Override
    public void add(String valueName, long value) {
        this.add(valueName, value, null);
    }

    @Override
    public void add(String valueName, long value, String comment) {
        this.doAdd(valueName, value, comment);
        this.signedState = this.computeSignedness();
    }

    private void doAdd(String valueName, long value, String comment) {
        this.bitGroups = null;
        this.checkValue(value);
        if (this.nameMap.containsKey(valueName)) {
            throw new IllegalArgumentException(valueName + " already exists in this enum");
        }
        this.nameMap.put(valueName, value);
        List list = this.valueMap.computeIfAbsent(value, v -> new ArrayList());
        list.add(valueName);
        if (!StringUtils.isBlank((CharSequence)comment)) {
            this.commentMap.put(valueName, comment);
        }
    }

    private EnumSignedState computeSignedness() {
        if (this.valueMap.isEmpty()) {
            return EnumSignedState.NONE;
        }
        long minValue = this.valueMap.firstKey();
        long maxValue = this.valueMap.lastKey();
        if (maxValue > this.getMaxPossibleValue(this.length, true)) {
            if (minValue < 0L) {
                return EnumSignedState.INVALID;
            }
            return EnumSignedState.UNSIGNED;
        }
        if (minValue < 0L) {
            return EnumSignedState.SIGNED;
        }
        return EnumSignedState.NONE;
    }

    @Override
    public void remove(String valueName) {
        this.bitGroups = null;
        Long value = this.nameMap.get(valueName);
        if (value == null) {
            return;
        }
        this.nameMap.remove(valueName);
        List list = (List)this.valueMap.get(value);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!valueName.equals(iter.next())) continue;
            iter.remove();
            break;
        }
        if (list.isEmpty()) {
            this.valueMap.remove(value);
        }
        this.commentMap.remove(valueName);
        this.signedState = this.computeSignedness();
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        enumDataType.setDescription(this.description);
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    public void setLength(int newLength) {
        if (newLength == this.length) {
            return;
        }
        int minLength = this.getMinimumPossibleLength();
        if (newLength < minLength || newLength > 8) {
            throw new IllegalArgumentException("Enum length must be between " + minLength + "and 8 inclusive");
        }
        this.length = newLength;
    }

    private void checkValue(long value) {
        if (this.length == 8) {
            return;
        }
        long min = this.getMinPossibleValue();
        long max = this.getMaxPossibleValue();
        if (value < min || value > max) {
            throw new IllegalArgumentException("Attempted to add a value outside the range for this enum: (" + min + ", " + max + "): " + value);
        }
    }

    @Override
    public boolean isSigned() {
        return this.signedState == EnumSignedState.SIGNED;
    }

    @Override
    public EnumSignedState getSignedState() {
        return this.signedState;
    }

    @Override
    public long getMinPossibleValue() {
        return this.getMinPossibleValue(this.length, this.signedState != EnumSignedState.UNSIGNED);
    }

    @Override
    public long getMaxPossibleValue() {
        return this.getMaxPossibleValue(this.length, this.signedState == EnumSignedState.SIGNED);
    }

    @Override
    public int getMinimumPossibleLength() {
        if (this.valueMap.isEmpty()) {
            return 1;
        }
        long minValue = this.valueMap.firstKey();
        long maxValue = this.valueMap.lastKey();
        boolean hasNegativeValues = minValue < 0L;
        for (int size = 1; size < 8; size *= 2) {
            long minPossible = this.getMinPossibleValue(size, hasNegativeValues);
            long maxPossible = this.getMaxPossibleValue(size, hasNegativeValues);
            if (minValue < minPossible || maxValue > maxPossible) continue;
            return size;
        }
        return 8;
    }

    private long getMaxPossibleValue(int bytes, boolean allowNegativeValues) {
        if (bytes == 8) {
            return Long.MAX_VALUE;
        }
        int bits = bytes * 8;
        if (allowNegativeValues) {
            --bits;
        }
        return (1L << bits) - 1L;
    }

    private long getMinPossibleValue(int bytes, boolean allowNegativeValues) {
        if (!allowNegativeValues) {
            return 0L;
        }
        int bits = bytes * 8;
        return -1L << bits - 1;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int valueLength) {
        try {
            long value = 0L;
            switch (valueLength) {
                case 1: {
                    value = buf.getByte(0);
                    break;
                }
                case 2: {
                    value = buf.getShort(0);
                    break;
                }
                case 4: {
                    value = buf.getInt(0);
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            return new Scalar(valueLength * 8, value);
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int valueLength) {
        try {
            long value = 0L;
            switch (this.length) {
                case 1: {
                    value = (long)buf.getByte(0) & 0xFFL;
                    break;
                }
                case 2: {
                    value = (long)buf.getShort(0) & 0xFFFFL;
                    break;
                }
                case 4: {
                    value = (long)buf.getInt(0) & 0xFFFFFFFFL;
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            return this.getRepresentation(value);
        }
        catch (MemoryAccessException e) {
            return "??";
        }
    }

    @Override
    public String getRepresentation(BigInteger bigInt, Settings settings, int bitLength) {
        return this.getRepresentation(bigInt.longValue());
    }

    private String getRepresentation(long value) {
        String valueName = this.getName(value);
        if (valueName == null) {
            valueName = this.getCompoundValue(value);
        }
        return valueName;
    }

    private String getCompoundValue(long value) {
        if (value == 0L) {
            return "0";
        }
        List<BitGroup> list = this.getBitGroups();
        StringBuilder buf = new StringBuilder();
        for (BitGroup bitGroup : list) {
            long subValue = bitGroup.getMask() & value;
            if (subValue == 0L) continue;
            Object part = this.getName(subValue);
            if (part == null) {
                part = Long.toHexString(subValue).toUpperCase() + "h";
            }
            if (buf.length() != 0) {
                buf.append(" | ");
            }
            buf.append((String)part);
        }
        return buf.toString();
    }

    private List<BitGroup> getBitGroups() {
        if (this.bitGroups == null) {
            this.bitGroups = EnumValuePartitioner.partition(this.getValues(), this.getLength());
        }
        return this.bitGroups;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Enum)) {
            return false;
        }
        Enum enumm = (Enum)dt;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.name, enumm.getName()) || this.length != enumm.getLength() || this.getCount() != enumm.getCount()) {
            return false;
        }
        return this.isEachValueEquivalent(enumm);
    }

    private boolean isEachValueEquivalent(Enum enumm) {
        String[] names = this.getNames();
        String[] otherNames = enumm.getNames();
        try {
            for (int i = 0; i < names.length; ++i) {
                String otherComment;
                long otherValue;
                if (!names[i].equals(otherNames[i])) {
                    return false;
                }
                long value = this.getValue(names[i]);
                if (value != (otherValue = enumm.getValue(names[i]))) {
                    return false;
                }
                String comment = this.getComment(names[i]);
                if (comment.equals(otherComment = enumm.getComment(names[i]))) continue;
                return false;
            }
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        this.bitGroups = null;
        if (!(dataType instanceof Enum)) {
            throw new IllegalArgumentException();
        }
        Enum enumm = (Enum)dataType;
        this.nameMap = new HashMap<String, Long>();
        this.valueMap = new TreeMap<Long, List<String>>();
        this.commentMap = new HashMap<String, String>();
        this.setLength(enumm.getLength());
        String[] names = enumm.getNames();
        this.signedState = enumm.getSignedState();
        for (String valueName : names) {
            this.doAdd(valueName, enumm.getValue(valueName), enumm.getComment(valueName));
        }
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name;
    }

    @Override
    public boolean contains(String entryName) {
        return this.nameMap.containsKey(entryName);
    }

    @Override
    public boolean contains(long value) {
        return this.valueMap.containsKey(value);
    }

    public void pack() {
        this.setLength(this.getMinimumPossibleLength());
    }
}

