/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressRangeIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.RedBlackEntry;
import ghidra.util.datastruct.RedBlackTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class AddressSet
implements AddressSetView {
    private static final double LOGBASE2 = Math.log(2.0);
    private RedBlackTree<Address, Address> rbTree = new RedBlackTree();
    private RedBlackEntry<Address, Address> lastNode;
    private long addressCount = 0L;

    public AddressSet() {
    }

    @Deprecated
    public AddressSet(AddressFactory factory) {
        this();
    }

    public AddressSet(AddressRange range) {
        this.add(range);
    }

    @Deprecated
    public AddressSet(AddressFactory factory, AddressRange range) {
        this.add(range);
    }

    public AddressSet(Address start, Address end) {
        this.addRange(start, end);
    }

    @Deprecated
    public AddressSet(AddressFactory factory, Address start, Address end) {
        this.addRange(start, end);
    }

    public AddressSet(Program program, Address start, Address end) {
        this.addRange(program, start, end);
    }

    @Deprecated
    public AddressSet(AddressFactory factory, AddressSetView set) {
        this.add(set);
    }

    public AddressSet(AddressSetView set) {
        this.add(set);
    }

    @Deprecated
    public AddressSet(AddressFactory factory, Address addr) {
        this(addr, addr);
    }

    public AddressSet(Address addr) {
        this(addr, addr);
    }

    public final void add(Address address) {
        this.addRange(address, address);
    }

    public final void add(AddressRange range) {
        if (range == null) {
            return;
        }
        this.add(range.getMinAddress(), range.getMaxAddress());
    }

    public void add(Address start, Address end) {
        this.checkValidRange(start, end);
        if (this.lastNode != null && !this.lastNode.isDisposed()) {
            Address value = (Address)this.lastNode.getValue();
            if (this.contains(this.lastNode, start) || value.isSuccessor(start)) {
                if (end.compareTo(value) > 0) {
                    this.updateRangeEndAddress(this.lastNode, end);
                    this.consumeFollowOnNodes(this.lastNode);
                }
                return;
            }
        }
        if (this.rbTree.isEmpty()) {
            this.lastNode = this.createRangeNode(start, end);
            return;
        }
        if (start.compareTo((Address)this.rbTree.getLast().getKey()) > 0) {
            RedBlackEntry last = this.rbTree.getLast();
            Address value = (Address)last.getValue();
            if (this.contains((RedBlackEntry<Address, Address>)last, start) || value.isSuccessor(start)) {
                if (end.compareTo(value) > 0) {
                    this.updateRangeEndAddress((RedBlackEntry<Address, Address>)last, end);
                }
            } else {
                this.lastNode = this.createRangeNode(start, end);
            }
            return;
        }
        this.lastNode = this.rbTree.getEntryLessThanEqual((Comparable)start);
        if (this.lastNode == null) {
            this.lastNode = this.createRangeNode(start, end);
            this.consumeFollowOnNodes(this.lastNode);
            return;
        }
        Address nodeEnd = (Address)this.lastNode.getValue();
        if (nodeEnd.compareTo(start) >= 0 || nodeEnd.isSuccessor(start)) {
            if (end.compareTo(nodeEnd) > 0) {
                this.updateRangeEndAddress(this.lastNode, end);
                this.consumeFollowOnNodes(this.lastNode);
            }
            return;
        }
        this.lastNode = this.createRangeNode(start, end);
        this.consumeFollowOnNodes(this.lastNode);
    }

    public void addRange(Address start, Address end) {
        this.add(start, end);
    }

    public void addRange(Program program, Address start, Address end) {
        if (start.getAddressSpace().equals(end.getAddressSpace())) {
            this.addRange(start, end);
            return;
        }
        AddressFactory addressFactory = program.getAddressFactory();
        this.add(addressFactory.getAddressSet(start, end));
    }

    public final void add(AddressSetView addressSet) {
        if (addressSet == null) {
            return;
        }
        if (this.useLinearAlgorithm(addressSet)) {
            AddressSet newSet = this.mergeSets(addressSet);
            this.rbTree = newSet.rbTree;
            this.addressCount = newSet.addressCount;
            this.lastNode = null;
        } else {
            AddressRangeIterator it = addressSet.getAddressRanges();
            while (it.hasNext()) {
                AddressRange range = (AddressRange)it.next();
                this.addRange(range.getMinAddress(), range.getMaxAddress());
            }
        }
    }

    public final void delete(AddressRange range) {
        this.deleteRange(range.getMinAddress(), range.getMaxAddress());
    }

    public final void delete(Address start, Address end) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start address (" + start + ") is greater than end address (" + end + ")");
        }
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)start);
        if (entry == null) {
            entry = this.rbTree.getFirst();
        } else if (((Address)entry.getValue()).compareTo(start) < 0) {
            entry = entry.getSuccessor();
        }
        while (entry != null) {
            Address minRange = (Address)entry.getKey();
            Address maxRange = (Address)entry.getValue();
            switch (this.compareRange(start, end, minRange, maxRange)) {
                case RANGE1_COMPLETELY_AFTER_RANGE2: {
                    entry = entry.getSuccessor();
                    break;
                }
                case RANGE1_COMPLETELY_BEFORE_RANGE2: {
                    return;
                }
                case RANGE1_EQUALS_RANGE2: {
                    this.deleteRangeNode((RedBlackEntry<Address, Address>)entry);
                    return;
                }
                case RANGE1_STARTS_AT_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AT_RANGE2_END: {
                    entry = this.deleteRangeNode((RedBlackEntry<Address, Address>)entry);
                    break;
                }
                case RANGE1_STARTS_AT_RANGE2_ENDS_BEFORE_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_INSIDE_RANGE2: {
                    this.deleteRangeNode((RedBlackEntry<Address, Address>)entry);
                    this.createRangeNode(end.next(), maxRange);
                    return;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AT_RANGE2: {
                    this.updateRangeEndAddress(entry, start.previous());
                    entry = entry.getSuccessor();
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_INSIDE_RANGE2: {
                    this.updateRangeEndAddress(entry, start.previous());
                    this.createRangeNode(end.next(), maxRange);
                    return;
                }
            }
        }
    }

    public final void deleteRange(Address start, Address end) {
        this.delete(start, end);
    }

    public final void delete(AddressSetView addressSet) {
        if (addressSet == null || addressSet.getNumAddressRanges() == 0) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.useLinearAlgorithm(addressSet)) {
            AddressSet newSet = this.deleteSets(addressSet);
            this.rbTree = newSet.rbTree;
            this.addressCount = newSet.addressCount;
            this.lastNode = null;
        } else {
            for (AddressRange addressRange : addressSet) {
                this.delete(addressRange);
            }
        }
    }

    public void clear() {
        this.rbTree.removeAll();
        this.lastNode = null;
        this.addressCount = 0L;
    }

    public String printRanges() {
        StringBuffer buffy = new StringBuffer("[");
        for (AddressRange range : this) {
            buffy.append(range);
            buffy.append(" ");
        }
        buffy.append("]");
        return buffy.toString();
    }

    public List<AddressRange> toList() {
        ArrayList<AddressRange> list = new ArrayList<AddressRange>();
        for (AddressRange range : this) {
            list.add(range);
        }
        return list;
    }

    @Override
    public final boolean contains(Address address) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)address);
        if (entry == null) {
            return false;
        }
        return address.compareTo((Address)entry.getValue()) <= 0;
    }

    @Override
    public final boolean contains(Address start, Address end) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)start);
        if (entry == null) {
            return false;
        }
        return end.compareTo((Address)entry.getValue()) <= 0;
    }

    @Override
    public final boolean contains(AddressSetView addrSet) {
        Address thatMaxAddr;
        Address thatMinAddr;
        if (addrSet.getNumAddressRanges() == 0) {
            return true;
        }
        if (this.getNumAddressRanges() == 0) {
            return false;
        }
        Address thisMinAddr = this.getMinAddress();
        if (thisMinAddr.compareTo(thatMinAddr = addrSet.getMinAddress()) > 0) {
            return false;
        }
        Address thisMaxAddr = this.getMaxAddress();
        if (thisMaxAddr.compareTo(thatMaxAddr = addrSet.getMaxAddress()) < 0) {
            return false;
        }
        if (this.useLinearAlgorithm(addrSet)) {
            return this.containsLinear(addrSet);
        }
        return this.containsBinary(addrSet);
    }

    @Override
    public final boolean hasSameAddresses(AddressSetView addrSet) {
        return this.equals(addrSet);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AddressSetView)) {
            return false;
        }
        AddressSetView set = (AddressSetView)obj;
        if (this.getNumAddresses() != set.getNumAddresses()) {
            return false;
        }
        if (this.getNumAddressRanges() != set.getNumAddressRanges()) {
            return false;
        }
        AddressRangeIterator otherRanges = set.getAddressRanges();
        AddressRangeIterator myRanges = this.getAddressRanges();
        while (myRanges.hasNext()) {
            AddressRange otherRange;
            AddressRange myRange = (AddressRange)myRanges.next();
            if (myRange.equals(otherRange = (AddressRange)otherRanges.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getMinAddress().hashCode() + this.getMaxAddress().hashCode();
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        int thisSize = this.getNumAddressRanges();
        int thatSize = addrSet.getNumAddressRanges();
        if (thisSize == 0 || thatSize == 0) {
            return false;
        }
        if (thisSize < thatSize) {
            return addrSet.intersects(this);
        }
        if (this.useLinearAlgorithm(addrSet)) {
            return this.intersectsLinear(addrSet);
        }
        return this.intersectsBinary(addrSet);
    }

    @Override
    public final AddressSet intersectRange(Address start, Address end) {
        return this.intersectRange(start, end, new AddressSet());
    }

    @Override
    public final AddressSet intersect(AddressSetView addrSet) {
        int thatSize;
        if (addrSet == null || addrSet.isEmpty() || this.isEmpty()) {
            return new AddressSet();
        }
        int thisSize = this.getNumAddressRanges();
        if (thisSize < (thatSize = addrSet.getNumAddressRanges())) {
            return addrSet.intersect(this);
        }
        if (this.useLinearAlgorithm(addrSet)) {
            return this.intersectLinear(addrSet);
        }
        return this.intersectBinary(addrSet);
    }

    @Override
    public final AddressSet union(AddressSetView addrSet) {
        return this.mergeSets(addrSet);
    }

    @Override
    public final AddressSet subtract(AddressSetView addrSet) {
        if (addrSet.getNumAddressRanges() == 0) {
            return new AddressSet(this);
        }
        return this.deleteSets(addrSet);
    }

    @Override
    public boolean isEmpty() {
        return this.rbTree.isEmpty();
    }

    @Override
    public Address getMinAddress() {
        if (this.rbTree.isEmpty()) {
            return null;
        }
        return (Address)this.rbTree.getFirst().getKey();
    }

    @Override
    public Address getMaxAddress() {
        if (this.rbTree.isEmpty()) {
            return null;
        }
        return (Address)this.rbTree.getLast().getValue();
    }

    @Override
    public int getNumAddressRanges() {
        return this.rbTree.size();
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        return this.getAddressRanges(forward);
    }

    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.getAddressRanges(start, forward);
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return new AddressRangeIteratorAdapter(this.rbTree.iterator());
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        ListIterator iterator = this.rbTree.iterator(forward);
        return new AddressRangeIteratorAdapter(iterator);
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)start);
        if (entry == null) {
            if (forward) {
                return new AddressRangeIteratorAdapter(this.rbTree.iterator());
            }
            return new EmptyAddressRangeIterator();
        }
        if (forward && !this.contains((RedBlackEntry<Address, Address>)entry, start)) {
            entry = entry.getSuccessor();
        }
        ListIterator iterator = this.rbTree.iterator(entry, forward);
        return new AddressRangeIteratorAdapter(iterator);
    }

    @Override
    public long getNumAddresses() {
        return this.addressCount;
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        return new MyAddressIterator(null, forward);
    }

    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        return new MyAddressIterator(start, forward);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)end);
        if (entry == null) {
            return false;
        }
        return start.compareTo((Address)entry.getValue()) <= 0;
    }

    @Override
    public AddressSet xor(AddressSetView addrSet) {
        if (this.isEmpty()) {
            return new AddressSet(addrSet);
        }
        return this.xorSets(addrSet);
    }

    public final String toString() {
        int size = this.getNumAddressRanges();
        if (size == 0) {
            return "[empty]\n";
        }
        return this.printRanges();
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)address);
        if (entry != null && this.contains((RedBlackEntry<Address, Address>)entry, address)) {
            return new AddressRangeImpl((Address)entry.getKey(), (Address)entry.getValue());
        }
        return null;
    }

    @Override
    public AddressRange getFirstRange() {
        RedBlackEntry first = this.rbTree.getFirst();
        if (first != null) {
            return new AddressRangeImpl((Address)first.getKey(), (Address)first.getValue());
        }
        return null;
    }

    @Override
    public AddressRange getLastRange() {
        RedBlackEntry last = this.rbTree.getLast();
        if (last != null) {
            return new AddressRangeImpl((Address)last.getKey(), (Address)last.getValue());
        }
        return null;
    }

    private boolean intersectsBinary(AddressSetView addrSet) {
        for (AddressRange range : addrSet) {
            if (!this.intersects(range.getMinAddress(), range.getMaxAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean intersectsLinear(AddressSetView addrSet) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)addrSet.getMinAddress());
        if (entry == null) {
            entry = this.rbTree.getFirst();
        }
        for (AddressRange range : addrSet) {
            while (range.compareTo((Address)entry.getValue()) > 0) {
                if ((entry = entry.getSuccessor()) != null) continue;
                return false;
            }
            if (range.getMaxAddress().compareTo((Address)entry.getKey()) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean containsLinear(AddressSetView addrSet) {
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)addrSet.getMinAddress());
        if (entry == null) {
            return false;
        }
        for (AddressRange range : addrSet) {
            while (range.compareTo((Address)entry.getValue()) > 0) {
                if ((entry = entry.getSuccessor()) != null) continue;
                return false;
            }
            if (range.getMaxAddress().compareTo((Address)entry.getValue()) <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean useLinearAlgorithm(AddressSetView set) {
        int thatSize;
        int thisSize = this.getNumAddressRanges();
        return (double)(thisSize + (thatSize = set.getNumAddressRanges())) <= (double)thatSize * Math.log(thisSize) / LOGBASE2;
    }

    private boolean containsBinary(AddressSetView addrSet) {
        for (AddressRange range : addrSet) {
            if (this.contains(range.getMinAddress(), range.getMaxAddress())) continue;
            return false;
        }
        return true;
    }

    private AddressSet intersectRange(Address start, Address end, AddressSet set) {
        if (!start.getAddressSpace().equals(end.getAddressSpace()) && start.compareTo(end) > 0) {
            Address tmp = start;
            start = end;
            end = tmp;
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start address must be less than or equal to end address:  Start " + start + "   end = " + end);
        }
        RedBlackEntry entry = this.rbTree.getEntryLessThanEqual((Comparable)start);
        if (entry != null) {
            if (((Address)entry.getValue()).compareTo(start) >= 0) {
                set.addRange(start, this.min(end, (Address)entry.getValue()));
            }
            entry = entry.getSuccessor();
        } else {
            entry = this.rbTree.getFirst();
        }
        while (entry != null && ((Address)entry.getKey()).compareTo(end) <= 0) {
            set.addRange((Address)entry.getKey(), this.min(end, (Address)entry.getValue()));
            entry = entry.getSuccessor();
        }
        return set;
    }

    private AddressSet intersectLinear(AddressSetView addrSet) {
        Iterator<AddressRange> thisIt = this.iterator(addrSet.getMinAddress(), true);
        Iterator<AddressRange> thatIt = addrSet.iterator();
        AddressSet set = new AddressSet();
        if (!thisIt.hasNext() || !thatIt.hasNext()) {
            return set;
        }
        AddressRange thisRange = thisIt.next();
        AddressRange thatRange = thatIt.next();
        while (true) {
            if (thisRange.intersects(thatRange)) {
                AddressRange intersection = thisRange.intersect(thatRange);
                set.add(intersection);
            }
            if (thisRange.getMaxAddress().compareTo(thatRange.getMaxAddress()) <= 0) {
                if (!thisIt.hasNext()) break;
                thisRange = thisIt.next();
                continue;
            }
            if (!thatIt.hasNext()) break;
            thatRange = thatIt.next();
        }
        return set;
    }

    private AddressSet intersectBinary(AddressSetView addrSet) {
        AddressSet set = new AddressSet();
        for (AddressRange range : addrSet) {
            this.intersectRange(range.getMinAddress(), range.getMaxAddress(), set);
        }
        return set;
    }

    private Address min(Address addr1, Address addr2) {
        if (addr1.compareTo(addr2) <= 0) {
            return addr1;
        }
        return addr2;
    }

    private RangeCompare compareRange(AddressRange range1, AddressRange range2) {
        Address minAddr1 = range1.getMinAddress();
        Address maxAddr1 = range1.getMaxAddress();
        Address minAddr2 = range2.getMinAddress();
        Address maxAddr2 = range2.getMaxAddress();
        return this.compareRange(minAddr1, maxAddr1, minAddr2, maxAddr2);
    }

    private RangeCompare compareRange(Address minAddr1, Address maxAddr1, Address minAddr2, Address maxAddr2) {
        if (maxAddr1.compareTo(minAddr2) < 0) {
            return RangeCompare.RANGE1_COMPLETELY_BEFORE_RANGE2;
        }
        if (minAddr1.compareTo(maxAddr2) > 0) {
            return RangeCompare.RANGE1_COMPLETELY_AFTER_RANGE2;
        }
        int startCompare = minAddr1.compareTo(minAddr2);
        int endCompare = maxAddr1.compareTo(maxAddr2);
        if (startCompare < 0) {
            if (endCompare < 0) {
                return RangeCompare.RANGE1_STARTS_BEFORE_RANGE2_ENDS_INSIDE_RANGE2;
            }
            if (endCompare > 0) {
                return RangeCompare.RANGE1_STARTS_BEFORE_RANGE2_ENDS_AFTER_RANGE2;
            }
            return RangeCompare.RANGE1_STARTS_BEFORE_RANGE2_ENDS_AT_RANGE2_END;
        }
        if (startCompare > 0) {
            if (endCompare < 0) {
                return RangeCompare.RANGE1_STARTS_INSIDE_RANGE2_ENDS_INSIDE_RANGE2;
            }
            if (endCompare > 0) {
                return RangeCompare.RANGE1_STARTS_INSIDE_RANGE2_ENDS_AFTER_RANGE2;
            }
            return RangeCompare.RANGE1_STARTS_INSIDE_RANGE2_ENDS_AT_RANGE2;
        }
        if (endCompare < 0) {
            return RangeCompare.RANGE1_STARTS_AT_RANGE2_ENDS_BEFORE_RANGE2;
        }
        if (endCompare > 0) {
            return RangeCompare.RANGE1_STARTS_AT_RANGE2_ENDS_AFTER_RANGE2;
        }
        return RangeCompare.RANGE1_EQUALS_RANGE2;
    }

    private AddressSet deleteSets(AddressSetView addrSet) {
        AddressRange deleteRange;
        AddressSet newSet = new AddressSet();
        AddressRangeIterator rangeIt = this.getAddressRanges();
        AddressRangeIterator deleteRangeIt = addrSet.getAddressRanges();
        AddressRange range = rangeIt.hasNext() ? (AddressRange)rangeIt.next() : null;
        AddressRange addressRange = deleteRange = deleteRangeIt.hasNext() ? (AddressRange)deleteRangeIt.next() : null;
        while (range != null && deleteRange != null) {
            switch (this.compareRange(deleteRange, range)) {
                case RANGE1_COMPLETELY_BEFORE_RANGE2: {
                    deleteRange = deleteRangeIt.hasNext() ? (AddressRange)deleteRangeIt.next() : null;
                    break;
                }
                case RANGE1_COMPLETELY_AFTER_RANGE2: {
                    newSet.add(range);
                    range = rangeIt.hasNext() ? (AddressRange)rangeIt.next() : null;
                    break;
                }
                case RANGE1_EQUALS_RANGE2: 
                case RANGE1_STARTS_AT_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AT_RANGE2_END: {
                    range = rangeIt.hasNext() ? (AddressRange)rangeIt.next() : null;
                    break;
                }
                case RANGE1_STARTS_AT_RANGE2_ENDS_BEFORE_RANGE2: 
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_INSIDE_RANGE2: {
                    range = new AddressRangeImpl(deleteRange.getMaxAddress().next(), range.getMaxAddress());
                    deleteRange = deleteRangeIt.hasNext() ? (AddressRange)deleteRangeIt.next() : null;
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AFTER_RANGE2: 
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AT_RANGE2: {
                    Address nextEnd = deleteRange.getMinAddress().previous();
                    newSet.addRange(range.getMinAddress(), nextEnd);
                    range = rangeIt.hasNext() ? (AddressRange)rangeIt.next() : null;
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_INSIDE_RANGE2: {
                    newSet.addRange(range.getMinAddress(), deleteRange.getMinAddress().previous());
                    range = new AddressRangeImpl(deleteRange.getMaxAddress().next(), range.getMaxAddress());
                    deleteRange = deleteRangeIt.hasNext() ? (AddressRange)deleteRangeIt.next() : null;
                }
            }
        }
        while (range != null) {
            newSet.add(range);
            range = rangeIt.hasNext() ? (AddressRange)rangeIt.next() : null;
        }
        return newSet;
    }

    private AddressSet xorSets(AddressSetView addrSet) {
        AddressRange range2;
        AddressSet newSet = new AddressSet();
        AddressRangeIterator range1It = this.getAddressRanges();
        AddressRangeIterator range2It = addrSet.getAddressRanges();
        AddressRange range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
        AddressRange addressRange = range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
        while (range1 != null && range2 != null) {
            switch (this.compareRange(range1, range2)) {
                case RANGE1_COMPLETELY_AFTER_RANGE2: {
                    newSet.add(range2);
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_COMPLETELY_BEFORE_RANGE2: {
                    newSet.add(range1);
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    break;
                }
                case RANGE1_EQUALS_RANGE2: {
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_AT_RANGE2_ENDS_AFTER_RANGE2: {
                    range1 = new AddressRangeImpl(range2.getMaxAddress().next(), range1.getMaxAddress());
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_AT_RANGE2_ENDS_BEFORE_RANGE2: {
                    range2 = new AddressRangeImpl(range1.getMaxAddress().next(), range2.getMaxAddress());
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    break;
                }
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AFTER_RANGE2: {
                    newSet.addRange(range1.getMinAddress(), range2.getMinAddress().previous());
                    range1 = new AddressRangeImpl(range2.getMaxAddress().next(), range1.getMaxAddress());
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_AT_RANGE2_END: {
                    newSet.addRange(range1.getMinAddress(), range2.getMinAddress().previous());
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_BEFORE_RANGE2_ENDS_INSIDE_RANGE2: {
                    newSet.addRange(range1.getMinAddress(), range2.getMinAddress().previous());
                    range2 = new AddressRangeImpl(range1.getMaxAddress().next(), range2.getMaxAddress());
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AFTER_RANGE2: {
                    newSet.addRange(range2.getMinAddress(), range1.getMinAddress().previous());
                    range1 = new AddressRangeImpl(range2.getMaxAddress().next(), range1.getMaxAddress());
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_AT_RANGE2: {
                    newSet.addRange(range2.getMinAddress(), range1.getMinAddress().previous());
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                    range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
                    break;
                }
                case RANGE1_STARTS_INSIDE_RANGE2_ENDS_INSIDE_RANGE2: {
                    newSet.addRange(range2.getMinAddress(), range1.getMinAddress().previous());
                    range2 = new AddressRangeImpl(range1.getMaxAddress().next(), range2.getMaxAddress());
                    range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
                }
            }
        }
        while (range1 != null) {
            newSet.add(range1);
            range1 = range1It.hasNext() ? (AddressRange)range1It.next() : null;
        }
        while (range2 != null) {
            newSet.add(range2);
            range2 = range2It.hasNext() ? (AddressRange)range2It.next() : null;
        }
        return newSet;
    }

    private AddressRange getRange(RedBlackEntry<Address, Address> entry) {
        return new AddressRangeImpl((Address)entry.getKey(), (Address)entry.getValue());
    }

    private boolean contains(RedBlackEntry<Address, Address> entry, Address start) {
        return ((Address)entry.getKey()).compareTo(start) <= 0 && ((Address)entry.getValue()).compareTo(start) >= 0;
    }

    private AddressSet mergeSets(AddressSetView addrSet) {
        AddressRange thatRange;
        AddressSet newSet = new AddressSet();
        AddressRangeIterator thisIter = this.getAddressRanges();
        AddressRangeIterator thatIter = addrSet.getAddressRanges();
        AddressRange thisRange = thisIter.hasNext() ? (AddressRange)thisIter.next() : null;
        AddressRange addressRange = thatRange = thatIter.hasNext() ? (AddressRange)thatIter.next() : null;
        while (thisRange != null && thatRange != null) {
            if (thisRange.getMinAddress().compareTo(thatRange.getMinAddress()) <= 0) {
                newSet.add(thisRange);
                thisRange = thisIter.hasNext() ? (AddressRange)thisIter.next() : null;
                continue;
            }
            newSet.add(thatRange);
            thatRange = thatIter.hasNext() ? (AddressRange)thatIter.next() : null;
        }
        while (thisRange != null) {
            newSet.add(thisRange);
            thisRange = thisIter.hasNext() ? (AddressRange)thisIter.next() : null;
        }
        while (thatRange != null) {
            newSet.add(thatRange);
            thatRange = thatIter.hasNext() ? (AddressRange)thatIter.next() : null;
        }
        return newSet;
    }

    private void consumeFollowOnNodes(RedBlackEntry<Address, Address> node) {
        Address rangeEnd = (Address)node.getValue();
        RedBlackEntry<Address, Address> nextNode = node.getSuccessor();
        while (nextNode != null) {
            Address nextStart = (Address)nextNode.getKey();
            if (rangeEnd.compareTo(nextStart) < 0 && !rangeEnd.isSuccessor(nextStart)) {
                return;
            }
            Address nextEnd = (Address)nextNode.getValue();
            if (nextEnd.compareTo(rangeEnd) > 0) {
                this.updateRangeEndAddress(node, nextEnd);
            }
            nextNode = this.deleteRangeNode(nextNode);
        }
    }

    private void checkValidRange(Address start, Address end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Attempted to add a null address to this set.");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start address must be less than or equal to end address:  Start " + start + "   end = " + end);
        }
        if (!start.getAddressSpace().equals(end.getAddressSpace())) {
            throw new IllegalArgumentException("Start and end addresses must be in same address space!  Start " + start + "   end = " + end);
        }
    }

    private RedBlackEntry<Address, Address> createRangeNode(Address start, Address end) {
        RedBlackEntry newEntry = this.rbTree.getOrCreateEntry((Comparable)start);
        newEntry.setValue((Object)end);
        this.addressCount += end.subtract(start) + 1L;
        return newEntry;
    }

    private void updateRangeEndAddress(RedBlackEntry<Address, Address> entry, Address newEnd) {
        this.addressCount += newEnd.subtract((Address)entry.getValue());
        entry.setValue((Object)newEnd);
    }

    private RedBlackEntry<Address, Address> deleteRangeNode(RedBlackEntry<Address, Address> entry) {
        RedBlackEntry successor = entry.getSuccessor();
        this.addressCount -= ((Address)entry.getValue()).subtract((Address)entry.getKey()) + 1L;
        this.rbTree.deleteEntry(entry);
        return successor;
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        if (set.getNumAddressRanges() > this.getNumAddressRanges()) {
            return set.findFirstAddressInCommon(this);
        }
        for (AddressRange addressRange : set) {
            Address start = addressRange.getMinAddress();
            Address end = addressRange.getMaxAddress();
            AddressIterator it = this.getAddresses(start, true);
            if (!it.hasNext()) break;
            Address addr = it.next();
            if (addr.compareTo(end) > 0) continue;
            return addr;
        }
        return null;
    }

    public void deleteFromMin(Address toAddr) {
        if (this.isEmpty()) {
            return;
        }
        if (toAddr.compareTo(this.getMinAddress()) < 0) {
            return;
        }
        this.delete(this.getMinAddress(), toAddr);
    }

    public void deleteToMax(Address fromAddr) {
        if (this.isEmpty()) {
            return;
        }
        if (fromAddr.compareTo(this.getMaxAddress()) > 0) {
            return;
        }
        this.delete(fromAddr, this.getMaxAddress());
    }

    static enum RangeCompare {
        RANGE1_COMPLETELY_BEFORE_RANGE2,
        RANGE1_STARTS_BEFORE_RANGE2_ENDS_INSIDE_RANGE2,
        RANGE1_STARTS_BEFORE_RANGE2_ENDS_AT_RANGE2_END,
        RANGE1_STARTS_BEFORE_RANGE2_ENDS_AFTER_RANGE2,
        RANGE1_STARTS_AT_RANGE2_ENDS_BEFORE_RANGE2,
        RANGE1_EQUALS_RANGE2,
        RANGE1_STARTS_AT_RANGE2_ENDS_AFTER_RANGE2,
        RANGE1_STARTS_INSIDE_RANGE2_ENDS_AT_RANGE2,
        RANGE1_STARTS_INSIDE_RANGE2_ENDS_INSIDE_RANGE2,
        RANGE1_STARTS_INSIDE_RANGE2_ENDS_AFTER_RANGE2,
        RANGE1_COMPLETELY_AFTER_RANGE2;

    }

    private class AddressRangeIteratorAdapter
    implements AddressRangeIterator {
        private Iterator<RedBlackEntry<Address, Address>> iterator;
        private AddressRange lastReturnedRange;

        public AddressRangeIteratorAdapter(Iterator<RedBlackEntry<Address, Address>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public AddressRange next() {
            RedBlackEntry<Address, Address> next = this.iterator.next();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedRange = new AddressRangeImpl((Address)next.getKey(), (Address)next.getValue());
            return this.lastReturnedRange;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            AddressSet.this.addressCount -= this.lastReturnedRange.getLength();
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }
    }

    private class MyAddressIterator
    implements AddressIterator {
        protected Address nextAddr = null;
        protected Address endAddr = null;
        protected final boolean forward;
        protected final ListIterator<RedBlackEntry<Address, Address>> it;

        private MyAddressIterator(Address start, boolean forward) {
            this.forward = forward;
            this.it = this.getIteratorContainingOrAfter(start);
            if (!this.it.hasNext()) {
                return;
            }
            RedBlackEntry<Address, Address> entry = this.it.next();
            if (start != null && AddressSet.this.contains(entry, start)) {
                this.nextAddr = start;
                this.endAddr = forward ? (Address)entry.getValue() : (Address)entry.getKey();
            } else {
                this.nextAddr = forward ? (Address)entry.getKey() : (Address)entry.getValue();
                this.endAddr = forward ? (Address)entry.getValue() : (Address)entry.getKey();
            }
        }

        private ListIterator<RedBlackEntry<Address, Address>> getIteratorContainingOrAfter(Address start) {
            RedBlackEntry entry;
            if (start == null) {
                return AddressSet.this.rbTree.iterator(this.forward);
            }
            if (!this.forward) {
                return AddressSet.this.rbTree.iterator((Comparable)start, false);
            }
            ListIterator iterator = AddressSet.this.rbTree.iterator((Comparable)start, true);
            if (iterator.hasPrevious() && !AddressSet.this.contains((RedBlackEntry<Address, Address>)(entry = (RedBlackEntry)iterator.previous()), start)) {
                iterator.next();
            }
            return iterator;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextAddr != null;
        }

        @Override
        public Address next() {
            if (this.nextAddr != null) {
                Address addr = this.nextAddr;
                this.findNext();
                return addr;
            }
            return null;
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }

        protected void findNext() {
            if (this.nextAddr.equals(this.endAddr)) {
                if (this.it.hasNext()) {
                    RedBlackEntry<Address, Address> entry = this.it.next();
                    this.nextAddr = this.forward ? (Address)entry.getKey() : (Address)entry.getValue();
                    this.endAddr = this.forward ? (Address)entry.getValue() : (Address)entry.getKey();
                    return;
                }
                this.nextAddr = null;
            } else {
                this.nextAddr = this.forward ? this.nextAddr.next() : this.nextAddr.previous();
            }
        }
    }
}

