/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.CallingConventionDBAdapter;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionDefinitionDBAdapterV1
extends FunctionDefinitionDBAdapter
implements RecordTranslator {
    static final int VERSION = 1;
    static final int V1_FUNCTION_DEF_NAME_COL = 0;
    static final int V1_FUNCTION_DEF_COMMENT_COL = 1;
    static final int V1_FUNCTION_DEF_CAT_ID_COL = 2;
    static final int V1_FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int V1_FUNCTION_DEF_FLAGS_COL = 4;
    static final int V1_FUNCTION_DEF_SOURCE_ARCHIVE_ID_COL = 5;
    static final int V1_FUNCTION_DEF_UNIVERSAL_DT_ID_COL = 6;
    static final int V1_FUNCTION_DEF_SOURCE_SYNC_TIME_COL = 7;
    static final int V1_FUNCTION_DEF_LAST_CHANGE_TIME_COL = 8;
    private static final int GENERIC_CALLING_CONVENTION_FLAG_MASK = 15;
    private static final int GENERIC_CALLING_CONVENTION_FLAG_SHIFT = 1;
    private Table table;
    private CallingConventionDBAdapter callConvAdapter;

    public FunctionDefinitionDBAdapterV1(DBHandle handle, String tablePrefix, CallingConventionDBAdapter callConvAdapter) throws VersionException {
        this.callConvAdapter = callConvAdapter;
        String tableName = tablePrefix + "Function Definitions";
        this.table = handle.getTable(tableName);
        if (this.table == null) {
            throw new VersionException(true);
        }
        int version = this.table.getSchema().getVersion();
        if (version != 1) {
            throw new VersionException(version < 1);
        }
    }

    @Override
    boolean usesGenericCallingConventionId() {
        return this.callConvAdapter == null;
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    DBRecord createRecord(String name, String comments, long categoryID, long returnDtID, boolean hasNoReturn, boolean hasVarArgs, byte callingConventionID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord getRecord(long functionDefID) throws IOException {
        return this.translateRecord(this.table.getRecord(functionDefID));
    }

    @Override
    void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    boolean removeRecord(long functionDefID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 5);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 6);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord record = this.table.getRecord(keys[i]);
            if (record.getLongValue(5) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = FunctionDefinitionDBAdapter.FUN_DEF_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setLongValue(2, oldRec.getLongValue(2));
        rec.setLongValue(3, oldRec.getLongValue(3));
        byte flags = oldRec.getByteValue(4);
        int mask = 30;
        int genericCallConvId = (flags & mask) >> 1;
        flags = (byte)(flags & (byte)(~mask));
        byte callingConventionId = 0;
        try {
            if (this.callConvAdapter == null) {
                callingConventionId = (byte)genericCallConvId;
            } else {
                String callingConvention = FunctionDefinitionDBAdapterV1.getGenericCallingConventionName(genericCallConvId);
                callingConventionId = this.callConvAdapter.getCallingConventionId(callingConvention, cc -> {});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rec.setByteValue(4, flags);
        rec.setByteValue(5, callingConventionId);
        rec.setLongValue(6, 0L);
        rec.setLongValue(7, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(8, 0L);
        rec.setLongValue(9, 0L);
        return rec;
    }
}

