/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model.iface1;

import com.sun.jdi.connect.Connector;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public interface JdiModelTargetLauncher
extends JdiModelTargetObject,
TargetLauncher {
    public static TargetMethod.ParameterDescription<Boolean> createBooleanParameter(Connector.BooleanArgument arg) {
        return TargetMethod.ParameterDescription.create(Boolean.class, (String)arg.name(), (boolean)arg.mustSpecify(), (Object)arg.booleanValue(), (String)arg.label(), (String)arg.description());
    }

    public static TargetMethod.ParameterDescription<Integer> createIntegerParameter(Connector.IntegerArgument arg) {
        return TargetMethod.ParameterDescription.create(Integer.class, (String)arg.name(), (boolean)arg.mustSpecify(), (Object)arg.intValue(), (String)arg.label(), (String)arg.description());
    }

    public static TargetMethod.ParameterDescription<String> createStringParameter(Connector.StringArgument arg) {
        return JdiModelTargetLauncher.createGenericParameter(arg);
    }

    public static TargetMethod.ParameterDescription<String> createSelectedParameter(Connector.SelectedArgument arg) {
        return TargetMethod.ParameterDescription.choices(String.class, (String)arg.name(), arg.choices(), (String)arg.label(), (String)arg.description());
    }

    public static TargetMethod.ParameterDescription<String> createGenericParameter(Connector.Argument arg) {
        return TargetMethod.ParameterDescription.create(String.class, (String)arg.name(), (boolean)arg.mustSpecify(), (Object)arg.value(), (String)arg.label(), (String)arg.description());
    }

    public static TargetMethod.ParameterDescription<?> createParameter(Connector.Argument arg) {
        if (arg instanceof Connector.BooleanArgument) {
            return JdiModelTargetLauncher.createBooleanParameter((Connector.BooleanArgument)arg);
        }
        if (arg instanceof Connector.IntegerArgument) {
            return JdiModelTargetLauncher.createIntegerParameter((Connector.IntegerArgument)arg);
        }
        if (arg instanceof Connector.StringArgument) {
            return JdiModelTargetLauncher.createStringParameter((Connector.StringArgument)arg);
        }
        if (arg instanceof Connector.SelectedArgument) {
            return JdiModelTargetLauncher.createSelectedParameter((Connector.SelectedArgument)arg);
        }
        return JdiModelTargetLauncher.createGenericParameter(arg);
    }

    public static Map<String, TargetMethod.ParameterDescription<?>> getParameters(Map<String, Connector.Argument> defaultArguments) {
        return defaultArguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JdiModelTargetLauncher.createParameter((Connector.Argument)e.getValue())));
    }

    public static Map<String, Connector.Argument> getArguments(Map<String, Connector.Argument> defaultArguments, Map<String, TargetMethod.ParameterDescription<?>> parameters, Map<String, ?> arguments) {
        Map validated = TargetMethod.validateArguments(parameters, arguments, (boolean)false);
        Iterator<Connector.Argument> iterator = defaultArguments.values().iterator();
        while (iterator.hasNext()) {
            Connector.Argument arg;
            Object val = parameters.get((arg = iterator.next()).name()).get(validated);
            arg.setValue(val == null ? null : val.toString());
        }
        return defaultArguments;
    }
}

