/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model.iface1;

import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface JdiModelTargetFocusScope
extends JdiModelTargetObject,
TargetFocusScope {
    public JdiModelSelectableObject getFocus();

    public boolean setFocus(JdiModelSelectableObject var1);

    default public CompletableFuture<Void> requestFocus(TargetObject obj) {
        this.getModel().assertMine(TargetObject.class, obj);
        if (obj.equals((Object)this.getFocus())) {
            return CompletableFuture.completedFuture(null);
        }
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        for (TargetObject cur = obj; cur != null; cur = cur.getParent()) {
            if (!(cur instanceof JdiModelSelectableObject)) continue;
            JdiModelSelectableObject sel = (JdiModelSelectableObject)cur;
            this.setFocus(sel);
            return sel.setActive();
        }
        return AsyncUtils.nil();
    }
}

