/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventHandler;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.JdiReason;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReference;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReferenceContainer;
import ghidra.dbg.jdi.model.JdiModelTargetRegisterContainer;
import ghidra.dbg.jdi.model.JdiModelTargetStack;
import ghidra.dbg.jdi.model.JdiModelTargetStackFrame;
import ghidra.dbg.jdi.model.JdiModelTargetThreadGroupContainer;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetAccessConditioned;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetExecutionStateful;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetFocusScope;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetInterruptible;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetKillable;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetResumable;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetSteppable;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Thread", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(name="Registers", type=JdiModelTargetRegisterContainer.class, required=true, fixed=true), @TargetAttributeType(name="Stack", type=JdiModelTargetStack.class, required=true, fixed=true), @TargetAttributeType(name="Status", type=Integer.class), @TargetAttributeType(name="UID", type=Long.class, fixed=true), @TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class JdiModelTargetThread
extends JdiModelTargetObjectReference
implements TargetThread,
JdiModelTargetAccessConditioned,
JdiModelTargetExecutionStateful,
JdiModelTargetInterruptible,
JdiModelTargetKillable,
JdiModelTargetResumable,
JdiModelTargetSteppable,
JdiEventsListenerAdapter,
JdiModelSelectableObject {
    protected static final TargetSteppable.TargetStepKindSet SUPPORTED_KINDS = TargetSteppable.TargetStepKindSet.of((TargetSteppable.TargetStepKind[])new TargetSteppable.TargetStepKind[]{TargetSteppable.TargetStepKind.FINISH, TargetSteppable.TargetStepKind.LINE, TargetSteppable.TargetStepKind.OVER, TargetSteppable.TargetStepKind.OVER_LINE, TargetSteppable.TargetStepKind.RETURN, TargetSteppable.TargetStepKind.UNTIL, TargetSteppable.TargetStepKind.EXTENDED});
    private EventRequestManager eventManager;
    protected final ThreadReference thread;
    protected final JdiModelTargetStack stack;
    protected final JdiModelTargetRegisterContainer registers;
    protected JdiModelTargetLocation location;
    protected JdiModelTargetThreadGroupContainer threadGroup;
    protected JdiModelTargetObjectReference currentContendedMonitor;
    protected JdiModelTargetObjectReferenceContainer ownedMonitors;
    protected JdiModelTargetAttributesContainer addedAttributes;

    public JdiModelTargetThread(JdiModelTargetObject parent, ThreadReference thread, boolean isElement) {
        super(parent, thread.name(), thread, isElement);
        this.thread = thread;
        this.eventManager = thread.virtualMachine().eventRequestManager();
        this.stack = new JdiModelTargetStack(this);
        this.registers = new JdiModelTargetRegisterContainer(this);
        this.impl.getManager().addEventsListener(this.targetVM.vm, this);
        TargetExecutionStateful.TargetExecutionState targetState = this.convertState(thread.status());
        this.display = this.getDisplay();
        this.changeAttributes(List.of(), List.of(this.registers, this.stack), Map.of("_state", targetState, "Status", thread.status(), "_accessible", thread.isSuspended(), "_supported_step_kinds", SUPPORTED_KINDS, "_display", this.display), "Initialized");
        this.getManager().addStateListener(thread.virtualMachine(), this.accessListener);
    }

    private void populateAttributes() {
        this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
        HashMap<String, Comparable<Boolean>> attrs = new HashMap<String, Comparable<Boolean>>();
        attrs.put("isAtBreakpoint", Boolean.valueOf(this.thread.isAtBreakpoint()));
        attrs.put("isCollected", Boolean.valueOf(this.thread.isCollected()));
        attrs.put("isSuspended", Boolean.valueOf(this.thread.isSuspended()));
        try {
            attrs.put("entryCount", Integer.valueOf(this.thread.entryCount()));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        try {
            attrs.put("frameCount", Integer.valueOf(this.thread.frameCount()));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        attrs.put("suspendCount", Integer.valueOf(this.thread.suspendCount()));
        this.addedAttributes.addAttributes(attrs);
    }

    @Override
    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        ThreadGroupReference tg;
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.addedAttributes), Map.of(), "Initialized");
        if (this.targetVM.vm.canGetCurrentContendedMonitor()) {
            try {
                ObjectReference monitor = this.thread.currentContendedMonitor();
                if (monitor != null) {
                    this.currentContendedMonitor = (JdiModelTargetObjectReference)this.getInstance(monitor);
                    if (this.currentContendedMonitor != null) {
                        this.changeAttributes(List.of(), List.of(), Map.of("Current Contended Monitor", this.currentContendedMonitor), "Initialized");
                    }
                }
            }
            catch (IncompatibleThreadStateException monitor) {
                // empty catch block
            }
        }
        if (this.targetVM.vm.canGetOwnedMonitorInfo()) {
            try {
                this.ownedMonitors = new JdiModelTargetObjectReferenceContainer(this, "Owned Monitors", this.thread.ownedMonitors());
                if (this.ownedMonitors != null) {
                    this.changeAttributes(List.of(), List.of(this.ownedMonitors), Map.of(), "Initialized");
                }
            }
            catch (IncompatibleThreadStateException monitor) {
                // empty catch block
            }
        }
        JdiModelTargetThreadGroupContainer jdiModelTargetThreadGroupContainer = this.threadGroup = (tg = this.thread.threadGroup()) == null ? null : new JdiModelTargetThreadGroupContainer(this, tg, false);
        if (this.threadGroup != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("Thread Group", this.thread.threadGroup()), "Initialized");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        AsyncFence fence = new AsyncFence();
        return fence.ready();
    }

    @Override
    public String getDisplay() {
        JdiModelTargetStackFrame top;
        if (this.thread == null) {
            return super.getDisplay();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.thread.name());
        if (this.location != null) {
            sb.append(" in ");
            sb.append(this.location);
        }
        if ((top = this.stack.framesByLevel.get(0)) != null && top.location != null) {
            sb.append(" in ");
            sb.append(top.location.getDisplay());
        }
        return sb.toString();
    }

    protected TargetExecutionStateful.TargetExecutionState convertState(int state) {
        switch (state) {
            case 1: 
            case 4: {
                return this.thread.isSuspended() ? TargetExecutionStateful.TargetExecutionState.STOPPED : TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
            case 5: {
                return TargetExecutionStateful.TargetExecutionState.ALIVE;
            }
        }
        return TargetExecutionStateful.TargetExecutionState.STOPPED;
    }

    @Override
    public void stepComplete(StepEvent evt, JdiCause cause) {
        if (evt.thread().equals(this.thread)) {
            this.setLocation(evt.location());
            this.changeAttributes(List.of(), List.of(), Map.of("Location", this.location), "Refreshed");
            this.stateChanged(this.thread.status(), JdiReason.Reasons.STEP);
        }
    }

    @Override
    public void breakpointHit(BreakpointEvent evt, JdiCause cause) {
        if (evt.thread().equals(this.thread)) {
            this.setLocation(evt.location());
            this.changeAttributes(List.of(), List.of(), Map.of("Location", this.location), "Refreshed");
            this.stateChanged(this.thread.status(), JdiReason.Reasons.BREAKPOINT_HIT);
        }
    }

    @Override
    public void watchpointHit(WatchpointEvent evt, JdiCause cause) {
        if (evt.thread().equals(this.thread)) {
            this.setLocation(evt.location());
            this.changeAttributes(List.of(), List.of(), Map.of("Location", this.location), "Refreshed");
            this.stateChanged(this.thread.status(), JdiReason.Reasons.WATCHPOINT_HIT);
        }
    }

    @Override
    public void accessWatchpointHit(AccessWatchpointEvent evt, JdiCause cause) {
        if (evt.thread().equals(this.thread)) {
            this.setLocation(evt.location());
            this.changeAttributes(List.of(), List.of(), Map.of("Location", this.location), "Refreshed");
            this.stateChanged(this.thread.status(), JdiReason.Reasons.ACCESS_WATCHPOINT_HIT);
        }
    }

    @Override
    public void threadSelected(ThreadReference eventThread, StackFrame frame, JdiCause cause) {
        if (eventThread.equals(this.thread) && frame == null) {
            ((JdiModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    private void stateChanged(int state, JdiReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = this.convertState(state);
        if (targetState.equals((Object)TargetExecutionStateful.TargetExecutionState.STOPPED)) {
            this.update();
            this.threadSelected(this.thread, null, JdiCause.Causes.UNCLAIMED);
        }
        this.targetVM.vmStateChanged(targetState, reason);
        JdiEventHandler eventHandler = this.getManager().getEventHandler(this.targetVM.vm);
        ((JdiEventsListener)eventHandler.listenersEvent.invoke()).threadStateChanged(this.thread, state, JdiCause.Causes.UNCLAIMED, reason);
    }

    public void threadStateChanged(TargetExecutionStateful.TargetExecutionState targetState) {
        this.changeAttributes(List.of(), List.of(), Map.of("_state", targetState), "Refreshed");
    }

    protected CompletableFuture<?> update() {
        this.registers.update();
        return ((CompletableFuture)this.stack.update().thenAccept(__ -> this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Refreshed"))).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not update stack for thread " + this), (Throwable)ex);
            return null;
        });
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> kill() {
        this.thread.interrupt();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> interrupt() {
        this.thread.suspend();
        this.stateChanged(this.thread.status(), JdiReason.Reasons.INTERRUPT);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> popFrame(StackFrame frame) {
        try {
            this.thread.popFrames(frame);
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> resume() {
        this.targetVM.vmStateChanged(TargetExecutionStateful.TargetExecutionState.RUNNING, JdiReason.Reasons.RESUMED);
        this.invalidateAndContinue();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        int size = -1;
        StepRequest request = this.eventManager.createStepRequest(this.thread, size, switch (kind) {
            case TargetSteppable.TargetStepKind.INTO -> 1;
            case TargetSteppable.TargetStepKind.LINE -> -2;
            case TargetSteppable.TargetStepKind.FINISH -> 3;
            case TargetSteppable.TargetStepKind.SKIP -> 2;
            default -> -1;
        });
        request.enable();
        this.invalidateAndContinue();
        return CompletableFuture.completedFuture(null);
    }

    private void invalidateAndContinue() {
        this.targetVM.invalidateMemoryAndRegisterCaches();
        this.stack.invalidateRegisterCaches();
        this.registers.invalidateRegisterCaches();
        this.thread.resume();
    }

    public JdiModelTargetStack getStack() {
        return this.stack;
    }

    public Location getLocation() {
        return this.location == null ? null : this.location.location;
    }

    public void setLocation(Location location) {
        this.location = new JdiModelTargetLocation(this, location, false);
        Method method = location.method();
        this.impl.registerMethod(method);
    }

    @Override
    public void threadStarted(ThreadStartEvent evt, JdiCause cause) {
        this.threadSelected(evt.thread(), null, JdiCause.Causes.UNCLAIMED);
    }

    @Override
    public boolean isAccessible() {
        return this.thread.isSuspended();
    }
}

