/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import ghidra.pcode.memstate.MemoryState;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public abstract class AbstractMemoryState
implements MemoryState {
    final Language language;

    public AbstractMemoryState(Language language) {
        this.language = language;
    }

    @Override
    public final void setValue(Varnode vn, long cval) {
        Address addr = vn.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), cval);
    }

    @Override
    public final void setValue(Register reg, long cval) {
        Address addr = reg.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), cval);
    }

    @Override
    public final void setValue(String nm, long cval) {
        this.setValue(this.language.getRegister(nm), cval);
    }

    @Override
    public final void setValue(AddressSpace spc, long off, int size, long cval) {
        this.setChunk(Utils.longToBytes((long)cval, (int)size, (boolean)this.language.isBigEndian()), spc, off, size);
    }

    @Override
    public final long getValue(Varnode vn) {
        Address addr = vn.getAddress();
        return this.getValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize());
    }

    @Override
    public final long getValue(Register reg) {
        Address addr = reg.getAddress();
        return this.getValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize());
    }

    @Override
    public final long getValue(String nm) {
        return this.getValue(this.language.getRegister(nm));
    }

    @Override
    public final long getValue(AddressSpace spc, long off, int size) {
        if (spc.isConstantSpace()) {
            return off;
        }
        byte[] bytes = new byte[size];
        this.getChunk(bytes, spc, off, size, false);
        return Utils.bytesToLong((byte[])bytes, (int)size, (boolean)this.language.isBigEndian());
    }

    @Override
    public final void setValue(Varnode vn, BigInteger cval) {
        Address addr = vn.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), cval);
    }

    @Override
    public final void setValue(Register reg, BigInteger cval) {
        Address addr = reg.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), cval);
    }

    @Override
    public final void setValue(String nm, BigInteger cval) {
        this.setValue(this.language.getRegister(nm), cval);
    }

    @Override
    public final void setValue(AddressSpace spc, long off, int size, BigInteger cval) {
        this.setChunk(Utils.bigIntegerToBytes((BigInteger)cval, (int)size, (boolean)this.language.isBigEndian()), spc, off, size);
    }

    @Override
    public final BigInteger getBigInteger(Varnode vn, boolean signed) {
        Address addr = vn.getAddress();
        return this.getBigInteger(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), signed);
    }

    @Override
    public final BigInteger getBigInteger(Register reg) {
        Address addr = reg.getAddress();
        return this.getBigInteger(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), false);
    }

    @Override
    public final BigInteger getBigInteger(String nm) {
        return this.getBigInteger(this.language.getRegister(nm));
    }

    @Override
    public final BigInteger getBigInteger(AddressSpace spc, long off, int size, boolean signed) {
        if (spc.isConstantSpace()) {
            if (!signed && off < 0L) {
                return new BigInteger(1, Utils.longToBytes((long)off, (int)8, (boolean)true));
            }
            return BigInteger.valueOf(off);
        }
        byte[] bytes = new byte[size];
        this.getChunk(bytes, spc, off, size, false);
        return Utils.bytesToBigInteger((byte[])bytes, (int)size, (boolean)this.language.isBigEndian(), (boolean)signed);
    }
}

