/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.test.processors.support.EmulatorTestRunner;
import ghidra.test.processors.support.PCodeTestAbstractControlBlock;
import ghidra.test.processors.support.PCodeTestFile;
import ghidra.test.processors.support.PCodeTestGroup;
import ghidra.test.processors.support.PCodeTestGroupControlBlock;
import ghidra.test.processors.support.PCodeTestResults;
import ghidra.test.processors.support.TestLogger;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class PCodeTestControlBlock
extends PCodeTestAbstractControlBlock {
    static final String INITIAL_FUNCTION_NAME = "<NONE>";
    static final String UNKNOWN_FUNCTION_NAME = "<UNKNOWN>";
    private static final String MAIN_CONTROL_BLOCK_MAGIC = "AbCdEFgH";
    private static Structure testInfoStruct;
    private static Structure groupInfoStruct;
    private final AddressSetView restrictedSet;
    public final PCodeTestFile testFile;
    public final String cachedProgramPath;
    private List<PCodeTestGroup> testGroups;
    private int ignoredPassed = 0;
    private int ignoredFailed = 0;
    private Address onPassFunctionAddress;
    private Address onErrorFunctionAddress;
    private Address onDoneFunctionAddress;
    private Address sprintfFunctionAddress;
    private Address sprintfBufferAddress;
    private int numPassOffset;
    private int numFailOffset;
    private int lastTestPosOffset;
    private int lastErrorLineOffset;
    private int lastErrorFileOffset;
    private int lastFuncOffset;
    private int sprintfEnableOffset;
    private final PCodeTestResults testResults;

    private PCodeTestControlBlock(Program program, AddressSetView restrictedSet, Address testInfoStructAddr, PCodeTestFile testFile, String cachedProgramPath, boolean applyStruct, PCodeTestResults testResults) throws PCodeTestAbstractControlBlock.InvalidControlBlockException, CodeUnitInsertionException {
        super(program, testInfoStructAddr, testInfoStruct);
        this.restrictedSet = restrictedSet;
        this.testFile = testFile;
        this.cachedProgramPath = cachedProgramPath;
        this.testResults = testResults;
        this.readControlBlock(applyStruct);
        this.numPassOffset = this.getStructureComponent(this.infoProgramStruct, "numpass");
        this.numFailOffset = this.getStructureComponent(this.infoProgramStruct, "numfail");
        this.lastTestPosOffset = this.getStructureComponent(this.infoProgramStruct, "lastTestPos");
        this.lastErrorLineOffset = this.getStructureComponent(this.infoProgramStruct, "lastErrorLine");
        this.lastErrorFileOffset = this.getStructureComponent(this.infoProgramStruct, "lastErrorFile");
        this.lastFuncOffset = this.getStructureComponent(this.infoProgramStruct, "lastFunc");
        this.sprintfEnableOffset = this.getStructureComponent(this.infoProgramStruct, "sprintf5Enabled");
    }

    static PCodeTestControlBlock getMainControlBlock(Program program, PCodeTestFile testFile, AddressSetView restrictedSet, String cachedProgramPath, Structure testInfoStruct, Structure groupInfoStruct, boolean applyStruct, PCodeTestResults testResults) throws PCodeTestAbstractControlBlock.InvalidControlBlockException, CodeUnitInsertionException {
        byte[] magicBytes;
        PCodeTestControlBlock.testInfoStruct = testInfoStruct;
        PCodeTestControlBlock.groupInfoStruct = groupInfoStruct;
        Memory memory = program.getMemory();
        Address startOfControlBlock = PCodeTestControlBlock.findBytes(memory, restrictedSet, magicBytes = PCodeTestControlBlock.getCharArrayBytes(program, MAIN_CONTROL_BLOCK_MAGIC));
        if (startOfControlBlock == null) {
            throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("TestInfo structure not found");
        }
        return new PCodeTestControlBlock(program, restrictedSet, startOfControlBlock, testFile, cachedProgramPath, applyStruct, testResults);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.testFile;
    }

    public List<PCodeTestGroup> getTestGroups() {
        return this.testGroups;
    }

    public Address getBreakOnDoneAddress() {
        return this.onDoneFunctionAddress;
    }

    public Address getBreakOnPassAddress() {
        return this.onPassFunctionAddress;
    }

    public Address getBreakOnErrorAddress() {
        return this.onErrorFunctionAddress;
    }

    public Address getSprintf5Address() {
        return this.sprintfFunctionAddress;
    }

    public Address getPrintfBufferAddress() {
        return this.sprintfBufferAddress;
    }

    public PCodeTestResults getTestResults() {
        return this.testResults;
    }

    @Override
    protected void readControlBlock(boolean applyStruct) throws PCodeTestAbstractControlBlock.InvalidControlBlockException, CodeUnitInsertionException {
        super.readControlBlock(applyStruct);
        int ptrSzOffset = this.getStructureComponent(this.infoProgramStruct, "ptrSz");
        int byteOrderOffset = this.getStructureComponent(this.infoProgramStruct, "byteOrder");
        int onPassPtrOffset = this.getStructureComponent(this.infoProgramStruct, "onPass");
        int onErrorPtrOffset = this.getStructureComponent(this.infoProgramStruct, "onError");
        int onDonePtrOffset = this.getStructureComponent(this.infoProgramStruct, "onDone");
        int sprintfPtrOffset = this.getStructureComponent(this.infoProgramStruct, "sprintf5");
        int sprintfBufferPtrOffset = this.getStructureComponent(this.infoProgramStruct, "sprintf5buffer");
        if (applyStruct) {
            this.forceCodePointer(this.infoStructAddr.add((long)onPassPtrOffset));
            this.forceCodePointer(this.infoStructAddr.add((long)onErrorPtrOffset));
            this.forceCodePointer(this.infoStructAddr.add((long)onDonePtrOffset));
            this.forceCodePointer(this.infoStructAddr.add((long)sprintfBufferPtrOffset));
        }
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.program.getMemory(), this.infoStructAddr);
        try {
            int byteOrder = memBuffer.getInt(byteOrderOffset);
            if (byteOrder != 16909060) {
                throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("TestInfo @ " + this.infoStructAddr.toString(true) + " has invalid byteOrder - language endianess may be incorrect (" + Integer.toHexString(byteOrder) + ")");
            }
            int ptrSize = memBuffer.getInt(ptrSzOffset);
            DataOrganization dataOrganization = this.program.getDataTypeManager().getDataOrganization();
            if ((ptrSize *= dataOrganization.getCharSize()) < 2 || ptrSize > 8) {
                throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("TestInfo @ " + this.infoStructAddr.toString(true) + " has unsupported pointer size: " + ptrSize);
            }
            if (ptrSize != this.pointerSize) {
                String id = this.program.getLanguageID() + ":" + this.program.getCompilerSpec().getCompilerSpecID();
                Msg.warn((Object)this, (Object)("TestInfo @ " + this.infoStructAddr.toString(true) + " ptrSz=" + ptrSize + " differs from data-organization size of " + this.pointerSize + " (" + id + ")"));
            }
            this.onPassFunctionAddress = this.readCodePointer((MemBuffer)memBuffer, onPassPtrOffset, applyStruct);
            this.onErrorFunctionAddress = this.readCodePointer((MemBuffer)memBuffer, onErrorPtrOffset, applyStruct);
            this.onDoneFunctionAddress = this.readCodePointer((MemBuffer)memBuffer, onDonePtrOffset, applyStruct);
            this.sprintfFunctionAddress = this.readCodePointer((MemBuffer)memBuffer, sprintfPtrOffset, applyStruct);
            this.sprintfBufferAddress = this.readCodePointer((MemBuffer)memBuffer, sprintfBufferPtrOffset, applyStruct);
        }
        catch (MemoryAccessException e) {
            throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("TestInfo program read error", e);
        }
        this.findTestGroups(applyStruct);
    }

    private void findTestGroups(boolean applyStruct) throws PCodeTestAbstractControlBlock.InvalidControlBlockException, CodeUnitInsertionException {
        Address startOfControlBlock;
        Memory memory = this.program.getMemory();
        byte[] groupStructMagicBytes = PCodeTestControlBlock.getCharArrayBytes(this.program, "aBcDefGh");
        this.testGroups = new ArrayList<PCodeTestGroup>();
        AddressSet set = new AddressSet(this.restrictedSet);
        while ((startOfControlBlock = PCodeTestControlBlock.findBytes(memory, (AddressSetView)set, groupStructMagicBytes)) != null) {
            PCodeTestGroupControlBlock controlBlock = new PCodeTestGroupControlBlock(this.program, startOfControlBlock, groupInfoStruct, applyStruct, this);
            PCodeTestGroup testGroup = new PCodeTestGroup(controlBlock);
            this.testGroups.add(testGroup);
            Address endAddr = startOfControlBlock.add((long)groupInfoStruct.getLength()).previous();
            AddressRange nextRange = set.getFirstRange();
            while (nextRange != null && !nextRange.contains(endAddr)) {
                set.delete(nextRange);
                nextRange = set.getFirstRange();
            }
            if (!set.contains(endAddr)) continue;
            set = set.subtract((AddressSetView)new AddressSet(set.getMinAddress(), startOfControlBlock.add((long)groupInfoStruct.getLength()).previous()));
        }
        if (this.testGroups.size() == 0) {
            throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("P-Code test binary does not define any test groups");
        }
    }

    void setSprintfEnabled(EmulatorTestRunner emuTestRunner, boolean enable) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.sprintfEnableOffset));
        this.emuWrite(emuTestRunner.getEmulatorHelper(), addr, 4, enable ? 1L : 0L);
    }

    int getNumberPassed(EmulatorTestRunner emuTestRunner) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.numPassOffset));
        return (int)this.emuRead(emuTestRunner.getEmulatorHelper(), addr, 4);
    }

    void setNumberPassed(EmulatorTestRunner emuTestRunner, int value) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.numPassOffset));
        this.emuWrite(emuTestRunner.getEmulatorHelper(), addr, 4, value);
    }

    void resultIgnored(String testGroupName, String testName, boolean passed) {
        if (passed) {
            ++this.ignoredPassed;
        } else {
            ++this.ignoredFailed;
        }
        this.testResults.addIgnoredResult(testGroupName, testName);
    }

    int getNumberPassedIgnored() {
        return this.ignoredPassed;
    }

    int getNumberFailedIgnored() {
        return this.ignoredFailed;
    }

    void clearNumberIgnored() {
        this.ignoredFailed = 0;
        this.ignoredPassed = 0;
    }

    int getNumberFailed(EmulatorTestRunner emuTestRunner) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.numFailOffset));
        return (int)this.emuRead(emuTestRunner.getEmulatorHelper(), addr, 4);
    }

    void setNumberFailed(EmulatorTestRunner emuTestRunner, int value) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.numFailOffset));
        this.emuWrite(emuTestRunner.getEmulatorHelper(), addr, 4, value);
    }

    int getLastTestIndex(EmulatorTestRunner emuTestRunner) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.lastTestPosOffset));
        return (int)this.emuRead(emuTestRunner.getEmulatorHelper(), addr, 4);
    }

    int getLastErrorLine(EmulatorTestRunner emuTestRunner) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.lastErrorLineOffset));
        return (int)this.emuRead(emuTestRunner.getEmulatorHelper(), addr, 4);
    }

    String getLastErrorFile(EmulatorTestRunner emuTestRunner) {
        Address addr = this.getMirroredDataAddress(emuTestRunner, this.infoStructAddr.add((long)this.lastErrorFileOffset));
        long fileNameOffset = this.emuRead(emuTestRunner.getEmulatorHelper(), addr, this.pointerSize);
        addr = addr.getNewAddress(fileNameOffset, true);
        addr = this.getMirroredDataAddress(emuTestRunner, addr);
        return this.emuReadString(emuTestRunner.getEmulatorHelper(), addr);
    }

    String getLastFunctionName(EmulatorTestRunner emuTestRunner, TestLogger logger, PCodeTestGroup activeGroup) {
        Address ptrStorageAddr = this.infoStructAddr.add((long)this.lastFuncOffset);
        Address ptrAddr = this.getMirroredDataAddress(emuTestRunner, ptrStorageAddr);
        long funcNameOffset = this.emuRead(emuTestRunner.getEmulatorHelper(), ptrAddr, this.pointerSize);
        Address strAddr = ptrAddr.getNewAddress(funcNameOffset, true);
        strAddr = this.getMirroredDataAddress(emuTestRunner, strAddr);
        String fnName = this.emuReadString(emuTestRunner.getEmulatorHelper(), strAddr);
        if ("none".equals(fnName)) {
            if (logger != null) {
                logger.log(activeGroup, "ERROR last executed function name pointer stored at " + ptrStorageAddr + " has not been set (reported as <NONE>)");
            }
            return INITIAL_FUNCTION_NAME;
        }
        String altName = null;
        if (!fnName.endsWith(PCodeTestGroupControlBlock.TEST_GROUP_FUNCTION_SUFFIX)) {
            altName = fnName + PCodeTestGroupControlBlock.TEST_GROUP_FUNCTION_SUFFIX;
        }
        if (activeGroup != null) {
            if (activeGroup.controlBlock.getFunctionInfo(fnName) != null) {
                return fnName;
            }
            if (altName != null && activeGroup.controlBlock.getFunctionInfo(altName) != null) {
                return fnName;
            }
        }
        if (logger != null) {
            logger.log(activeGroup, "ERROR last executed function name pointer stored at " + ptrStorageAddr + " was improperly set (reported as <UNKNOWN>, pointer=" + strAddr + ")");
        }
        return UNKNOWN_FUNCTION_NAME;
    }
}

