/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.widgets.values.AbstractValue;
import docking.widgets.values.ValuesMapParseException;
import ghidra.features.base.values.AbstractProjectBrowserPanel;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import javax.swing.JComponent;

public class ProjectFolderValue
extends AbstractValue<DomainFolder> {
    private Project project;
    private ProjectFolderBrowserPanel domainFilePanel;

    public ProjectFolderValue(String name) {
        this(name, null);
    }

    public ProjectFolderValue(String name, String defaultValuePath) {
        this(name, AppInfo.getActiveProject(), defaultValuePath);
    }

    public ProjectFolderValue(String name, Project project, String defaultValuePath) {
        super(name, (Object)AbstractProjectBrowserPanel.parseDomainFolder(project, defaultValuePath));
        this.project = project;
    }

    public JComponent getComponent() {
        if (this.domainFilePanel == null) {
            this.domainFilePanel = new ProjectFolderBrowserPanel(this.project, this.getName(), null);
        }
        return this.domainFilePanel;
    }

    protected void updateValueFromComponent() throws ValuesMapParseException {
        if (this.domainFilePanel != null) {
            DomainFolder domainFolder = this.domainFilePanel.getDomainFolder();
            if (domainFolder == null) {
                String text = this.domainFilePanel.getText();
                if (text.isBlank()) {
                    this.setValue(null);
                    return;
                }
                throw new ValuesMapParseException(this.getName(), "Project Folder", "No folder found for \"" + text + "\"");
            }
            this.setValue(domainFolder);
        }
    }

    protected void updateComponentFromValue() {
        if (this.domainFilePanel != null) {
            this.domainFilePanel.setDomainFolder((DomainFolder)this.getValue());
        }
    }

    protected DomainFolder fromString(String valueString) {
        DomainFolder df = AbstractProjectBrowserPanel.parseDomainFolder(this.project, valueString);
        if (df == null) {
            throw new IllegalArgumentException("Can't find domain folder: " + valueString);
        }
        return df;
    }

    protected String toString(DomainFolder v) {
        return v.getPathname();
    }

    class ProjectFolderBrowserPanel
    extends AbstractProjectBrowserPanel {
        ProjectFolderBrowserPanel(Project project, String name, String startPath) {
            super(2, project, name, startPath);
        }

        void setDomainFolder(DomainFolder value) {
            String text = value == null ? "" : value.getPathname();
            this.textField.setText(text);
        }

        @Override
        protected void intializeCurrentValue(DataTreeDialog dialog) {
            DomainFolder current = this.getDomainFolder();
            dialog.selectFolder(current);
        }

        @Override
        protected String getSelectedPath(DataTreeDialog dialog) {
            return dialog.getDomainFolder().getPathname();
        }

        DomainFolder getDomainFolder() {
            String text = this.textField.getText().trim();
            if (text.isBlank()) {
                return ProjectFolderBrowserPanel.parseDomainFolder(this.project, "/");
            }
            return ProjectFolderBrowserPanel.parseDomainFolder(this.project, text);
        }
    }
}

