/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import generic.theme.GThemeDefaults;
import ghidra.app.util.viewer.util.TitledPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ExtensionPoint;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class CodeComparisonPanel<T extends FieldPanelCoordinator>
extends JPanel
implements ExtensionPoint,
FocusListener {
    protected static final int MINIMUM_PANEL_WIDTH = 50;
    protected static final int LEFT = 0;
    protected static final int RIGHT = 1;
    private static final Color FOCUS_BORDER_COLOR = GThemeDefaults.Colors.Palette.getColor((String)"lightpink");
    protected static final Border FOCUS_BORDER = BorderFactory.createMatteBorder(3, 3, 3, 3, FOCUS_BORDER_COLOR);
    protected static final Border NON_FOCUS_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    protected static final AddressSetView EMPTY_ADDRESS_SET = new AddressSet();
    protected String owner;
    protected PluginTool tool;
    protected JComponent topComp;
    protected JComponent bottomComp;
    protected TitledPanel[] titlePanels = new TitledPanel[2];
    protected String leftTitlePrefix = "";
    protected String rightTitlePrefix = "";
    protected int currProgramIndex = 0;
    protected Program[] programs = new Program[2];
    protected Function[] functions = new Function[2];
    protected Data[] data = new Data[2];
    private boolean showTitles = true;
    private boolean syncScrolling = false;
    private T fieldPanelCoordinator;

    protected CodeComparisonPanel(String owner, PluginTool tool) {
        this.owner = owner;
        this.tool = tool;
    }

    public abstract JComponent getComponent();

    public abstract String getTitle();

    protected abstract void setPrograms(Program var1, Program var2);

    public abstract void loadFunctions(Function var1, Function var2);

    public abstract void loadData(Data var1, Data var2);

    public abstract void loadAddresses(Program var1, Program var2, AddressSetView var3, AddressSetView var4);

    public abstract void dispose();

    public abstract void setMouseNavigationEnabled(boolean var1);

    public DockingAction[] getActions() {
        DockingAction[] actions = new DockingAction[]{};
        return actions;
    }

    public boolean getShowTitles() {
        return this.showTitles;
    }

    public void setShowTitles(boolean showTitles) {
        this.showTitles = showTitles;
    }

    public abstract ActionContext getActionContext(ComponentProvider var1, MouseEvent var2);

    public abstract void programRestored(Program var1);

    public abstract boolean leftPanelHasFocus();

    public abstract void setTitlePrefixes(String var1, String var2);

    public Program getLeftProgram() {
        return this.programs[0];
    }

    public Program getRightProgram() {
        return this.programs[1];
    }

    public Function getLeftFunction() {
        return this.functions[0];
    }

    public Function getRightFunction() {
        return this.functions[1];
    }

    public Data getLeftData() {
        return this.data[0];
    }

    public Data getRightData() {
        return this.data[1];
    }

    public abstract AddressSetView getLeftAddresses();

    public abstract AddressSetView getRightAddresses();

    public abstract void refreshLeftPanel();

    public abstract void refreshRightPanel();

    @Override
    public void focusLost(FocusEvent e) {
    }

    public abstract void updateActionEnablement();

    public void setFieldPanelCoordinator(T fieldPanelCoordinator) {
        if (this.fieldPanelCoordinator != null) {
            this.fieldPanelCoordinator.dispose();
        }
        this.fieldPanelCoordinator = fieldPanelCoordinator;
    }

    protected T getFieldPanelCoordinator() {
        return this.fieldPanelCoordinator;
    }

    protected abstract T createFieldPanelCoordinator();

    public abstract FieldPanel getLeftFieldPanel();

    public abstract FieldPanel getRightFieldPanel();

    public final boolean isScrollingSynced() {
        return this.syncScrolling;
    }

    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        this.syncScrolling = syncScrolling;
        FieldPanel leftPanel = this.getLeftFieldPanel();
        leftPanel.validate();
        leftPanel.invalidate();
        FieldPanel rightPanel = this.getRightFieldPanel();
        rightPanel.validate();
        rightPanel.invalidate();
        this.setFieldPanelCoordinator(syncScrolling ? (T)this.createFieldPanelCoordinator() : null);
    }
}

