/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import help.Help;
import help.HelpService;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FieldHeaderComp
extends JPanel {
    private static final String FONT_ID = "font.listing.header";
    private static final int FUDGE = 5;
    private static final int MIN_FIELD_SIZE = 10;
    private static final int DEFAULT_SNAP_SIZE = 10;
    private static final Color ACTIVE_FIELD_BG_COLOR = new GColor("color.bg.listing.header.active.field");
    private static final Color ACTIVE_FIELD_FG_COLOR = new GColor("color.fg.listing.header.active.field");
    private FieldFormatModel model;
    private JLabel label;
    private int rowHeight;
    private CursorState state;
    private int curRow;
    private int curCol;
    private int edgeCol;
    private int edgeColSize;
    private int anchorX;
    private int anchorY;
    private int snapSize = 10;
    private Color defaultButtonBgColor;
    private Color defaultButtonFgColor;
    private boolean editInProgress;
    private MovingField moving;
    private CellRendererPane renderPane;
    private Cursor defaultCursor = Cursor.getDefaultCursor();
    private Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private FieldHeader headerPanel;

    public FieldHeaderComp(FieldHeader headerPanel, int modelNumber) {
        FormatManager formatMgr = headerPanel.getFormatManager();
        this.model = formatMgr.getModel(modelNumber);
        this.headerPanel = headerPanel;
        Border border1 = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEmptyBorder(0, 0, 1, 1);
        this.label = new GDLabel("Test");
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        this.defaultButtonBgColor = this.label.getBackground();
        this.defaultButtonFgColor = this.label.getForeground();
        this.label.setBorder(BorderFactory.createCompoundBorder(border2, border1));
        this.label.setFont(Gui.getFont((String)FONT_ID));
        Dimension d = this.label.getPreferredSize();
        this.rowHeight = d.height;
        this.setMinimumSize(new Dimension(0, 2 * this.rowHeight));
        this.renderPane = new CellRendererPane();
        this.setLayout(new FlowLayout(0, 0, 0));
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("CodeBrowserPlugin", "Field_Formatter"));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FieldHeaderComp.this.headerPanel.requestFocus();
                if (e.getModifiersEx() == 1024) {
                    FieldHeaderComp.this.pressed(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getModifiersEx() == 0) {
                    FieldHeaderComp.this.released(e.getX(), e.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FieldHeaderComp.this.setCursor(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getModifiersEx() == 1024) {
                    FieldHeaderComp.this.dragged(e.getX(), e.getY());
                }
            }
        });
    }

    public FieldFormatModel getModel() {
        return this.model;
    }

    public void update() {
        this.invalidate();
        this.repaint();
    }

    private void setCursor(int x, int y) {
        int row = y / this.rowHeight;
        this.curRow = -1;
        this.curCol = -1;
        this.state = CursorState.NOWHERE;
        if (row < this.model.getNumRows()) {
            this.curRow = row;
            int startX = 0;
            FieldFactory[] fields = this.model.getFactorys(row);
            for (int col = 0; col < fields.length; ++col) {
                int width = fields[col].getWidth();
                if (x < startX + width) {
                    this.state = CursorState.OVER_FIELD;
                    this.curCol = col;
                    if (col > 0 && x < startX + 5) {
                        this.state = CursorState.NEAR_EDGE;
                        this.edgeCol = col - 1;
                        break;
                    }
                    if (x <= startX + width - 5) break;
                    this.state = CursorState.NEAR_EDGE;
                    this.edgeCol = col;
                    break;
                }
                startX += width;
            }
        }
        switch (this.state) {
            case OVER_FIELD: {
                this.setCursor(this.defaultCursor);
                break;
            }
            case NEAR_EDGE: {
                this.setCursor(this.resizeCursor);
                break;
            }
            default: {
                this.setCursor(this.defaultCursor);
            }
        }
    }

    private void pressed(int x, int y) {
        this.editInProgress = true;
        this.headerPanel.setTabLock(true);
        this.setCursor(x, y);
        this.anchorX = x;
        this.anchorY = y;
        switch (this.state) {
            case NEAR_EDGE: {
                FieldFactory[] fields = this.model.getFactorys(this.curRow);
                this.edgeColSize = fields[this.edgeCol].getWidth();
                break;
            }
            case OVER_FIELD: {
                this.moving = new MovingField(this.curRow, this.curCol);
                break;
            }
        }
    }

    private void released(int x, int y) {
        if (!this.editInProgress) {
            return;
        }
        this.editInProgress = false;
        int deltaX = x - this.anchorX;
        int deltaY = y - this.anchorY;
        switch (this.state) {
            case NEAR_EDGE: {
                this.resize(deltaX);
                this.invalidate();
                this.update();
                break;
            }
            case OVER_FIELD: {
                this.moving.moveFloating(deltaX, deltaY);
                this.moving.move();
                this.moving = null;
                this.invalidate();
                this.getParent().getParent().validate();
                this.update();
                break;
            }
        }
        Swing.runLater(() -> this.headerPanel.setTabLock(false));
    }

    private void dragged(int x, int y) {
        int deltaX = x - this.anchorX;
        int deltaY = y - this.anchorY;
        this.anchorX = x;
        this.anchorY = y;
        switch (this.state) {
            case NEAR_EDGE: {
                this.resize(deltaX);
                break;
            }
            case OVER_FIELD: {
                this.moving.moveFloating(deltaX, deltaY);
                this.repaint();
                break;
            }
        }
    }

    private void resize(int deltaX) {
        int row = this.curRow;
        int col = this.edgeCol;
        this.edgeColSize += deltaX;
        int newWidth = this.edgeColSize;
        if (newWidth < 10) {
            newWidth = 10;
        }
        newWidth = (newWidth + this.snapSize / 2) / this.snapSize * this.snapSize;
        FieldFactory[] fields = this.model.getFactorys(row);
        fields[col].setWidth(newWidth);
        this.model.updateRow(row);
        this.repaint();
    }

    public int getRow(Point p) {
        if (p.y < 0) {
            return 0;
        }
        int row = p.y / this.rowHeight;
        if (row >= this.model.getNumRows()) {
            row = this.model.getNumRows();
        }
        return row;
    }

    public int getCol(int row, int x) {
        if (x < 0) {
            return 0;
        }
        if (row < 0) {
            row = 0;
        } else if (row >= this.model.getNumRows()) {
            return 0;
        }
        int xpos = 0;
        FieldFactory[] fields = this.model.getFactorys(row);
        for (int i = 0; i < fields.length; ++i) {
            if (x >= (xpos += fields[i].getWidth())) continue;
            return i;
        }
        return fields.length;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.defaultButtonBgColor);
        int nRows = this.model.getNumRows();
        Dimension dim = this.getSize();
        g.fillRect(0, 0, dim.width, dim.height);
        this.paintBorder(g);
        FieldFactory selectedFactory = this.headerPanel.getSelectedFieldFactory();
        for (int i = 0; i < nRows; ++i) {
            FieldFactory[] factorys = this.model.getFactorys(i);
            int nfields = factorys.length;
            int startX = 0;
            for (int j = 0; j < nfields; ++j) {
                String name = factorys[j].getFieldText();
                int startY = i * this.rowHeight;
                int width = factorys[j].getWidth();
                int height = this.rowHeight;
                this.label.setText(name);
                this.label.setEnabled(factorys[j].isEnabled());
                if (factorys[j] == selectedFactory) {
                    this.label.setBackground(ACTIVE_FIELD_BG_COLOR);
                    this.label.setForeground(ACTIVE_FIELD_FG_COLOR);
                } else {
                    this.label.setBackground(this.defaultButtonBgColor);
                    this.label.setForeground(this.defaultButtonFgColor);
                }
                this.renderPane.paintComponent(g, this.label, this, startX, startY, width, height, true);
                startX += width;
            }
        }
        if (this.moving != null) {
            this.label.setText(this.moving.name);
            this.renderPane.paintComponent(g, this.label, this, this.moving.floatingX, this.moving.floatingY, this.moving.width, this.rowHeight, true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        FormatManager formatManager = this.model.getFormatManager();
        int height = formatManager.getMaxRowCount() * this.rowHeight + 1;
        return new Dimension(formatManager.getMaxWidth(), height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public FieldHeaderLocation getFieldHeaderLocation(Point p) {
        int row = this.getRow(p);
        if (row >= this.model.getNumRows()) {
            row = this.model.getNumRows() - 1;
        }
        int col = this.getCol(row, p.x);
        FieldFactory factory = null;
        if (row < this.model.getNumRows() && col < this.model.getNumFactorys(row)) {
            factory = this.model.getFactorys(row)[col];
        }
        return new FieldHeaderLocation(this.model, factory, row, col);
    }

    @Override
    public String toString() {
        return this.model.getName();
    }

    private static enum CursorState {
        NOWHERE,
        NEAR_EDGE,
        OVER_FIELD;

    }

    class MovingField {
        int baseRow;
        int baseCol;
        String name;
        int floatingX;
        int floatingY;
        int width;
        int x;
        int y;
        int widthRightField;
        int widthLeftField;

        MovingField(int row, int col) {
            this.baseRow = row;
            this.baseCol = col;
            FieldFactory factory = FieldHeaderComp.this.model.getFactorys(row)[col];
            this.name = factory.getFieldName();
            this.reset();
            this.floatingX = this.x;
            this.floatingY = this.y;
            this.width = factory.getWidth();
        }

        void moveFloating(int deltaX, int deltaY) {
            this.floatingX += deltaX;
            this.floatingY += deltaY;
        }

        void move() {
            if (this.floatingY - this.y > FieldHeaderComp.this.rowHeight / 2 && this.baseRow < 11) {
                if (this.baseRow + 1 == FieldHeaderComp.this.model.getNumRows()) {
                    FieldHeaderComp.this.model.addRow(this.baseRow + 1);
                }
                FieldHeaderComp.this.model.moveFactory(this.baseRow, this.baseCol, this.baseRow + 1, 0);
                ++this.baseRow;
                this.baseCol = 0;
                this.reset();
                this.move();
            } else if (this.y - this.floatingY > FieldHeaderComp.this.rowHeight / 2 && this.baseRow > 0) {
                FieldHeaderComp.this.model.moveFactory(this.baseRow, this.baseCol, this.baseRow - 1, 0);
                if (this.baseRow == FieldHeaderComp.this.model.getNumRows() - 1 && FieldHeaderComp.this.model.getNumFactorys(this.baseRow) == 0) {
                    FieldHeaderComp.this.model.removeRow(this.baseRow);
                }
                --this.baseRow;
                this.baseCol = 0;
                this.reset();
                this.move();
            } else {
                int diff = this.floatingX - this.x;
                if (diff >= 0 && this.widthRightField >= 0 && diff > this.widthRightField / 2) {
                    FieldHeaderComp.this.model.moveFactory(this.baseRow, this.baseCol, this.baseRow, this.baseCol + 1);
                    ++this.baseCol;
                    this.reset();
                    this.move();
                } else if (this.widthLeftField >= 0 && -diff > this.widthLeftField / 2) {
                    FieldHeaderComp.this.model.moveFactory(this.baseRow, this.baseCol, this.baseRow, this.baseCol - 1);
                    --this.baseCol;
                    this.reset();
                    this.move();
                }
            }
        }

        private void reset() {
            this.x = this.getStart();
            this.y = this.baseRow * FieldHeaderComp.this.rowHeight;
            this.widthLeftField = -1;
            this.widthRightField = -1;
            if (this.baseCol > 0) {
                this.widthLeftField = FieldHeaderComp.this.model.getFactorys(this.baseRow)[this.baseCol - 1].getWidth();
            }
            if (this.baseCol < FieldHeaderComp.this.model.getFactorys(this.baseRow).length - 1) {
                this.widthRightField = FieldHeaderComp.this.model.getFactorys(this.baseRow)[this.baseCol + 1].getWidth();
            }
        }

        private int getStart() {
            int start = 0;
            FieldFactory[] factorys = FieldHeaderComp.this.model.getFactorys(this.baseRow);
            for (int i = 0; i < this.baseCol; ++i) {
                start += factorys[i].getWidth();
            }
            return start;
        }
    }
}

