/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.opinion.MemorySection;
import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.ObjectRangeMap;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MemorySectionResolver {
    protected final Program program;
    private Set<String> usedBlockNames = new HashSet<String>();
    private AddressSet physicalLoadedOverlaySet;
    private List<MemorySection> sections = new ArrayList<MemorySection>();
    private Map<String, Integer> sectionIndexMap = new HashMap<String, Integer>();
    private Map<MemoryLoadable, List<AddressRange>> sectionMemoryMap;
    private int nextNonLoadedSectionInsertionIndex = 0;
    private Map<AddressSpace, ObjectRangeMap<AllocatedFileSectionRange>> fileLoadMaps;

    public MemorySectionResolver(Program program) {
        this.program = program;
        if (!program.getMemory().isEmpty()) {
            throw new IllegalStateException("program memory blocks already exist - unsupported");
        }
    }

    public void addInitializedMemorySection(MemoryLoadable key, long fileOffset, long numberOfBytes, Address startAddress, String sectionName, boolean isReadable, boolean isWritable, boolean isExecutable, String comment, boolean isFragmentationOK, boolean isLoadedSection) throws AddressOverflowException {
        if (this.sectionMemoryMap != null) {
            throw new IllegalStateException("already resolved");
        }
        sectionName = this.getUniqueSectionName(sectionName);
        MemorySection memorySection = new MemorySection(key, true, fileOffset, numberOfBytes, this.makeRange(startAddress, numberOfBytes), sectionName, isReadable, isWritable, isExecutable, comment, isFragmentationOK);
        if (isLoadedSection) {
            this.sections.add(memorySection);
        } else {
            this.sections.add(this.nextNonLoadedSectionInsertionIndex++, memorySection);
        }
    }

    public void addUninitializedMemorySection(MemoryLoadable key, long numberOfBytes, Address startAddress, String sectionName, boolean isReadable, boolean isWritable, boolean isExecutable, String comment, boolean isFragmentationOK) throws AddressOverflowException {
        if (this.sectionMemoryMap != null) {
            throw new IllegalStateException("already resolved");
        }
        sectionName = this.getUniqueSectionName(sectionName);
        this.sections.add(new MemorySection(key, false, -1L, numberOfBytes, this.makeRange(startAddress, numberOfBytes), sectionName, isReadable, isWritable, isExecutable, comment, isFragmentationOK));
    }

    private String getUniqueSectionName(String baseName) {
        if (baseName != null) {
            if ((baseName = baseName.trim()).length() == 0) {
                baseName = "NO-NAME";
            }
        } else {
            baseName = "NO-NAME";
        }
        Object name = baseName;
        int index = 0;
        while (this.usedBlockNames.contains(name)) {
            name = baseName + "-" + ++index;
        }
        return name;
    }

    private String getUniqueSectionChunkName(MemorySection section, int preferredIndex) {
        String sectionName = section.getSectionName();
        int index = preferredIndex;
        while (true) {
            Object name = sectionName;
            if (index >= 0) {
                name = (String)name + "." + index;
            }
            if (!this.usedBlockNames.contains(name)) {
                return name;
            }
            if (index <= 0) {
                index = 1;
                continue;
            }
            ++index;
        }
    }

    private AddressRange makeRange(Address startAddress, long numberOfBytes) throws AddressOverflowException {
        Address endAddress = startAddress.addNoWrap(numberOfBytes - 1L);
        return new AddressRangeImpl(startAddress, endAddress);
    }

    List<AddressRange> getResolvedLoadAddresses(MemoryLoadable key) {
        List<AddressRange> list = this.sectionMemoryMap.get(key);
        return list != null ? Collections.unmodifiableList(list) : null;
    }

    private ObjectRangeMap<AllocatedFileSectionRange> getFileLoadRangeMap(AddressSpace space, boolean create) {
        ObjectRangeMap map;
        if (this.fileLoadMaps == null) {
            if (!create) {
                return null;
            }
            this.fileLoadMaps = new HashMap<AddressSpace, ObjectRangeMap<AllocatedFileSectionRange>>();
        }
        if ((map = this.fileLoadMaps.get(space)) == null && create) {
            map = new ObjectRangeMap();
            this.fileLoadMaps.put(space, (ObjectRangeMap<AllocatedFileSectionRange>)map);
        }
        return map;
    }

    public void resolve(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Loading memory blocks...");
        if (this.sectionMemoryMap != null) {
            throw new IllegalStateException("already resolved");
        }
        if (!this.program.getMemory().isEmpty()) {
            throw new IllegalStateException("program memory blocks already exist - unsupported");
        }
        AddressRangeObjectMap fileAllocationMap = new AddressRangeObjectMap();
        this.sectionMemoryMap = new HashMap<MemoryLoadable, List<AddressRange>>();
        this.physicalLoadedOverlaySet = new AddressSet();
        for (MemoryBlock block : this.getMemory().getBlocks()) {
            Address minAddr = block.getStart();
            Address maxAddr = block.getEnd();
            if (!minAddr.isLoadedMemoryAddress() || !minAddr.getAddressSpace().isOverlaySpace()) continue;
            this.physicalLoadedOverlaySet.add(minAddr.getPhysicalAddress(), maxAddr.getPhysicalAddress());
        }
        int sectionCount = this.sections.size();
        monitor.initialize((long)sectionCount);
        for (int index = sectionCount - 1; index >= 0; --index) {
            monitor.checkCancelled();
            this.resolveSectionMemory(this.sections.get(index), (AddressRangeObjectMap<AllocatedFileSectionRange>)fileAllocationMap, monitor);
            monitor.incrementProgress(1L);
        }
    }

    private void resolveSectionMemory(MemorySection section, AddressRangeObjectMap<AllocatedFileSectionRange> fileAllocationMap, TaskMonitor monitor) throws CancelledException {
        List<AddressRange> memoryAllocationList = this.allocateSectionMemory(section, fileAllocationMap, monitor);
        try {
            List<AddressRange> sectionMemoryRanges = this.processSectionRanges(section, memoryAllocationList, monitor);
            MemoryLoadable key = section.getKey();
            if (key != null) {
                this.sectionMemoryMap.put(key, sectionMemoryRanges);
            }
        }
        catch (AddressOverflowException | IOException e) {
            Msg.error((Object)this, (Object)("Error while creating section " + section.getSectionName() + section.getPhysicalAddressRange() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private List<AddressRange> processSectionRanges(MemorySection section, List<AddressRange> memoryAllocationList, TaskMonitor monitor) throws IOException, AddressOverflowException, CancelledException {
        long sectionByteOffset = 0L;
        ObjectRangeMap<AllocatedFileSectionRange> fileLoadRangeMap = null;
        AddressSpace addressSpace = section.getPhysicalAddressSpace();
        if (addressSpace != AddressSpace.OTHER_SPACE) {
            fileLoadRangeMap = this.getFileLoadRangeMap(addressSpace, true);
        }
        ArrayList<AddressRange> modifiedRangeList = new ArrayList<AddressRange>();
        Memory memory = this.program.getMemory();
        for (AddressRange allocatedAddrRange : memoryAllocationList) {
            monitor.checkCancelled();
            Integer rangeIndex = this.sectionIndexMap.get(section.sectionName);
            rangeIndex = rangeIndex != null ? rangeIndex + 1 : 1;
            this.sectionIndexMap.put(section.sectionName, rangeIndex);
            if (rangeIndex == 1 && memoryAllocationList.size() == 1) {
                rangeIndex = -1;
            }
            long rangeSize = allocatedAddrRange.getLength();
            if (allocatedAddrRange instanceof ProxyAddressRange) {
                modifiedRangeList.add((AddressRange)new AddressRangeImpl(allocatedAddrRange));
                sectionByteOffset += rangeSize;
                continue;
            }
            String blockName = this.getUniqueSectionChunkName(section, rangeIndex);
            Address physicalStartAddr = section.getMinPhysicalAddress().add(sectionByteOffset);
            if (section.isInitialized) {
                Address maxAddr;
                Address minAddr;
                MemoryBlock block;
                long fileOffset = section.fileOffset + sectionByteOffset;
                if (allocatedAddrRange instanceof OverlayAddressRange) {
                    MemoryBlock priorityBlock;
                    Object comment = section.getComment();
                    if (section.isLoaded() && (priorityBlock = memory.getBlock(physicalStartAddr)) != null) {
                        comment = (String)comment + " - displaced by " + priorityBlock.getName();
                    }
                    block = this.createInitializedBlock(section.key, true, blockName, physicalStartAddr, fileOffset, rangeSize, (String)comment, section.isReadable(), section.isWritable(), section.isExecute(), monitor);
                } else {
                    block = this.createInitializedBlock(section.key, false, blockName, physicalStartAddr, fileOffset, rangeSize, section.getComment(), section.isReadable(), section.isWritable(), section.isExecute(), monitor);
                }
                if (block != null) {
                    minAddr = block.getStart();
                    maxAddr = block.getEnd();
                    this.usedBlockNames.add(blockName);
                    if (block.isOverlay() && minAddr.isLoadedMemoryAddress()) {
                        this.physicalLoadedOverlaySet.add(minAddr.getPhysicalAddress(), maxAddr.getPhysicalAddress());
                    }
                } else {
                    minAddr = physicalStartAddr;
                    maxAddr = physicalStartAddr.addNoWrap(rangeSize - 1L);
                }
                if (fileLoadRangeMap != null) {
                    long chunkFileOffset = section.getFileOffset() + sectionByteOffset;
                    AllocatedFileSectionRange allocatedFileRange = new AllocatedFileSectionRange(section, chunkFileOffset, rangeSize, minAddr);
                    fileLoadRangeMap.setObject(chunkFileOffset, chunkFileOffset + rangeSize - 1L, (Object)allocatedFileRange);
                }
                modifiedRangeList.add((AddressRange)new AddressRangeImpl(minAddr, maxAddr));
            } else {
                if (!(allocatedAddrRange instanceof OverlayAddressRange)) {
                    this.createUninitializedBlock(section.key, false, blockName, physicalStartAddr, rangeSize, section.getComment(), section.isReadable(), section.isWritable(), section.isExecute());
                }
                modifiedRangeList.add((AddressRange)new AddressRangeImpl(allocatedAddrRange));
            }
            sectionByteOffset += rangeSize;
        }
        return modifiedRangeList;
    }

    private AddressSet getMemoryConflictSet(Address rangeMin, Address rangeMax) {
        if (rangeMin.isNonLoadedMemoryAddress()) {
            return new AddressSet();
        }
        AddressSet conflictSet = this.getMemory().intersectRange(rangeMin, rangeMax);
        if (!this.physicalLoadedOverlaySet.isEmpty()) {
            conflictSet.add((AddressSetView)this.physicalLoadedOverlaySet.intersectRange(rangeMin, rangeMax));
        }
        return conflictSet;
    }

    private List<AddressRange> allocateSectionMemory(MemorySection section, AddressRangeObjectMap<AllocatedFileSectionRange> fileAllocationMap, TaskMonitor monitor) throws CancelledException {
        ArrayList<AddressRange> rangeList = new ArrayList<AddressRange>();
        Address targetMinPhysicalAddr = section.getMinPhysicalAddress();
        Address targetMaxPhysicalAddr = section.getMaxPhysicalAddress();
        if (!section.isLoaded()) {
            if (section.getPhysicalAddressSpace() != AddressSpace.OTHER_SPACE) {
                throw new AssertException();
            }
            rangeList.add((AddressRange)new OverlayAddressRange(targetMinPhysicalAddr, targetMaxPhysicalAddr));
            return rangeList;
        }
        AddressSet physicalConflictAddrSet = this.getMemoryConflictSet(targetMinPhysicalAddr, targetMaxPhysicalAddr);
        boolean noConflict = physicalConflictAddrSet.isEmpty();
        if (noConflict || !section.isFragmentationOK) {
            if (noConflict) {
                rangeList.add(section.getPhysicalAddressRange());
            } else {
                AddressRange physicalAddrRange = section.getPhysicalAddressRange();
                rangeList.add((AddressRange)new OverlayAddressRange(physicalAddrRange.getMinAddress(), physicalAddrRange.getMaxAddress()));
            }
            AllocatedFileSectionRange fileRange = new AllocatedFileSectionRange(section, section.getFileOffset(), section.length, targetMinPhysicalAddr);
            fileAllocationMap.setObject(targetMinPhysicalAddr, targetMaxPhysicalAddr, (Object)fileRange);
            return rangeList;
        }
        try {
            long fileOffset = section.getFileOffset();
            for (AddressRange physicalAddrRange : physicalConflictAddrSet.getAddressRanges()) {
                monitor.checkCancelled();
                Address physicalRangeMinAddr = physicalAddrRange.getMinAddress();
                Address physicalRangeMaxAddr = physicalAddrRange.getMaxAddress();
                if (targetMinPhysicalAddr.compareTo((Object)physicalRangeMinAddr) < 0) {
                    fileOffset = this.addSectionRange(section, targetMinPhysicalAddr, physicalRangeMinAddr.subtract(1L), fileOffset, rangeList);
                    targetMinPhysicalAddr = physicalRangeMinAddr;
                }
                fileOffset = this.reconcileSectionRangeOverlap(section, physicalRangeMinAddr, physicalRangeMaxAddr, fileOffset, rangeList);
                targetMinPhysicalAddr = physicalRangeMaxAddr.addNoWrap(1L);
            }
            if (targetMinPhysicalAddr.compareTo((Object)targetMaxPhysicalAddr) <= 0) {
                fileOffset = this.addSectionRange(section, targetMinPhysicalAddr, targetMaxPhysicalAddr, fileOffset, rangeList);
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return rangeList;
    }

    private long addSectionRange(MemorySection section, Address minAddr, Address maxAddr, long fileOffset, List<AddressRange> rangeList) {
        if (section.isInitialized) {
            fileOffset += maxAddr.subtract(minAddr) + 1L;
        }
        rangeList.add((AddressRange)new AddressRangeImpl(minAddr, maxAddr));
        return fileOffset;
    }

    private long reconcileSectionRangeOverlap(MemorySection section, Address minPhysicalAddr, Address maxPhysicalAddr, long fileOffset, List<AddressRange> rangeList) {
        if (section.isInitialized) {
            ObjectRangeMap<AllocatedFileSectionRange> fileLoadRangeMap = this.getFileLoadRangeMap(minPhysicalAddr.getAddressSpace(), false);
            if (fileLoadRangeMap == null) {
                rangeList.add((AddressRange)new OverlayAddressRange(minPhysicalAddr, maxPhysicalAddr));
                return fileOffset + maxPhysicalAddr.subtract(minPhysicalAddr) + 1L;
            }
            long conflictRangeSize = maxPhysicalAddr.subtract(minPhysicalAddr) + 1L;
            Address conflictGapPhysicalAddrRangeStart = null;
            Address conflictGapPhysicalAddrRangeEnd = null;
            IndexRangeIterator fileOffsetRangeIterator = fileLoadRangeMap.getIndexRangeIterator(fileOffset, fileOffset + conflictRangeSize - 1L);
            long filePos = fileOffset;
            Address expectedPhysicalAddrRangeStart = minPhysicalAddr;
            while (fileOffsetRangeIterator.hasNext()) {
                Address physicalAddrRangeStart;
                if (expectedPhysicalAddrRangeStart == null) {
                    throw new AssertException("expectedRangeStart is null");
                }
                IndexRange fileOffsetRange = fileOffsetRangeIterator.next();
                long rangeSize = fileOffsetRange.getEnd() - fileOffsetRange.getStart() + 1L;
                AllocatedFileSectionRange fileRange = (AllocatedFileSectionRange)fileLoadRangeMap.getObject(fileOffsetRange.getStart());
                if (fileOffsetRange.getStart() > filePos) {
                    if (conflictGapPhysicalAddrRangeStart == null) {
                        conflictGapPhysicalAddrRangeStart = expectedPhysicalAddrRangeStart;
                    }
                    expectedPhysicalAddrRangeStart = expectedPhysicalAddrRangeStart.add(fileOffsetRange.getStart() - filePos);
                    conflictGapPhysicalAddrRangeEnd = expectedPhysicalAddrRangeStart.previous();
                }
                if (!expectedPhysicalAddrRangeStart.equals((Object)(physicalAddrRangeStart = fileRange.rangeStartAddress.getPhysicalAddress().add(filePos - fileRange.rangeStartFileOffset)))) {
                    if (conflictGapPhysicalAddrRangeStart == null) {
                        conflictGapPhysicalAddrRangeStart = expectedPhysicalAddrRangeStart;
                    }
                    conflictGapPhysicalAddrRangeEnd = expectedPhysicalAddrRangeStart.add(rangeSize - 1L);
                } else {
                    if (conflictGapPhysicalAddrRangeStart != null) {
                        rangeList.add((AddressRange)new OverlayAddressRange(conflictGapPhysicalAddrRangeStart, conflictGapPhysicalAddrRangeEnd));
                        conflictGapPhysicalAddrRangeStart = null;
                        conflictGapPhysicalAddrRangeEnd = null;
                    }
                    rangeList.add((AddressRange)new ProxyAddressRange(expectedPhysicalAddrRangeStart, expectedPhysicalAddrRangeStart.add(rangeSize - 1L)));
                }
                filePos = fileOffsetRange.getEnd() + 1L;
                try {
                    expectedPhysicalAddrRangeStart = minPhysicalAddr.add(filePos - fileOffset);
                }
                catch (AddressOutOfBoundsException e) {
                    expectedPhysicalAddrRangeStart = null;
                }
            }
            if (filePos - fileOffset != conflictRangeSize) {
                if (conflictGapPhysicalAddrRangeStart == null) {
                    conflictGapPhysicalAddrRangeStart = expectedPhysicalAddrRangeStart;
                }
                conflictGapPhysicalAddrRangeEnd = maxPhysicalAddr;
            }
            if (conflictGapPhysicalAddrRangeStart != null) {
                rangeList.add((AddressRange)new OverlayAddressRange(conflictGapPhysicalAddrRangeStart, conflictGapPhysicalAddrRangeEnd));
            }
            return fileOffset + conflictRangeSize;
        }
        rangeList.add((AddressRange)new ProxyAddressRange(minPhysicalAddr, maxPhysicalAddr));
        return fileOffset;
    }

    public Memory getMemory() {
        return this.program.getMemory();
    }

    public Program getProgram() {
        return this.program;
    }

    protected abstract MemoryBlock createInitializedBlock(MemoryLoadable var1, boolean var2, String var3, Address var4, long var5, long var7, String var9, boolean var10, boolean var11, boolean var12, TaskMonitor var13) throws IOException, AddressOverflowException, CancelledException;

    protected abstract MemoryBlock createUninitializedBlock(MemoryLoadable var1, boolean var2, String var3, Address var4, long var5, String var7, boolean var8, boolean var9, boolean var10) throws IOException, AddressOverflowException, CancelledException;

    private class ProxyAddressRange
    extends AddressRangeImpl {
        ProxyAddressRange(Address min, Address max) {
            super(min, max);
        }
    }

    private class OverlayAddressRange
    extends AddressRangeImpl {
        OverlayAddressRange(Address min, Address max) {
            super(min, max);
        }
    }

    private class AllocatedFileSectionRange {
        final MemorySection section;
        final long rangeStartFileOffset;
        final long rangeSize;
        final Address rangeStartAddress;

        AllocatedFileSectionRange(MemorySection section, long rangeStartFileOffset, long rangeSize, Address rangeStartAddress) {
            this.section = section;
            this.rangeStartFileOffset = rangeStartFileOffset;
            this.rangeSize = rangeSize;
            this.rangeStartAddress = rangeStartAddress;
        }

        public String toString() {
            return String.format("%s (%d, %d @ %s)", this.section.getSectionName(), this.rangeStartFileOffset, this.rangeSize, this.rangeStartAddress);
        }
    }
}

