/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodDef;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodRef;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableCustomAttribute;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMemberRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexCustomAttributeType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Float4DataType;
import ghidra.program.model.data.Float8DataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class CliBlobCustomAttrib
extends CliBlob {
    private CliFixedArg[] fixedArgs;
    private CliNamedArg[] namedArgs;
    private short numNamed;
    private static final short CLIBLOBCUSTOMATTRIB_PROLOG = 1;
    private static final byte CLIBLOBCUSTOMATTRIB_TYPE_FIELD = 83;
    private static final byte CLIBLOBCUSTOMATTRIB_TYPE_PROPERTY = 84;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_BOUNDARY_128 = 128;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_BOUNDARY_192 = 192;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_SIZE_ONE = 1;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_SIZE_TWO = 2;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_SIZE_FOUR = 3;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_SIZE_BITMASK = 63;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_INDICATOR_SHIFT = 6;
    private static final int CLIBLOBCUSTOMATTRIB_STRING_INDICATOR_BITMASK = 3;
    private static final int CLIBLOBCUSTOMATTRIB_UTF8_LOW = 31;
    private static final int CLIBLOBCUSTOMATTRIB_UTF8_HIGH = 127;

    public CliBlobCustomAttrib(CliBlob blob, CliTableCustomAttribute.CliCustomAttributeRow row, CliStreamMetadata metadataStream) throws IOException {
        super(blob);
        BinaryReader reader = blob.getContentsReader();
        short prolog = reader.readNextShort();
        if (prolog != 1) {
            Msg.warn((Object)this, (Object)(this.getName() + " had unexpected prolog (0x" + Integer.toHexString(prolog) + ")"));
            return;
        }
        int valueIndex = row.valueIndex;
        int typeIndex = row.typeIndex;
        int parentIndex = row.parentIndex;
        CliAbstractSig.CliParam[] params = null;
        try {
            CliTypeTable tableType = CliIndexCustomAttributeType.getTableName(typeIndex);
            int tableRowIndex = CliIndexCustomAttributeType.getRowIndex(typeIndex);
            CliAbstractTableRow tableRow = metadataStream.getTable(tableType).getRow(tableRowIndex);
            if (tableType == CliTypeTable.MemberRef) {
                CliTableMemberRef.CliMemberRefRow memberRefRow = (CliTableMemberRef.CliMemberRefRow)tableRow;
                CliBlob memberRefBlob = metadataStream.getBlobStream().getBlob(memberRefRow.signatureIndex);
                CliSigMethodRef methodRefSig = new CliSigMethodRef(memberRefBlob);
                params = methodRefSig.getParams();
            } else if (tableType == CliTypeTable.MethodDef) {
                CliTableMethodDef.CliMethodDefRow methodDefRow = (CliTableMethodDef.CliMethodDefRow)tableRow;
                CliBlob methodDefBlob = metadataStream.getBlobStream().getBlob(methodDefRow.sigIndex);
                CliSigMethodDef methodDefSig = new CliSigMethodDef(methodDefBlob);
                params = methodDefSig.getParamTypes();
            }
        }
        catch (InvalidInputException e) {
            Msg.warn((Object)this, (Object)("Unable to process the parameters in " + this.getName()));
            return;
        }
        this.fixedArgs = (CliFixedArg[])this.processFixedArgs(reader, params).toArray(CliFixedArg[]::new);
        this.namedArgs = (CliNamedArg[])this.processNamedArgs(reader).toArray(CliNamedArg[]::new);
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs"), this.getName(), 0);
        struct.add(WORD, "PROLOG", "Magic (0x0001)");
        if (this.fixedArgs != null) {
            block9: for (int i = 0; i < this.fixedArgs.length; ++i) {
                CliAbstractSig.CliElementType elem = this.fixedArgs[i].elem;
                switch (elem) {
                    case ELEMENT_TYPE_CHAR: {
                        struct.add(UTF16, "FixedArg_" + i, "Elem (" + this.fixedArgs[i].getElem() + ")");
                        continue block9;
                    }
                    case ELEMENT_TYPE_I1: 
                    case ELEMENT_TYPE_U1: 
                    case ELEMENT_TYPE_BOOLEAN: {
                        struct.add(BYTE, "FixedArg_" + i, "Elem (" + this.fixedArgs[i].getElem() + ")");
                        continue block9;
                    }
                    case ELEMENT_TYPE_I2: 
                    case ELEMENT_TYPE_U2: {
                        struct.add(WORD, "FixedArg_" + i, "Elem (" + this.fixedArgs[i].getElem() + ")");
                        continue block9;
                    }
                    case ELEMENT_TYPE_I4: 
                    case ELEMENT_TYPE_U4: 
                    case ELEMENT_TYPE_R4: 
                    case ELEMENT_TYPE_VALUETYPE: {
                        struct.add(DWORD, "FixedArg_" + i, "Elem (" + this.fixedArgs[i].getElem() + ")");
                        continue block9;
                    }
                    case ELEMENT_TYPE_I8: 
                    case ELEMENT_TYPE_U8: 
                    case ELEMENT_TYPE_R8: {
                        struct.add(QWORD, "FixedArg_" + i, "Elem (" + this.fixedArgs[i].getElem() + ")");
                    }
                    case ELEMENT_TYPE_STRING: {
                        String s = (String)this.fixedArgs[i].value;
                        int l = s.length();
                        if (l < 128) {
                            struct.add(BYTE, "PackedLen", "");
                        } else if (l < 192) {
                            struct.add(WORD, "PackedLen", "");
                        } else {
                            struct.add(DWORD, "PackedLen", "");
                        }
                        struct.add(UTF8, ((String)this.fixedArgs[i].value).length(), "FixedArg_" + i, "");
                        continue block9;
                    }
                    case ELEMENT_TYPE_I: {
                        struct.add(BYTE, "ELEMENT_TYPE_I", "");
                        struct.add(UTF8, ((String)this.fixedArgs[i].value).length(), "FixedArg_" + i, "");
                        continue block9;
                    }
                    default: {
                        Msg.warn((Object)this, (Object)("Unprocessed FixedArg element type in CustomAttr #" + (i + 1) + ": " + this.fixedArgs[i].getElem().name()));
                    }
                }
            }
        }
        struct.add(WORD, "NumNamed", "Number of NamedArgs to follow");
        if (this.namedArgs != null) {
            for (CliNamedArg cliNamedArg : this.namedArgs) {
                int fieldOrProp = cliNamedArg.getFieldOrProp();
                if (fieldOrProp == 83) {
                    struct.add(BYTE, "FieldOrProp", "FIELD");
                } else if (fieldOrProp == 84) {
                    struct.add(BYTE, "FieldOrProp", "PROPERTY");
                } else {
                    struct.add(BYTE, "FieldOrProp", "Unknown value");
                }
                struct.add(BYTE, "FieldOrPropType", cliNamedArg.getFieldOrPropType().name());
                int nameLen = cliNamedArg.getFieldOrPropName().length();
                if (nameLen < 128) {
                    struct.add(BYTE, "PackedLen", "");
                } else if (nameLen < 192) {
                    struct.add(WORD, "PackedLen", "");
                } else {
                    struct.add(DWORD, "PackedLen", "");
                }
                struct.add(UTF8, nameLen, "FieldOrPropName", "");
            }
        }
        return struct;
    }

    @Override
    public String getContentsName() {
        return "CustomAttrib";
    }

    @Override
    public String getContentsComment() {
        return "A CustomAttrib blob stores values of fixed or named parameters supplied when instantiating a custom attribute";
    }

    @Override
    public String getRepresentation() {
        return "Blob (" + this.getContentsDataType().getDisplayName() + ")";
    }

    private int readSerStringLength(BinaryReader reader) throws IOException {
        int length = 0;
        byte by = reader.readNextByte();
        byte stringSizeIndicator = (byte)(by >> 6 & 3);
        byte by2 = by & 0x3F;
        if (stringSizeIndicator <= 1) {
            length = by2;
        } else if (stringSizeIndicator == 2) {
            byte[] lengthBytes = new byte[]{by2, reader.readNextByte()};
            ByteBuffer buf = ByteBuffer.wrap(lengthBytes);
            buf.order(ByteOrder.BIG_ENDIAN);
            length = buf.getShort();
        } else if (stringSizeIndicator == 3) {
            byte[] lengthBytes = new byte[]{by2, reader.readNextByte(), reader.readNextByte(), reader.readNextByte()};
            ByteBuffer buf = ByteBuffer.wrap(lengthBytes);
            buf.order(ByteOrder.BIG_ENDIAN);
            length = buf.getInt();
        }
        return length;
    }

    private ArrayList<CliFixedArg> processFixedArgs(BinaryReader reader, CliAbstractSig.CliParam[] params) throws IOException {
        ArrayList<CliFixedArg> processFixedArgs = new ArrayList<CliFixedArg>();
        if (params == null) {
            return processFixedArgs;
        }
        block16: for (CliAbstractSig.CliParam param : params) {
            byte elemByte = reader.peekNextByte();
            if (elemByte == CliAbstractSig.CliElementType.ELEMENT_TYPE_I.id()) {
                reader.readNextByte();
                StringBuilder sb = new StringBuilder();
                while ((reader.peekNextByte() & 0x7F) > 31 && (reader.peekNextByte() & 0x7F) < 127) {
                    sb.append((char)reader.readNextByte());
                }
                processFixedArgs.add(new CliFixedArg(CliAbstractSig.CliElementType.ELEMENT_TYPE_I, sb.toString()));
                continue;
            }
            CliAbstractSig.CliElementType baseTypeCode = param.getType().baseTypeCode;
            switch (baseTypeCode) {
                case ELEMENT_TYPE_BOOLEAN: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByte());
                    continue block16;
                }
                case ELEMENT_TYPE_CHAR: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextShort());
                    continue block16;
                }
                case ELEMENT_TYPE_I1: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByte());
                    continue block16;
                }
                case ELEMENT_TYPE_U1: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextUnsignedByte());
                    continue block16;
                }
                case ELEMENT_TYPE_I2: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextShort());
                    continue block16;
                }
                case ELEMENT_TYPE_U2: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextUnsignedShort());
                    continue block16;
                }
                case ELEMENT_TYPE_I4: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextInt());
                    continue block16;
                }
                case ELEMENT_TYPE_U4: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextUnsignedInt());
                    continue block16;
                }
                case ELEMENT_TYPE_I8: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByte());
                    processFixedArgs.add(new CliFixedArg(param.getType().baseTypeCode, reader.readNextLong()));
                    continue block16;
                }
                case ELEMENT_TYPE_U8: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByteArray(LongLongDataType.dataType.getLength()));
                    continue block16;
                }
                case ELEMENT_TYPE_R4: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByteArray(Float4DataType.dataType.getLength()));
                    continue block16;
                }
                case ELEMENT_TYPE_R8: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextByteArray(Float8DataType.dataType.getLength()));
                    continue block16;
                }
                case ELEMENT_TYPE_STRING: {
                    int length = this.readSerStringLength(reader);
                    if (length <= 0) continue block16;
                    this.addFixedArg(processFixedArgs, baseTypeCode, new String(reader.readNextByteArray(length), StandardCharsets.UTF_8));
                    continue block16;
                }
                case ELEMENT_TYPE_VALUETYPE: {
                    this.addFixedArg(processFixedArgs, baseTypeCode, reader.readNextInt());
                    continue block16;
                }
                default: {
                    Msg.info((Object)this, (Object)("A CustomAttrib with an unprocessed element type was deteceted: " + param.getRepresentation()));
                }
            }
        }
        return processFixedArgs;
    }

    private void addFixedArg(ArrayList<CliFixedArg> fixedArgs, CliAbstractSig.CliElementType baseTypeCode, Object value) {
        fixedArgs.add(new CliFixedArg(baseTypeCode, value));
    }

    private ArrayList<CliNamedArg> processNamedArgs(BinaryReader reader) throws IOException {
        this.numNamed = reader.readNextShort();
        ArrayList<CliNamedArg> processNamedArgs = new ArrayList<CliNamedArg>();
        for (int i = 0; i < this.numNamed; ++i) {
            byte fieldOrProp = reader.readNextByte();
            if (fieldOrProp != 83 && fieldOrProp != 84) {
                Msg.warn((Object)this, (Object)("Invalid FieldOrProp value in NamedArg #" + (i + 1) + ": 0x" + Integer.toHexString(fieldOrProp)));
                continue;
            }
            CliAbstractSig.CliElementType fieldOrPropType = CliAbstractSig.CliElementType.fromInt(reader.readNextByte());
            int nameLen = this.readSerStringLength(reader) + 1;
            String fieldOrPropName = new String(reader.readNextByteArray(nameLen), StandardCharsets.UTF_8);
            processNamedArgs.add(new CliNamedArg(fieldOrProp, fieldOrPropType, fieldOrPropName));
        }
        return processNamedArgs;
    }

    private class CliFixedArg {
        private CliAbstractSig.CliElementType elem;
        private Object value;

        public CliFixedArg(CliAbstractSig.CliElementType elem, Object value) {
            this.elem = elem;
            this.value = value;
        }

        public CliAbstractSig.CliElementType getElem() {
            return this.elem;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class CliNamedArg {
        private int fieldOrProp;
        private CliAbstractSig.CliElementType fieldOrPropType;
        private String fieldOrPropName;

        public CliNamedArg(int fieldOrProp, CliAbstractSig.CliElementType fieldOrPropType, String fieldOrPropName) {
            this.fieldOrProp = fieldOrProp;
            this.fieldOrPropType = fieldOrPropType;
            this.fieldOrPropName = fieldOrPropName;
        }

        public int getFieldOrProp() {
            return this.fieldOrProp;
        }

        public CliAbstractSig.CliElementType getFieldOrPropType() {
            return this.fieldOrPropType;
        }

        public String getFieldOrPropName() {
            return this.fieldOrPropName;
        }
    }
}

