/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.dyld.LibObjcOptimization;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LibObjcDylib {
    private MachHeader libObjcHeader;
    private Program program;
    private AddressSpace space;
    private MessageLog log;
    private TaskMonitor monitor;
    private LibObjcOptimization libObjcOptimization;

    public LibObjcDylib(MachHeader libObjcHeader, Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws IOException {
        this.libObjcHeader = libObjcHeader;
        this.program = program;
        this.space = space;
        this.log = log;
        this.monitor = monitor;
        this.libObjcOptimization = this.parseLibObjcOptimization();
    }

    public void markup() {
        if (this.libObjcOptimization != null) {
            this.libObjcOptimization.markup(this.program, this.space, this.log, this.monitor);
        }
    }

    private LibObjcOptimization parseLibObjcOptimization() throws IOException {
        Section section = this.libObjcHeader.getSection("__TEXT", "__objc_opt_ro");
        if (section == null) {
            return null;
        }
        return new LibObjcOptimization(this.program, this.space.getAddress(section.getAddress()));
    }
}

