/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.VoidDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName="runtime.functype")
public class GoFuncType
extends GoType {
    @FieldMapping
    private int inCount;
    @FieldMapping
    private int outCount;

    public static FunctionDefinition unwrapFunctionDefinitionPtrs(DataType dt) {
        FunctionDefinition funcDef;
        Pointer ptrptrDT;
        Pointer ptrDT;
        DataType dataType;
        return dt != null && dt instanceof Pointer && (dataType = (ptrDT = (Pointer)dt).getDataType()) instanceof Pointer && (dataType = (ptrptrDT = (Pointer)dataType).getDataType()) instanceof FunctionDefinition ? (funcDef = (FunctionDefinition)dataType) : null;
    }

    public boolean isVarArg() {
        return (this.outCount & 0x8000) != 0;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount & Short.MAX_VALUE;
    }

    public int getParamCount() {
        return this.inCount + (this.outCount & Short.MAX_VALUE);
    }

    private List<Address> getParamTypeAddrs() throws IOException {
        GoSlice slice = this.getParamListSlice();
        long[] typeOffsets = slice.readUIntList(this.programContext.getPtrSize());
        return Arrays.stream(typeOffsets).mapToObj(this.programContext::getDataAddress).toList();
    }

    private GoSlice getParamListSlice() {
        int count = this.getParamCount();
        return new GoSlice(this.getOffsetEndOfFullType(), count, count, this.programContext);
    }

    @Markup
    public List<GoType> getParamTypes() throws IOException {
        return this.getParamTypeAddrs().stream().map(addr -> {
            try {
                return this.programContext.getGoType((Address)addr);
            }
            catch (IOException e) {
                return null;
            }
        }).toList();
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        GoSlice slice = this.getParamListSlice();
        slice.markupArray(this.getStructureLabel() + "_paramlist", this.getStructureNamespace(), GoBaseType.class, true, session);
    }

    public String getFuncPrototypeString(String funcName, String receiverString) throws IOException {
        GoType paramType;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("func");
        if (receiverString != null && !receiverString.isBlank()) {
            sb.append(" (").append(receiverString).append(")");
        }
        if (funcName != null && !funcName.isBlank()) {
            sb.append(" ").append(funcName);
        }
        sb.append("(");
        List<GoType> paramTypes = this.getParamTypes();
        List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
        List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
        for (i = 0; i < inParamTypes.size(); ++i) {
            paramType = inParamTypes.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(paramType.getName());
        }
        sb.append(")");
        if (!outParamTypes.isEmpty()) {
            sb.append(" (");
            for (i = 0; i < outParamTypes.size(); ++i) {
                paramType = outParamTypes.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(paramType.getName());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public DataType recoverDataType() throws IOException {
        VoidDataType returnDT;
        String name = this.getUniqueTypename();
        DataTypeManager dtm = this.programContext.getDTM();
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.programContext.getRecoveredTypesCp(this.getPackagePathString()), name, dtm);
        Pointer funcDefPtr = dtm.getPointer((DataType)funcDef);
        Pointer funcDefPtrPtr = dtm.getPointer((DataType)funcDefPtr);
        this.programContext.cacheRecoveredDataType(this, (DataType)funcDefPtrPtr);
        List<GoType> paramTypes = this.getParamTypes();
        List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
        List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        for (int i = 0; i < inParamTypes.size(); ++i) {
            GoType paramType = inParamTypes.get(i);
            DataType paramDT = this.programContext.getRecoveredType(paramType);
            params.add(new ParameterDefinitionImpl(null, paramDT, null));
        }
        if (outParamTypes.size() == 0) {
            returnDT = VoidDataType.dataType;
        } else if (outParamTypes.size() == 1) {
            returnDT = this.programContext.getRecoveredType(outParamTypes.get(0));
        } else {
            List<DataType> paramDataTypes = this.recoverTypes(outParamTypes);
            GoFunctionMultiReturn multiReturn = new GoFunctionMultiReturn(this.programContext.getRecoveredTypesCp(this.getPackagePathString()), name, paramDataTypes, dtm, null);
            returnDT = multiReturn.getStruct();
        }
        funcDef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        funcDef.setReturnType((DataType)returnDT);
        return funcDefPtrPtr;
    }

    private List<DataType> recoverTypes(List<GoType> types) throws IOException {
        ArrayList<DataType> result = new ArrayList<DataType>();
        for (GoType type : types) {
            result.add(this.programContext.getRecoveredType(type));
        }
        return result;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoType paramType : this.getParamTypes()) {
            if (paramType == null) continue;
            paramType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        return this.getFuncPrototypeString(null, null);
    }
}

