/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class GoRegisterInfoManager {
    private static final String REGISTER_INFO_EXTERNAL_NAME = "Golang.register.info.file";
    private Map<LanguageID, Map<GoVer, GoRegisterInfo>> cache = new HashMap<LanguageID, Map<GoVer, GoRegisterInfo>>();

    public static GoRegisterInfoManager getInstance() {
        return SingletonHolder.instance;
    }

    public synchronized GoRegisterInfo getRegisterInfoForLang(Language lang, GoVer goVersion) {
        Map perVersionRegInfos = this.cache.computeIfAbsent(lang.getLanguageID(), key -> this.loadRegisterInfo(lang));
        GoRegisterInfo registerInfo = (GoRegisterInfo)perVersionRegInfos.get((Object)goVersion);
        if (registerInfo == null) {
            registerInfo = this.getDefault(lang);
            perVersionRegInfos.put(goVersion, registerInfo);
            int goSize = lang.getInstructionAlignment();
            Msg.warn((Object)this, (Object)("Missing Golang register info for: " + lang.getLanguageID() + ", defaulting to abi0, size=" + goSize));
        }
        return registerInfo;
    }

    private Map<GoVer, GoRegisterInfo> loadRegisterInfo(Language lang) {
        try {
            ResourceFile f = DWARFUtil.getLanguageExternalFile(lang, REGISTER_INFO_EXTERNAL_NAME);
            if (f != null) {
                return this.read(f, lang);
            }
            Msg.warn(GoRegisterInfoManager.class, (Object)"Missing Golang register info file for: %s".formatted(lang.getLanguageID()));
        }
        catch (IOException e) {
            Msg.warn(GoRegisterInfoManager.class, (Object)"Failed to read Golang register info file", (Throwable)e);
        }
        return new HashMap<GoVer, GoRegisterInfo>();
    }

    private Map<GoVer, GoRegisterInfo> read(ResourceFile f, Language lang) throws IOException {
        Map<GoVer, GoRegisterInfo> map;
        block8: {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            InputStream fis = f.getInputStream();
            try {
                Document doc = sax.build(fis);
                Element rootElem = doc.getRootElement();
                map = this.readFrom(rootElem, lang);
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    Msg.error(GoRegisterInfo.class, (Object)("Bad Golang register info file " + f), (Throwable)e);
                    throw new IOException("Failed to read Golang register info file " + f, e);
                }
            }
            fis.close();
        }
        return map;
    }

    private Map<GoVer, GoRegisterInfo> readFrom(Element rootElem, Language lang) throws IOException {
        HashMap<GoVer, GoRegisterInfo> result = new HashMap<GoVer, GoRegisterInfo>();
        for (Element regInfoElem : rootElem.getChildren("register_info")) {
            Map<GoVer, GoRegisterInfo> registerInfos = this.readRegInfoElement(regInfoElem, lang);
            result.putAll(registerInfos);
        }
        return result;
    }

    private Map<GoVer, GoRegisterInfo> readRegInfoElement(Element regInfoElem, Language lang) throws IOException {
        Set<GoVer> validGoVersions = this.parseValidGoVersionsStr(XmlUtilities.requireStringAttr((Element)regInfoElem, (String)"versions"));
        Element intRegsElem = regInfoElem.getChild("int_registers");
        Element floatRegsElem = regInfoElem.getChild("float_registers");
        Element stackElem = regInfoElem.getChild("stack");
        Element goRoutineElem = regInfoElem.getChild("current_goroutine");
        Element zeroRegElem = regInfoElem.getChild("zero_register");
        if (intRegsElem == null || floatRegsElem == null || stackElem == null || goRoutineElem == null || zeroRegElem == null) {
            throw new IOException("Bad format");
        }
        List<Register> intRegs = this.parseRegListStr(intRegsElem.getAttributeValue("list"), lang);
        List<Register> floatRegs = this.parseRegListStr(floatRegsElem.getAttributeValue("list"), lang);
        int stackInitialOffset = XmlUtilities.parseBoundedIntAttr((Element)stackElem, (String)"initialoffset", (int)0, (int)Integer.MAX_VALUE);
        int maxAlign = XmlUtilities.parseBoundedIntAttr((Element)stackElem, (String)"maxalign", (int)1, (int)Integer.MAX_VALUE);
        Register currentGoRoutineReg = this.parseRegStr(goRoutineElem.getAttributeValue("register"), lang);
        Register zeroReg = this.parseRegStr(zeroRegElem.getAttributeValue("register"), lang);
        boolean zeroRegIsBuiltin = XmlUtilities.parseOptionalBooleanAttr((Element)zeroRegElem, (String)"builtin", (boolean)false);
        GoRegisterInfo registerInfo = new GoRegisterInfo(intRegs, floatRegs, stackInitialOffset, maxAlign, currentGoRoutineReg, zeroReg, zeroRegIsBuiltin);
        HashMap<GoVer, GoRegisterInfo> result = new HashMap<GoVer, GoRegisterInfo>();
        for (GoVer goVer : validGoVersions) {
            result.put(goVer, registerInfo);
        }
        return result;
    }

    private GoRegisterInfo getDefault(Language lang) {
        int goSize = lang.getInstructionAlignment();
        return new GoRegisterInfo(List.of(), List.of(), goSize, goSize, null, null, false);
    }

    private List<Register> parseRegListStr(String s, Language lang) throws IOException {
        ArrayList<Register> result = new ArrayList<Register>();
        for (String regName : s.split(",")) {
            Register register;
            if ((regName = regName.trim()).isEmpty() || (register = this.parseRegStr(regName, lang)) == null) continue;
            result.add(register);
        }
        return result;
    }

    private Register parseRegStr(String regName, Language lang) throws IOException {
        if (regName == null || regName.isBlank()) {
            return null;
        }
        Register register = lang.getRegister(regName);
        if (register == null) {
            throw new IOException("Unknown register: " + regName);
        }
        return register;
    }

    private Set<GoVer> parseValidGoVersionsStr(String s) throws IOException {
        if (s.trim().equalsIgnoreCase("all")) {
            EnumSet<GoVer> allVers = EnumSet.allOf(GoVer.class);
            allVers.remove((Object)GoVer.UNKNOWN);
            return allVers;
        }
        EnumSet<GoVer> result = EnumSet.noneOf(GoVer.class);
        for (String verStr : s.split(",")) {
            if ((verStr = verStr.trim()).isEmpty()) continue;
            try {
                GoVer ver = GoVer.valueOf(verStr);
                result.add(ver);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Unknown go version: " + verStr);
            }
        }
        return result;
    }

    private static class SingletonHolder {
        private static GoRegisterInfoManager instance = new GoRegisterInfoManager();

        private SingletonHolder() {
        }
    }
}

