/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.Complex8DataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.Register;
import java.util.List;

public class GoRegisterInfo {
    private final List<Register> intRegisters;
    private final List<Register> floatRegisters;
    private final int stackInitialOffset;
    private final int maxAlign;
    private final Register currentGoroutineRegister;
    private final Register zeroRegister;
    private final boolean zeroRegisterIsBuiltin;

    GoRegisterInfo(List<Register> intRegisters, List<Register> floatRegisters, int stackInitialOffset, int maxAlign, Register currentGoroutineRegister, Register zeroRegister, boolean zeroRegisterIsBuiltin) {
        this.intRegisters = intRegisters;
        this.floatRegisters = floatRegisters;
        this.stackInitialOffset = stackInitialOffset;
        this.maxAlign = maxAlign;
        this.currentGoroutineRegister = currentGoroutineRegister;
        this.zeroRegister = zeroRegister;
        this.zeroRegisterIsBuiltin = zeroRegisterIsBuiltin;
    }

    public int getIntRegisterSize() {
        return this.maxAlign;
    }

    public int getMaxAlign() {
        return this.maxAlign;
    }

    public Register getCurrentGoroutineRegister() {
        return this.currentGoroutineRegister;
    }

    public Register getZeroRegister() {
        return this.zeroRegister;
    }

    public boolean isZeroRegisterIsBuiltin() {
        return this.zeroRegisterIsBuiltin;
    }

    public List<Register> getIntRegisters() {
        return this.intRegisters;
    }

    public List<Register> getFloatRegisters() {
        return this.floatRegisters;
    }

    public int getStackInitialOffset() {
        return this.stackInitialOffset;
    }

    public int getAlignmentForType(DataType dt) {
        while (dt instanceof TypeDef || dt instanceof Array) {
            if (dt instanceof TypeDef) {
                TypeDef td = (TypeDef)dt;
                dt = td.getBaseDataType();
            }
            if (!(dt instanceof Array)) continue;
            Array a = (Array)dt;
            dt = a.getDataType();
        }
        if (GoRegisterInfo.isIntType(dt) && GoRegisterInfo.isIntrinsicSize(dt.getLength())) {
            return Math.min(this.maxAlign, dt.getLength());
        }
        if (dt instanceof Complex8DataType) {
            return 4;
        }
        if (dt instanceof AbstractFloatDataType) {
            return Math.min(this.maxAlign, dt.getLength());
        }
        return this.maxAlign;
    }

    static boolean isIntType(DataType dt) {
        return dt instanceof AbstractIntegerDataType || dt instanceof WideCharDataType || dt instanceof WideChar16DataType || dt instanceof WideChar32DataType || dt instanceof Enum || dt instanceof BooleanDataType;
    }

    static boolean isIntrinsicSize(int size) {
        return Integer.bitCount(size) == 1;
    }
}

