/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.NotFoundException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ElfRelocationHandler
implements ExtensionPoint {
    public static final String GOT_BLOCK_NAME = "%got";

    public abstract boolean canRelocate(ElfHeader var1);

    public int getRelrRelocationType() {
        return 0;
    }

    public ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return null;
    }

    public abstract RelocationResult relocate(ElfRelocationContext var1, ElfRelocation var2, Address var3) throws MemoryAccessException, NotFoundException;

    public static void applyComponentOffsetPointer(Program program, Address addr, long componentOffset) {
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null || block.isExecute()) {
            return;
        }
        PointerTypedef dt = new PointerTypedef(null, null, -1, (DataTypeManager)program.getDataTypeManager(), componentOffset);
        try {
            DataUtilities.createData((Program)program, (Address)addr, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            Msg.error(ElfRelocationHandler.class, (Object)("Failed to apply component-offset pointer at " + addr));
        }
    }

    public static void warnExternalOffsetRelocation(Program program, Address relocationAddress, Address symbolAddr, String symbolName, long adjustment, MessageLog log) {
        if (symbolAddr == null || adjustment == 0L || !program.getMemory().isExternalBlockAddress(symbolAddr)) {
            return;
        }
        MemoryBlock block = program.getMemory().getBlock(relocationAddress);
        boolean showAsError = block == null || block.isExecute();
        String sign = "+";
        if (adjustment < 0L) {
            adjustment = -adjustment;
            sign = "-";
        }
        String adjStr = sign + "0x" + Long.toHexString(adjustment);
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        String msg1 = "EXTERNAL Data Elf Relocation with offset: at " + relocationAddress + " (External Location = " + symbolName + adjStr + ")";
        if (showAsError) {
            Msg.error(ElfRelocationHandler.class, (Object)msg1);
        } else {
            Msg.warn(ElfRelocationHandler.class, (Object)msg1);
        }
        if (block != null) {
            BookmarkManager bookmarkManager = program.getBookmarkManager();
            bookmarkManager.setBookmark(relocationAddress, "Warning", "EXTERNAL Relocation", "EXTERNAL Data Elf Relocation with offset: External Location = " + symbolName + adjStr);
        }
    }

    public static void markAsUnhandled(Program program, Address relocationAddress, long type, long symbolIndex, String symbolName, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        log.appendMsg("Unhandled Elf Relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") at " + relocationAddress + " (Symbol = " + symbolName + ")");
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation Type " + type, "Unhandled Elf Relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") Symbol = " + symbolName + " (0x" + Long.toHexString(symbolIndex) + ").");
    }

    public static void markAsUnsupportedRelr(Program program, Address relocationAddress) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Unsupported RELR Relocation", "ELF Extension does not specify type");
    }

    public static void markAsUninitializedMemory(Program program, Address relocationAddress, long type, long symbolIndex, String symbolName, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        log.appendMsg("Unable to perform relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") at " + relocationAddress + " (Symbol = " + symbolName + ") - uninitialized memory");
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation_Type_" + type, "Unable to perform relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") Symbol = " + symbolName + " (0x" + Long.toHexString(symbolIndex) + ") - uninitialized memory.");
    }

    public static void markAsError(Program program, Address relocationAddress, long type, String symbolName, String msg, MessageLog log) {
        ElfRelocationHandler.markAsError(program, relocationAddress, type + " (0x" + Long.toHexString(type) + ")", symbolName, msg, log);
    }

    public static void markAsError(Program program, Address relocationAddress, String type, String symbolName, String msg, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        log.appendMsg("Elf Relocation Error: Type = " + type + " at " + relocationAddress + ", Symbol = " + symbolName + ": " + msg);
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation_" + type, "Elf Relocation Error: Symbol = " + symbolName + ": " + msg);
    }

    public static void markAsWarning(Program program, Address relocationAddress, String type, String msg, MessageLog log) {
        ElfRelocationHandler.markAsWarning(program, relocationAddress, type, null, 0L, msg, log);
    }

    public static void markAsWarning(Program program, Address relocationAddress, String type, String symbolName, long symbolIndex, String msg, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        log.appendMsg("Elf Relocation Warning: Type = " + type + " at " + relocationAddress + ", Symbol = " + symbolName + ": " + msg);
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Warning", "Relocation_Type_" + type, "Unhandled Elf relocation (" + type + ") at address: " + relocationAddress + ". Symbol = " + symbolName + " (" + Long.toHexString(symbolIndex) + "). " + msg);
    }
}

