/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import java.io.IOException;

public interface ElfInfoItem {
    public void markupProgram(Program var1, Address var2);

    public static void markupElfInfoItemSection(Program program, String sectionName, ReaderFunc<ElfInfoItem> readFunc) {
        ItemWithAddress<ElfInfoItem> wrappedItem = ElfInfoItem.readItemFromSection(program, sectionName, readFunc);
        if (wrappedItem != null) {
            wrappedItem.item().markupProgram(program, wrappedItem.address());
        }
    }

    public static <T extends ElfInfoItem> ItemWithAddress<T> readItemFromSection(Program program, String sectionName, ReaderFunc<T> readFunc) {
        MemoryBlock memBlock = program.getMemory().getBlock(sectionName);
        if (memBlock != null) {
            ItemWithAddress<T> itemWithAddress;
            block9: {
                MemoryByteProvider bp = MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), memBlock);
                try {
                    BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
                    T item = readFunc.read(br, program);
                    ItemWithAddress<T> itemWithAddress2 = itemWithAddress = item != null ? new ItemWithAddress<T>(item, memBlock.getStart()) : null;
                    if (bp == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bp != null) {
                            try {
                                bp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Msg.warn(ElfInfoItem.class, (Object)"Unable to read Elf item in section: %s".formatted(sectionName), (Throwable)e);
                    }
                }
                bp.close();
            }
            return itemWithAddress;
        }
        return null;
    }

    public static interface ReaderFunc<T extends ElfInfoItem> {
        public T read(BinaryReader var1, Program var2) throws IOException;
    }

    public record ItemWithAddress<T>(T item, Address address) {
    }
}

