/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DSymSectionProvider
implements DWARFSectionProvider {
    private MachHeader machHeader;
    private Map<String, Section> machSectionsByName = new HashMap<String, Section>();
    private RandomAccessByteProvider provider;

    public static File getDSYMForProgram(Program program) {
        File exePath = new File(program.getExecutablePath());
        File dSymFile = new File(exePath.getParentFile(), exePath.getName() + ".dSYM/Contents/Resources/DWARF/" + exePath.getName());
        return dSymFile.isFile() ? dSymFile : null;
    }

    public static DSymSectionProvider createSectionProviderFor(Program program, TaskMonitor monitor) {
        File dsymFile;
        if ("Mac OS X Mach-O".equals(program.getExecutableFormat()) && (dsymFile = DSymSectionProvider.getDSYMForProgram(program)) != null) {
            try {
                return new DSymSectionProvider(dsymFile);
            }
            catch (MachException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DSymSectionProvider(File dsymFile) throws IOException, MachException {
        this.provider = new RandomAccessByteProvider(dsymFile);
        this.machHeader = new MachHeader(this.provider);
        this.machHeader.parse();
        for (Section s : this.machHeader.getAllSections()) {
            String fixedSectionName = s.getSectionName().replaceFirst("^_*", "");
            this.machSectionsByName.put(fixedSectionName, s);
        }
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName, TaskMonitor monitor) throws IOException {
        Section s = this.machSectionsByName.get(sectionName);
        return s != null ? new ByteProviderWrapper(this.provider, this.machHeader.getStartIndex() + (long)s.getOffset(), s.getSize()) : null;
    }

    @Override
    public void close() {
        FSUtilities.uncheckedClose(this.provider, null);
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.machSectionsByName.get(sectionName) != null) continue;
            return false;
        }
        return true;
    }
}

