/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

public class QueryData {
    private String ANY_STRING_WILDCARD = "*";
    private String ANY_CHAR_WILDCARD = "?";
    private final String queryString;
    private final boolean caseSensitive;
    private final boolean includeDynamicLables;

    public QueryData(String queryString, boolean caseSensitive, boolean includeDynamicLables) {
        this.queryString = queryString;
        this.caseSensitive = caseSensitive;
        this.includeDynamicLables = includeDynamicLables;
    }

    public QueryData(String queryString, boolean caseSensitive) {
        this(queryString, caseSensitive, true);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isIncludeDynamicLables() {
        return this.includeDynamicLables;
    }

    public boolean isWildCard() {
        return this.queryString.contains(this.ANY_STRING_WILDCARD) || this.queryString.contains(this.ANY_CHAR_WILDCARD);
    }
}

