/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.textfield.IntegerTextField;
import generic.theme.GIcon;
import ghidra.app.plugin.core.string.MakeStringsTask;
import ghidra.app.plugin.core.string.StringEvent;
import ghidra.app.plugin.core.string.StringEventsTask;
import ghidra.app.plugin.core.string.StringTableModel;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.app.plugin.core.string.StringTablePlugin;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.string.FoundString;
import ghidra.util.DateUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.ResourceManager;

public class StringTableProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    private static final Icon ICON = new GIcon("icon.plugin.stringtable.provider");
    private static final Icon PARITALLY_DEFINED_ICON = new GIcon("icon.plugin.stringtable.defined.partial");
    private static final Icon SHOW_UNDEFINED_ICON = new GIcon("icon.plugin.stringtable.undefined");
    private static final Icon SHOW_DEFINED_ICON = new GIcon("icon.plugin.stringtable.defined");
    private static final Icon SHOW_WORDS_ICON = new GIcon("icon.plugin.stringtable.words");
    private static final Icon CONFLICTS_ICON = new GIcon("icon.plugin.stringtable.conflicts");
    private static final Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static final Icon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)REFRESH_ICON);
    private static final Icon EXPAND_ICON = new GIcon("icon.toggle.expand");
    private static final Icon COLLAPSE_ICON = new GIcon("icon.toggle.collapse");
    private StringTablePlugin plugin;
    private JPanel mainPanel;
    private Program currentProgram;
    private StringTableOptions options;
    private boolean makeStringsOptionsShowing = true;
    private GhidraTable table;
    private StringTableModel stringModel;
    private GhidraThreadedTablePanel<FoundString> threadedTablePanel;
    private GhidraTableFilterPanel<FoundString> filterPanel;
    private JCheckBox autoLabelCheckbox;
    private JCheckBox addAlignmentBytesCheckbox;
    private JCheckBox allowTruncationCheckbox;
    private JPanel makeStringsOptionsPanel;
    private JButton toggleShowMakeStringOptionsButton;
    private JButton makeStringButton;
    private JButton makeCharArrayButton;
    private IntegerTextField offsetField;
    private JTextField preview;
    private ToggleDockingAction showDefinedAction;
    private ToggleDockingAction showUndefinedAction;
    private ToggleDockingAction selectionNavigationAction;
    private ToggleDockingAction showPartialDefinedAction;
    private ToggleDockingAction showConflictsAction;
    private ToggleDockingAction showIsWordAction;
    private DockingAction makeCharArrayAction;
    private DockingAction refreshAction;
    private DockingAction makeStringAction;

    public StringTableProvider(StringTablePlugin plugin, StringTableOptions options, boolean isTransient) {
        super(plugin.getTool(), "Strings", plugin.getName());
        this.plugin = plugin;
        this.options = options;
        this.mainPanel = this.createMainPanel();
        if (isTransient) {
            this.setTransient();
            this.updateSubTitle();
            this.setTitle(options.isPascalRequired() ? "Pascal String Search" : "String Search");
            this.setWindowMenuGroup("String Search");
            this.setWindowGroup("String Search");
            this.setTabText("String Search - " + DateUtils.formatCurrentTime());
        }
        this.setIcon(ICON);
        this.setHelpLocation(new HelpLocation("Search", "String_Search_Results"));
        this.addToTool();
        this.createActions();
    }

    void dispose() {
        this.threadedTablePanel.dispose();
        this.filterPanel.dispose();
        this.table.dispose();
    }

    private void updateSubTitle() {
        StringBuilder builder = new StringBuilder();
        int rowCount = this.stringModel.getRowCount();
        int unfilteredCount = this.stringModel.getUnfilteredRowCount();
        builder.append(rowCount);
        builder.append(" items");
        if (rowCount != unfilteredCount) {
            builder.append(" (of ").append(unfilteredCount).append(")");
        }
        if (this.isTransient()) {
            builder.append(" - [");
            if (this.currentProgram != null) {
                builder.append(this.currentProgram.getName());
                builder.append(", ");
            }
            builder.append("Minimum size = ");
            builder.append(this.options.getMinStringSize());
            builder.append(", Align = ");
            builder.append(this.options.getAlignment());
            if (this.options.getAddressSet() != null) {
                builder.append(", ");
                builder.append(this.options.getAddressSet().toString());
            }
            builder.append("]");
        }
        this.setSubTitle(builder.toString());
    }

    private void createActions() {
        HelpLocation filterHelp = new HelpLocation("Search", "String_Filters");
        this.showDefinedAction = new ToggleDockingAction("Show Defined Strings", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.options = StringTableProvider.this.options.copy();
                StringTableProvider.this.options.setIncludeDefinedStrings(this.isSelected());
                StringTableProvider.this.stringModel.setOptions(StringTableProvider.this.options);
                StringTableProvider.this.reload();
            }
        };
        this.showDefinedAction.setToolBarData(new ToolBarData(SHOW_DEFINED_ICON, "AA"));
        this.showDefinedAction.setSelected(true);
        this.showDefinedAction.setHelpLocation(filterHelp);
        this.addLocalAction((DockingActionIf)this.showDefinedAction);
        this.showUndefinedAction = new ToggleDockingAction("Show Undefined Strings", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.options = StringTableProvider.this.options.copy();
                StringTableProvider.this.options.setIncludeUndefinedStrings(this.isSelected());
                StringTableProvider.this.stringModel.setOptions(StringTableProvider.this.options);
                StringTableProvider.this.reload();
            }
        };
        this.showUndefinedAction.setToolBarData(new ToolBarData(SHOW_UNDEFINED_ICON, "AA"));
        this.addLocalAction((DockingActionIf)this.showUndefinedAction);
        this.showUndefinedAction.setHelpLocation(filterHelp);
        this.showUndefinedAction.setSelected(true);
        this.showPartialDefinedAction = new ToggleDockingAction("Show Partially Defined Strings", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.options = StringTableProvider.this.options.copy();
                StringTableProvider.this.options.setIncludePartiallyDefinedStrings(this.isSelected());
                StringTableProvider.this.stringModel.setOptions(StringTableProvider.this.options);
                StringTableProvider.this.reload();
            }
        };
        this.showPartialDefinedAction.setToolBarData(new ToolBarData(PARITALLY_DEFINED_ICON, "AA"));
        this.addLocalAction((DockingActionIf)this.showPartialDefinedAction);
        this.showPartialDefinedAction.setHelpLocation(filterHelp);
        this.showPartialDefinedAction.setSelected(true);
        this.showConflictsAction = new ToggleDockingAction("Show Strings That Conflict With Existing Instructions/Data", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.options = StringTableProvider.this.options.copy();
                StringTableProvider.this.options.setIncludeConflictingStrings(this.isSelected());
                StringTableProvider.this.stringModel.setOptions(StringTableProvider.this.options);
                StringTableProvider.this.reload();
            }
        };
        this.showConflictsAction.setToolBarData(new ToolBarData(CONFLICTS_ICON, "AA"));
        this.showConflictsAction.setHelpLocation(filterHelp);
        this.addLocalAction((DockingActionIf)this.showConflictsAction);
        this.showConflictsAction.setSelected(true);
        if (this.options.getWordModelInitialized()) {
            this.showIsWordAction = new ToggleDockingAction("Filter: Only Show High Confidence Word Strings", this.getOwner()){

                public void actionPerformed(ActionContext context) {
                    StringTableProvider.this.options = StringTableProvider.this.options.copy();
                    StringTableProvider.this.options.setOnlyShowWordStrings(this.isSelected());
                    StringTableProvider.this.stringModel.setOptions(StringTableProvider.this.options);
                    StringTableProvider.this.reload();
                }
            };
            this.showIsWordAction.setToolBarData(new ToolBarData(SHOW_WORDS_ICON, "AB"));
            this.showIsWordAction.setSelected(false);
            this.showIsWordAction.setHelpLocation(filterHelp);
            this.addLocalAction((DockingActionIf)this.showIsWordAction);
        }
        this.refreshAction = new DockingAction("Refresh Strings Table", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.stringModel.reload();
                StringTableProvider.this.refreshAction.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
            }
        };
        this.refreshAction.setToolBarData(new ToolBarData(REFRESH_NOT_NEEDED_ICON, "AC"));
        this.refreshAction.setHelpLocation(new HelpLocation("Search", "Refresh"));
        this.addLocalAction((DockingActionIf)this.refreshAction);
        this.makeStringAction = new DockingAction("Make String", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.makeString(false);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return StringTableProvider.this.makeStringButton.isEnabled();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        this.makeStringAction.setPopupMenuData(new MenuData(new String[]{"Make String"}, "Make"));
        this.makeStringAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(77, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        HelpLocation makeStringHelp = new HelpLocation("Search", "Make_String_Options");
        this.makeStringAction.setHelpLocation(makeStringHelp);
        this.addLocalAction((DockingActionIf)this.makeStringAction);
        this.makeCharArrayAction = new DockingAction("Make Char Array", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                StringTableProvider.this.makeString(true);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return StringTableProvider.this.makeCharArrayButton.isEnabled();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        this.makeCharArrayAction.setPopupMenuData(new MenuData(new String[]{"Make Char Array"}, "Make"));
        this.makeCharArrayAction.setHelpLocation(makeStringHelp);
        this.addLocalAction((DockingActionIf)this.makeCharArrayAction);
        MakeProgramSelectionAction selectAction = new MakeProgramSelectionAction(this.plugin, this.table);
        this.selectionNavigationAction = new SelectionNavigationAction(this.plugin, this.table);
        this.addLocalAction((DockingActionIf)this.selectionNavigationAction);
        this.addLocalAction((DockingActionIf)selectAction);
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildTablePanel(), "Center");
        this.makeStringsOptionsPanel = this.buildMakeStringOptionsPanel();
        panel.add((Component)this.makeStringsOptionsPanel, "South");
        panel.setPreferredSize(new Dimension(900, 600));
        return panel;
    }

    private JPanel buildMakeStringOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildOffsetPanel());
        panel.add(this.buildButtonPanel());
        return panel;
    }

    private Component buildOffsetPanel() {
        this.offsetField = new IntegerTextField(4, 0L);
        this.offsetField.setAllowNegativeValues(false);
        this.offsetField.addChangeListener(e -> this.updatePreview());
        this.preview = new JTextField(5);
        this.preview.setEditable(false);
        this.preview.setEnabled(false);
        this.autoLabelCheckbox = new GCheckBox("Auto Label");
        this.addAlignmentBytesCheckbox = new GCheckBox("Include Alignment Nulls");
        this.allowTruncationCheckbox = new GCheckBox("Truncate If Needed");
        this.autoLabelCheckbox.setSelected(false);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        panel.add((Component)this.autoLabelCheckbox, gbc);
        gbc.gridx = 1;
        panel.add(Box.createHorizontalStrut(60), gbc);
        gbc.gridx = 2;
        panel.add((Component)new GLabel("Offset: "), gbc);
        gbc.gridx = 3;
        panel.add((Component)this.offsetField.getComponent(), gbc);
        gbc.gridx = 4;
        panel.add(Box.createHorizontalStrut(20), gbc);
        gbc.gridx = 5;
        panel.add((Component)new GLabel("Preview: "), gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 6;
        gbc.fill = 2;
        panel.add((Component)this.preview, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        panel.add((Component)this.addAlignmentBytesCheckbox, gbc);
        gbc.gridy = 2;
        panel.add((Component)this.allowTruncationCheckbox, gbc);
        return panel;
    }

    private Component buildButtonPanel() {
        this.makeStringButton = new JButton("Make String");
        this.makeCharArrayButton = new JButton("Make Char Array");
        this.makeStringButton.setEnabled(false);
        this.makeCharArrayButton.setEnabled(false);
        this.makeStringButton.addActionListener(e -> this.makeString(false));
        this.makeCharArrayButton.addActionListener(e -> this.makeString(true));
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 40, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        buttonPanel.add(this.makeStringButton);
        buttonPanel.add(this.makeCharArrayButton);
        return buttonPanel;
    }

    protected void makeString(boolean makeArray) {
        ArrayList<FoundString> foundStrings = new ArrayList<FoundString>();
        int[] selectedRows = this.table.getSelectedRows();
        FoundString nextItemToSelect = this.findNextItemToSelect(selectedRows);
        for (int selectedRow : selectedRows) {
            FoundString string = (FoundString)this.stringModel.getRowObject(selectedRow);
            if (string.isDefined()) continue;
            foundStrings.add(string);
        }
        boolean autoLabel = this.autoLabelCheckbox.isSelected();
        boolean addAlignmentBytes = this.addAlignmentBytesCheckbox.isSelected();
        boolean allowTruncate = this.allowTruncationCheckbox.isSelected();
        int offset = this.offsetField.getIntValue();
        MakeStringsTask task = new MakeStringsTask(this.currentProgram, foundStrings, offset, this.options.getAlignment(), autoLabel, addAlignmentBytes, allowTruncate, makeArray);
        new TaskLauncher((Task)task, (Component)this.getComponent());
        List<StringEvent> stringEvents = task.getStringEvents();
        StringEventsTask eventsTask = new StringEventsTask(this.stringModel, this.options, stringEvents);
        new TaskLauncher((Task)eventsTask, (Component)this.getComponent());
        if (task.hasErrors()) {
            String message = "One or more strings could not be created due to collisions with existing\ndata or instructions. Check the String Table for those strings not created.";
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Error Making String(s)", (Object)message);
        }
        this.updateSelection(nextItemToSelect);
    }

    private FoundString findNextItemToSelect(int[] selectedRows) {
        if (selectedRows.length != 1) {
            return null;
        }
        int nextRow = selectedRows[0] + 1;
        if (nextRow >= this.stringModel.getRowCount()) {
            return null;
        }
        return (FoundString)this.stringModel.getRowObject(nextRow);
    }

    private void updateSelection(FoundString next) {
        if (next == null) {
            return;
        }
        int nextRow = this.stringModel.getRowIndex(next);
        this.setSelectedRowAndNavigate(nextRow);
    }

    void setSelectedRowAndNavigate(int row) {
        if (row < 0 || this.table.getRowCount() <= row) {
            return;
        }
        this.table.setRowSelectionInterval(row, row);
        Rectangle rect = this.table.getCellRect(row, 0, true);
        this.table.scrollRectToVisible(rect);
        if (!this.selectionNavigationAction.isSelected()) {
            return;
        }
        if (!this.table.isFocusOwner()) {
            this.table.navigate(row, 0);
        }
    }

    private JComponent buildTablePanel() {
        this.stringModel = new StringTableModel(this.tool, this.options);
        this.threadedTablePanel = new GhidraThreadedTablePanel<FoundString>((ThreadedTableModel)this.stringModel, 1000){

            @Override
            protected GTable createTable(ThreadedTableModel<FoundString, ?> model) {
                return new StringTable(model);
            }
        };
        this.table = this.threadedTablePanel.getTable();
        this.table.setActionsEnabled(true);
        this.table.setName("DataTable");
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.table.getSelectionModel().addListSelectionListener(e -> this.tableSelectionChanged());
        this.stringModel.addTableModelListener(e -> this.updateSubTitle());
        this.table.installNavigation((ServiceProvider)this.tool);
        this.table.setDefaultRenderer(FoundString.DefinedState.class, (TableCellRenderer)((Object)new DefinedColumnRenderer()));
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.stringModel);
        this.toggleShowMakeStringOptionsButton = new JButton(COLLAPSE_ICON);
        this.toggleShowMakeStringOptionsButton.setToolTipText("Toggle Make Strings Panel On/Off");
        this.toggleShowMakeStringOptionsButton.addActionListener(e -> this.toggleShowMakeStringOptions());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.threadedTablePanel), "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)((Object)this.filterPanel), "Center");
        bottomPanel.add((Component)this.toggleShowMakeStringOptionsButton, "East");
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    protected void tableSelectionChanged() {
        this.notifyContextChanged();
        boolean enabled = this.hasAtLeastOneUndefinedStringSelected();
        this.makeStringButton.setEnabled(enabled);
        this.makeCharArrayButton.setEnabled(enabled);
        this.updatePreview();
    }

    private void updatePreview() {
        int rowCount = this.table.getSelectedRowCount();
        if (rowCount == 1) {
            int charOffset = this.offsetField.getIntValue();
            FoundString foundString = (FoundString)this.stringModel.getRowObject(this.table.getSelectedRow());
            DumbMemBufferImpl membuf = new DumbMemBufferImpl(this.currentProgram.getMemory(), foundString.getAddress());
            StringDataInstance stringInstance = StringDataInstance.getStringDataInstance((DataType)foundString.getDataType(), (MemBuffer)membuf, (Settings)SettingsImpl.NO_SETTINGS, (int)foundString.getLength());
            if (charOffset != 0) {
                stringInstance = stringInstance.getCharOffcut(charOffset);
            }
            this.preview.setText(stringInstance.getStringRepresentation());
        } else {
            this.preview.setText("");
        }
    }

    private boolean hasAtLeastOneUndefinedStringSelected() {
        int[] selectedRows;
        for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
            FoundString string = (FoundString)this.stringModel.getRowObject(selectedRow);
            if (!string.isUndefined() && !string.isPartiallyDefined()) continue;
            return true;
        }
        return false;
    }

    protected void toggleShowMakeStringOptions() {
        boolean bl = this.makeStringsOptionsShowing = !this.makeStringsOptionsShowing;
        if (this.makeStringsOptionsShowing) {
            this.toggleShowMakeStringOptionsButton.setIcon(COLLAPSE_ICON);
            this.mainPanel.add((Component)this.makeStringsOptionsPanel, "South");
        } else {
            this.toggleShowMakeStringOptionsButton.setIcon(EXPAND_ICON);
            this.mainPanel.remove(this.makeStringsOptionsPanel);
        }
        this.mainPanel.validate();
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private void reload() {
        this.stringModel.reload();
    }

    public void setProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.currentProgram = program;
        if (this.currentProgram != null) {
            this.currentProgram.addListener((DomainObjectListener)this);
        }
        if (this.isVisible()) {
            this.stringModel.setProgram(program);
            this.stringModel.reload();
        }
        if (this.isTransient()) {
            this.updateSubTitle();
        }
    }

    public void componentHidden() {
        this.stringModel.setProgram(null);
        if (this.isTransient()) {
            this.plugin.removeTransientProvider(this);
        }
    }

    public void componentShown() {
        this.stringModel.setProgram(this.currentProgram);
        this.stringModel.reload();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
        this.table.repaint();
    }

    public void programClosed(Program program) {
        if (program == this.currentProgram) {
            this.closeComponent();
        }
    }

    private class DefinedColumnRenderer
    extends GTableCellRenderer {
        public DefinedColumnRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            this.setHorizontalAlignment(0);
            this.setText("");
            FoundString.DefinedState state = (FoundString.DefinedState)((Object)value);
            Icon icon = this.getIcon(state);
            this.setIcon(icon);
            this.setToolTipText(state.toString());
            return this;
        }

        private Icon getIcon(FoundString.DefinedState state) {
            switch (state) {
                case DEFINED: {
                    return SHOW_DEFINED_ICON;
                }
                case NOT_DEFINED: {
                    return SHOW_UNDEFINED_ICON;
                }
                case PARTIALLY_DEFINED: {
                    return PARITALLY_DEFINED_ICON;
                }
                case CONFLICTS: {
                    return CONFLICTS_ICON;
                }
            }
            throw new AssertException("Missing case:");
        }
    }

    private class StringTable
    extends GhidraTable {
        public StringTable(ThreadedTableModel<FoundString, ?> model) {
            super((TableModel)model);
        }
    }
}

