/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.FoundStringWithWordStatus;
import ghidra.app.plugin.core.string.NGramUtils;
import ghidra.app.plugin.core.string.StringAndScores;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefinedDataIterator;
import ghidra.program.util.string.FoundString;
import java.util.Iterator;

public class DefinedStringIterator
implements Iterator<FoundString> {
    private boolean isWordModelInitialized;
    private DataIterator stringDataIterator;
    private Program program;

    DefinedStringIterator(Program program, boolean isWordModelInitialized) {
        this.program = program;
        this.isWordModelInitialized = isWordModelInitialized;
        this.stringDataIterator = DefinedDataIterator.definedStrings((Program)program);
    }

    @Override
    public boolean hasNext() {
        return this.stringDataIterator.hasNext();
    }

    @Override
    public FoundString next() {
        Data data = this.stringDataIterator.next();
        return this.createFoundString(data);
    }

    private FoundString createFoundString(Data data) {
        if (this.isWordModelInitialized) {
            FoundStringWithWordStatus result = new FoundStringWithWordStatus(data.getAddress(), data.getLength(), data.getBaseDataType(), FoundString.DefinedState.DEFINED);
            this.setIsWordStatus(result);
            return result;
        }
        return new FoundString(data.getAddress(), data.getLength(), data.getBaseDataType(), FoundString.DefinedState.DEFINED);
    }

    private void setIsWordStatus(FoundStringWithWordStatus foundString) {
        String string = foundString.getString(this.program.getMemory());
        if (string == null) {
            foundString.setIsHighConfidenceWord(false);
            return;
        }
        StringAndScores candidateString = new StringAndScores(string, NGramUtils.isLowerCaseModel());
        if (candidateString.getScoredStringLength() >= NGramUtils.getMinimumStringLength()) {
            NGramUtils.scoreString(candidateString);
            foundString.setIsHighConfidenceWord(candidateString.isScoreAboveThreshold());
        }
    }
}

