/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.util.Msg;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import utilities.util.FileUtilities;

public class OSGiParallelLock
implements Closeable {
    private static final String LOCK_NAME = "parallel.lock";
    private File lockFile;
    private FileOutputStream fos;

    public OSGiParallelLock() {
        File osgiDir = BundleHost.getOsgiDir().toFile();
        FileUtilities.mkdirs((File)osgiDir);
        this.lockFile = new File(osgiDir, LOCK_NAME);
        try {
            this.fos = new FileOutputStream(this.lockFile);
            this.fos.getChannel().lock();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to open OSGi parallel lock: " + this.lockFile), (Throwable)e);
        }
    }

    @Override
    public void close() {
        FSUtilities.uncheckedClose(this.fos, "Failed to close OSGi parallel lock: " + this.lockFile);
    }
}

