/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.functioncompare.actions.CompareFunctionsAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class CompareFunctionsFromListingAction
extends CompareFunctionsAction {
    private static final String FUNCTION_MENU_SUBGROUP = "Function";

    public CompareFunctionsFromListingAction(PluginTool tool, String owner) {
        super(tool, owner);
        this.setToolBarData(null);
        String menuSubGroup = "Z_End";
        Icon icon = null;
        this.setPopupMenuData(new MenuData(new String[]{"Compare Selected Functions"}, icon, FUNCTION_MENU_SUBGROUP, -1, menuSubGroup));
    }

    public boolean isAddToPopup(ActionContext actionContext) {
        return actionContext instanceof ListingActionContext && this.isEnabledForContext(actionContext);
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof ListingActionContext;
    }

    @Override
    protected Set<Function> getSelectedFunctions(ActionContext actionContext) {
        ListingActionContext listingContext = (ListingActionContext)actionContext;
        ProgramSelection selection = listingContext.getSelection();
        Program program = listingContext.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        HashSet<Function> functions = new HashSet<Function>();
        FunctionIterator functionIter = functionManager.getFunctions((AddressSetView)selection, true);
        for (Function selectedFunction : functionIter) {
            functions.add(selectedFunction);
        }
        return functions;
    }
}

