/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderListener;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class FunctionComparisonProviderManager
implements FunctionComparisonProviderListener {
    private Set<FunctionComparisonProvider> providers = new CopyOnWriteArraySet<FunctionComparisonProvider>();
    private Set<ComponentProviderActivationListener> listeners = new HashSet<ComponentProviderActivationListener>();
    private FunctionComparisonPlugin plugin;

    public FunctionComparisonProviderManager(FunctionComparisonPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void providerClosed(FunctionComparisonProvider provider) {
        this.providers.remove(provider);
        this.listeners.stream().forEach(l -> l.componentProviderDeactivated((ComponentProvider)provider));
    }

    @Override
    public void providerOpened(FunctionComparisonProvider provider) {
        this.listeners.stream().forEach(l -> l.componentProviderActivated((ComponentProvider)provider));
    }

    public FunctionComparisonProvider createProvider() {
        MultiFunctionComparisonProvider provider = new MultiFunctionComparisonProvider(this.plugin);
        provider.addToTool();
        this.providers.add(provider);
        provider.setVisible(true);
        return provider;
    }

    public FunctionComparisonProvider compareFunctions(Set<Function> functions) {
        if (functions.isEmpty()) {
            return null;
        }
        FunctionComparisonProvider provider = this.createProvider();
        provider.getModel().compareFunctions(functions);
        return provider;
    }

    public FunctionComparisonProvider compareFunctions(Function source, Function target) {
        MultiFunctionComparisonProvider provider = new MultiFunctionComparisonProvider(this.plugin);
        provider.addToTool();
        provider.getModel().compareFunctions(source, target);
        this.providers.add(provider);
        provider.setVisible(true);
        return provider;
    }

    public void compareFunctions(Set<Function> functions, FunctionComparisonProvider provider) {
        if (functions.isEmpty() || provider == null) {
            return;
        }
        this.providers.add(provider);
        provider.setVisible(true);
        provider.getModel().compareFunctions(functions);
    }

    public void compareFunctions(Function source, Function target, FunctionComparisonProvider provider) {
        if (provider == null) {
            return;
        }
        this.providers.add(provider);
        provider.setVisible(true);
        provider.getModel().compareFunctions(source, target);
    }

    public void removeFunction(Function function) {
        this.providers.stream().forEach(p -> p.getModel().removeFunction(function));
    }

    public void removeFunction(Function function, FunctionComparisonProvider provider) {
        if (provider == null) {
            return;
        }
        provider.getModel().removeFunction(function);
    }

    public void addProviderListener(ComponentProviderActivationListener listener) {
        this.listeners.add(listener);
    }

    public void removeProviderListener(ComponentProviderActivationListener listener) {
        this.listeners.remove(listener);
    }

    public void closeProviders(Program program) {
        this.providers.stream().forEach(p -> p.programClosed(program));
    }

    public void removeFunctions(Program program) {
        this.providers.stream().forEach(p -> p.removeFunctions(program));
    }

    public void dispose() {
        for (FunctionComparisonProvider provider : this.providers) {
            FunctionComparisonPanel panel = provider.getComponent();
            panel.setVisible(false);
            panel.dispose();
        }
        this.providers.clear();
    }

    public void domainObjectRestored(DomainObjectChangedEvent ev) {
        for (DomainObjectChangeRecord domainObjectChangeRecord : ev) {
            int eventType = domainObjectChangeRecord.getEventType();
            if (eventType != 4) {
                return;
            }
            Object source = ev.getSource();
            if (!(source instanceof Program)) continue;
            Program program = (Program)source;
            this.providers.stream().forEach(p -> p.programRestored(program));
        }
    }
}

