/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import ghidra.program.model.listing.Function;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class FunctionComparison
implements Comparable<FunctionComparison> {
    private Function source;
    private FunctionComparator functionComparator = new FunctionComparator();
    private Set<Function> targets = new TreeSet<Function>(this.functionComparator);

    public Function getSource() {
        return this.source;
    }

    public Set<Function> getTargets() {
        return this.targets;
    }

    public void setSource(Function function) {
        this.source = function;
    }

    public void addTarget(Function function) {
        this.targets.add(function);
    }

    public void addTargets(Set<Function> functions) {
        this.targets.addAll(functions);
    }

    public void removeTarget(Function function) {
        this.targets.remove(function);
    }

    public void clearTargets() {
        this.targets.clear();
    }

    @Override
    public int compareTo(FunctionComparison o) {
        return this.functionComparator.compare(this.source, o.source);
    }

    class FunctionComparator
    implements Comparator<Function> {
        FunctionComparator() {
        }

        @Override
        public int compare(Function o1, Function o2) {
            if (o2 == null) {
                return 1;
            }
            String o1Path = o1.getProgram().getDomainFile().getPathname();
            String o2Path = o2.getProgram().getDomainFile().getPathname();
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            if (o1Path.equals(o2Path)) {
                if (o1Name.equals(o2Name)) {
                    return o1.getEntryPoint().compareTo((Object)o2.getEntryPoint());
                }
                return o1Name.compareTo(o2Name);
            }
            return o1Path.compareTo(o2Path);
        }
    }
}

