/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.util.Swing;
import ghidra.util.exception.UsrException;
import java.util.Arrays;
import javax.swing.Icon;

public class CreateInternalStructureAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.create");
    public static final String ACTION_NAME = "Create Structure From Selection";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create a new structure from the selected components and replace them with it.";
    private static String[] POPUP_PATH = new String[]{"Create Structure From Selection"};

    public CreateInternalStructureAction(StructureEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int[] selectedComponentRows = this.model.getSelectedComponentRows();
        boolean hasComponentSelection = this.model.hasComponentSelection();
        boolean hasContiguousSelection = this.model.isContiguousComponentSelection();
        if (selectedComponentRows.length == 0) {
            return;
        }
        if (!hasComponentSelection || !hasContiguousSelection) {
            return;
        }
        Arrays.sort(selectedComponentRows);
        int numComponents = this.model.getNumComponents();
        int maxRow = selectedComponentRows[selectedComponentRows.length - 1];
        if (maxRow < numComponents) {
            this.createStructure();
        }
        this.requestTableFocus();
        Swing.runLater(() -> {
            this.provider.toFront();
            this.provider.requestFocus();
            this.provider.editorPanel.requestFocus();
            this.provider.editorPanel.table.requestFocus();
        });
    }

    private void createStructure() {
        try {
            ((StructureEditorModel)this.model).createInternalStructure();
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.isCreateInternalStructureAllowed());
    }

    private boolean isCreateInternalStructureAllowed() {
        return this.model.hasComponentSelection() && this.model.isContiguousComponentSelection();
    }
}

