/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import generic.stl.Pair;
import ghidra.app.merge.MergeConstants;
import ghidra.app.merge.listing.AbstractFunctionMerger;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.FunctionVariableStorageConflicts;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ListingMerger;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.listing.VariousChoicesPanel;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.FunctionMerge;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FunctionMerger
extends AbstractFunctionMerger
implements ListingMerger {
    protected static final Color MERGE_HIGHLIGHT_COLOR = MergeConstants.HIGHLIGHT_COLOR;
    protected int conflictOption = 0;
    protected Address currentAddress;
    protected ProgramDiff diffOriginalLatest;
    protected ProgramDiff diffOriginalMy;
    protected ProgramDiff diffLatestMy;
    protected int totalChanges = 1;
    protected int changeNum;
    protected int minPhaseProgressPercentage;
    protected int maxPhaseProgressPercentage;
    protected int numConflictsResolved;
    static final String FUNCTIONS_PHASE = "Functions";
    private static final String CONFLICT_TYPE = "Function";
    private static final String INFO_TITLE = "Function Merge Information";
    private static final String ERROR_TITLE = "Function Merge Errors";
    private AddressSetView latestEntireDetailSet;
    private AddressSetView latestDetailSet;
    private AddressSetView myDetailSet;
    AddressSet onlyMyChanged;
    AddressSet bothChanged;
    AddressSet addEntireLatest;
    AddressSet changeEntireLatest;
    AddressSet removeEntireLatest;
    AddressSet addLatest;
    AddressSet changeLatest;
    AddressSet removeLatest;
    AddressSet addMy;
    AddressSet changeMy;
    AddressSet removeMy;
    AddressSet autoRemoveSet;
    AddressSet addLatestExternals;
    AddressSet removeLatestExternals;
    AddressSet changeLatestExternals;
    Hashtable<Address, AddressSet> overlapConflicts;
    AddressSet overlapConflictSet;
    AddressSet overlapAddressSet;
    AddressSet bodySet;
    AddressSet thunkConflictSet;
    AddressSet conflictSet;
    AddressSet thunkAutoMergeSet;
    FunctionConflictType currentConflictType = null;

    FunctionMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr.mergeManager, listingMergeMgr.programs);
        this.listingMergeManager = listingMergeMgr;
        this.init();
    }

    public void init() {
        this.initListingMerge();
        this.latestDetailSet = new AddressSet();
        this.myDetailSet = new AddressSet();
        this.onlyMyChanged = new AddressSet();
        this.bothChanged = new AddressSet();
        this.addEntireLatest = new AddressSet();
        this.changeEntireLatest = new AddressSet();
        this.removeEntireLatest = new AddressSet();
        this.addLatest = new AddressSet();
        this.changeLatest = new AddressSet();
        this.removeLatest = new AddressSet();
        this.addMy = new AddressSet();
        this.changeMy = new AddressSet();
        this.removeMy = new AddressSet();
        this.autoRemoveSet = new AddressSet();
        this.overlapConflicts = new Hashtable();
        this.overlapConflictSet = new AddressSet();
        this.overlapAddressSet = new AddressSet();
        this.bodySet = new AddressSet();
        this.thunkConflictSet = new AddressSet();
        this.conflictSet = new AddressSet();
        this.thunkAutoMergeSet = new AddressSet();
    }

    @Override
    public String getConflictType() {
        return CONFLICT_TYPE;
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.latestResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedLatestDataTypes");
        this.myResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedMyDataTypes");
        this.origResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedOriginalDataTypes");
        this.initializeAutoMerge("Auto-merging Functions and determining conflicts.", progressMin, progressMax, monitor);
        this.clearResolveInfo();
        ProgramDiffFilter filter = new ProgramDiffFilter(2048);
        this.updateProgress(0, "Finding Function changes in Latest...");
        ProgramDiff diffEntireOriginalLatest = new ProgramDiff(this.programs[3], this.programs[1], this.listingMergeManager.latestSet);
        this.latestEntireDetailSet = diffEntireOriginalLatest.getDifferences(filter, monitor);
        this.latestDetailSet = this.listingMergeManager.diffOriginalLatest.getDifferences(filter, monitor);
        this.updateProgress(5, "Finding Function changes in Checked Out...");
        this.myDetailSet = this.listingMergeManager.diffOriginalMy.getDifferences(filter, monitor);
        MergeUtilities.adjustSets(this.latestDetailSet, this.myDetailSet, this.onlyMyChanged, this.bothChanged);
        this.updateProgress(10, "Categorizing Function changes in Latest...");
        this.getLatestEntireChangeTypes(monitor);
        this.getLatestChangeTypes(monitor);
        this.updateProgress(15, "Categorizing Function changes in Checked Out...");
        this.getMyChangeTypes(monitor);
        this.updateProgress(20, "Finding function body overlap conflicts.");
        AddressSet changeSet = this.latestEntireDetailSet.union(this.myDetailSet);
        this.determineOverlapConflicts(changeSet, monitor);
        this.updateProgress(25, "Finding function removal conflicts.");
        AddressSet notOverlapConflicts = this.myDetailSet.subtract((AddressSetView)this.overlapAddressSet.intersect((AddressSetView)changeSet));
        this.determineRemoveConflicts(notOverlapConflicts, monitor);
        this.updateProgress(30, "Finding function body conflicts.");
        AddressSet notRemoveConflicts = notOverlapConflicts.subtract((AddressSetView)this.removeSet);
        AddressSet notRemoveConflictsAndNotAutoRemove = notRemoveConflicts.subtract((AddressSetView)this.autoRemoveSet);
        this.determineBodyConflicts((AddressSetView)notRemoveConflictsAndNotAutoRemove, monitor);
        this.updateProgressMessage("Auto-merging Functions and determining conflicts.");
        AddressSet functionDetailChanges = notRemoveConflictsAndNotAutoRemove.subtract((AddressSetView)this.bodySet);
        AddressSet autoSet = this.onlyMyChanged.intersect((AddressSetView)functionDetailChanges);
        AddressSet onlyMyChangedThunks = this.getThunkEntrySet(this.programs[2], autoSet);
        this.thunkAutoMergeSet.add((AddressSetView)onlyMyChangedThunks);
        AddressSet nonThunkSet = autoSet.subtract((AddressSetView)this.thunkAutoMergeSet);
        this.mergeEntireFunctions(nonThunkSet, 4, monitor);
        AddressSet possibleDetailConflicts = functionDetailChanges.subtract((AddressSetView)autoSet);
        long totalAddresses = possibleDetailConflicts.getNumAddresses();
        int addressCount = 0;
        AddressIterator iter = possibleDetailConflicts.getAddresses(true);
        while (iter.hasNext()) {
            boolean myIsThunk;
            monitor.checkCancelled();
            this.updateProgress((int)(85L + (long)(addressCount * 15) / totalAddresses));
            Address entry = iter.next();
            Function[] functions = new Function[4];
            functions[0] = this.functionManagers[0].getFunctionAt(entry);
            functions[3] = this.functionManagers[3].getFunctionAt(entry);
            functions[1] = this.functionManagers[1].getFunctionAt(entry);
            functions[2] = this.functionManagers[2].getFunctionAt(entry);
            boolean latestIsThunk = functions[1] != null ? functions[1].isThunk() : false;
            boolean bl = myIsThunk = functions[2] != null ? functions[2].isThunk() : false;
            if (latestIsThunk || myIsThunk) {
                this.determineThunkConflicts(functions, monitor);
                continue;
            }
            this.determineFunctionConflicts(functions, false, monitor);
        }
        this.updateProgress(100, "Done auto-merging Functions and determining conflicts.");
        this.determineConflictSet();
        this.showResolveErrors(ERROR_TITLE);
        this.showResolveInfo(INFO_TITLE);
    }

    private AddressSet getThunkEntrySet(Program program, AddressSet addressSetToCheck) {
        AddressSet thunkSet = new AddressSet();
        FunctionManager functionManager = program.getFunctionManager();
        FunctionIterator functions = functionManager.getFunctions((AddressSetView)addressSetToCheck, true);
        for (Function function : functions) {
            if (!function.isThunk()) continue;
            thunkSet.add(function.getEntryPoint());
        }
        return thunkSet;
    }

    private void determineConflictSet() {
        this.conflictSet.clear();
        this.conflictSet.add((AddressSetView)this.removeSet);
        this.conflictSet.add((AddressSetView)this.overlapConflictSet);
        this.conflictSet.add((AddressSetView)this.bodySet);
        this.conflictSet.add((AddressSetView)this.funcSet);
        this.conflictSet.add((AddressSetView)this.thunkConflictSet);
    }

    private void getLatestChangeTypes(TaskMonitor monitor) throws CancelledException {
        AddressIterator latestIter = this.latestDetailSet.getAddresses(true);
        long max = this.latestDetailSet.getNumAddresses();
        monitor.initialize(max);
        int count = 0;
        while (latestIter.hasNext()) {
            monitor.setProgress((long)count++);
            monitor.checkCancelled();
            Address entry = latestIter.next();
            Function originalFunc = this.functionManagers[3].getFunctionAt(entry);
            Function latestFunc = this.functionManagers[1].getFunctionAt(entry);
            if (originalFunc == null) {
                this.addLatest.addRange(entry, entry);
                continue;
            }
            if (latestFunc == null) {
                this.removeLatest.addRange(entry, entry);
                continue;
            }
            this.changeLatest.addRange(entry, entry);
        }
        monitor.setProgress(max);
    }

    private void getLatestEntireChangeTypes(TaskMonitor monitor) throws CancelledException {
        AddressIterator latestIter = this.latestEntireDetailSet.getAddresses(true);
        long max = this.latestEntireDetailSet.getNumAddresses();
        monitor.initialize(max);
        int count = 0;
        while (latestIter.hasNext()) {
            monitor.setProgress((long)count++);
            monitor.checkCancelled();
            Address entry = latestIter.next();
            Function originalFunc = this.functionManagers[3].getFunctionAt(entry);
            Function latestFunc = this.functionManagers[1].getFunctionAt(entry);
            if (originalFunc == null) {
                this.addEntireLatest.addRange(entry, entry);
                continue;
            }
            if (latestFunc == null) {
                this.removeEntireLatest.addRange(entry, entry);
                continue;
            }
            this.changeEntireLatest.addRange(entry, entry);
        }
        monitor.setProgress(max);
    }

    private void getMyChangeTypes(TaskMonitor monitor) throws CancelledException {
        AddressIterator myIter = this.myDetailSet.getAddresses(true);
        long max = this.myDetailSet.getNumAddresses();
        int count = 0;
        while (myIter.hasNext()) {
            monitor.setProgress((long)count++);
            monitor.checkCancelled();
            Address entry = myIter.next();
            Function originalFunc = this.functionManagers[3].getFunctionAt(entry);
            Function myFunc = this.functionManagers[2].getFunctionAt(entry);
            if (originalFunc == null) {
                this.addMy.addRange(entry, entry);
                continue;
            }
            if (myFunc == null) {
                this.removeMy.addRange(entry, entry);
                continue;
            }
            this.changeMy.addRange(entry, entry);
        }
        monitor.setProgress(max);
    }

    private void determineOverlapConflicts(AddressSet changeSet, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        AddressSet alreadyChecked = new AddressSet();
        AddressIterator iter = changeSet.getAddresses(true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            Address changeEntry = iter.next();
            if (this.overlapAddressSet.contains(changeEntry) || alreadyChecked.contains(changeEntry)) continue;
            AddressSet entryConflictSet = new AddressSet();
            AddressSet checkEntries = new AddressSet(changeEntry, changeEntry);
            while (!checkEntries.isEmpty()) {
                AddressSet newEntries = new AddressSet();
                AddressIterator entryIter = checkEntries.getAddresses(true);
                while (entryIter.hasNext()) {
                    Address entry = entryIter.next();
                    Function latestFunc = this.functionManagers[1].getFunctionAt(entry);
                    Function myFunc = this.functionManagers[2].getFunctionAt(entry);
                    AddressSet latestBody = new AddressSet();
                    if (latestFunc != null) {
                        latestBody.add(latestFunc.getBody());
                    }
                    AddressSet myBody = new AddressSet();
                    if (myFunc != null) {
                        myBody.add(myFunc.getBody());
                    }
                    AddressSet latestOnly = latestBody.subtract((AddressSetView)myBody);
                    AddressSet myOnly = myBody.subtract((AddressSetView)latestBody);
                    if (this.addEntireLatest.contains(entry) || this.changeEntireLatest.contains(entry)) {
                        AddressSet conflictingMyEntries = new AddressSet();
                        conflictingMyEntries.add((AddressSetView)latestOnly.intersect((AddressSetView)this.addMy));
                        conflictingMyEntries.add((AddressSetView)latestOnly.intersect((AddressSetView)this.changeMy));
                        if (!conflictingMyEntries.isEmpty()) {
                            entryConflictSet.add((AddressSetView)latestBody);
                            entryConflictSet.add((AddressSetView)this.getBodies(this.functionManagers[2], conflictingMyEntries));
                        }
                        newEntries.add((AddressSetView)conflictingMyEntries);
                    }
                    if (this.addMy.contains(entry) || this.changeMy.contains(entry)) {
                        AddressSet conflictingLatestEntries = new AddressSet();
                        conflictingLatestEntries.add((AddressSetView)myOnly.intersect((AddressSetView)this.addEntireLatest));
                        conflictingLatestEntries.add((AddressSetView)myOnly.intersect((AddressSetView)this.changeEntireLatest));
                        if (!conflictingLatestEntries.isEmpty()) {
                            entryConflictSet.add((AddressSetView)myBody);
                            entryConflictSet.add((AddressSetView)this.getBodies(this.functionManagers[1], conflictingLatestEntries));
                        }
                        newEntries.add((AddressSetView)conflictingLatestEntries);
                    }
                    alreadyChecked.addRange(entry, entry);
                }
                checkEntries = newEntries.subtract((AddressSetView)alreadyChecked);
            }
            if (entryConflictSet.isEmpty()) continue;
            this.overlapConflicts.put(changeEntry, entryConflictSet);
            this.overlapConflictSet.addRange(changeEntry, changeEntry);
            this.overlapAddressSet.add((AddressSetView)entryConflictSet);
        }
    }

    private AddressSet getBodies(FunctionManager funcMgr, AddressSet conflictingEntries) {
        AddressSet addrSet = new AddressSet();
        AddressIterator iter = conflictingEntries.getAddresses(true);
        while (iter.hasNext()) {
            Address addr = iter.next();
            Function f = funcMgr.getFunctionAt(addr);
            if (f == null) continue;
            addrSet.add(f.getBody());
        }
        return addrSet;
    }

    private void determineBodyConflicts(AddressSetView addrs, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        long totalAddresses = addrs.getNumAddresses();
        monitor.initialize(totalAddresses);
        long granularity = totalAddresses / 100L + 1L;
        int addressCount = 0;
        AddressIterator iter = addrs.getAddresses(true);
        while (iter.hasNext()) {
            Address entry = iter.next();
            if ((long)addressCount % granularity == 0L) {
                monitor.setProgress((long)addressCount);
                this.updateProgress((int)(35L + (long)(addressCount * 25) / totalAddresses));
            }
            monitor.setMessage("Checking & Auto-Merging Body Changes for Function " + ++addressCount + " of " + totalAddresses + ". Address = " + entry.toString());
            Function originalFunc = this.functionManagers[3].getFunctionAt(entry);
            Function latestFunc = this.functionManagers[1].getFunctionAt(entry);
            Function myFunc = this.functionManagers[2].getFunctionAt(entry);
            this.determineBodyConflicts(entry, originalFunc, latestFunc, myFunc, monitor);
        }
    }

    private void determineBodyConflicts(Address entry, Function original, Function latest, Function my, TaskMonitor monitor) throws CancelledException {
        boolean latestBodyChanged;
        AddressSetView myAddrs;
        monitor.checkCancelled();
        AddressSetView originalAddrs = original != null ? original.getBody() : null;
        AddressSetView latestAddrs = latest != null ? latest.getBody() : null;
        AddressSetView addressSetView = myAddrs = my != null ? my.getBody() : null;
        if (SystemUtilities.isEqual((Object)latestAddrs, (Object)myAddrs)) {
            return;
        }
        boolean myBodyChanged = !SystemUtilities.isEqual((Object)myAddrs, (Object)originalAddrs);
        boolean bl = latestBodyChanged = !SystemUtilities.isEqual((Object)latestAddrs, (Object)originalAddrs);
        if (myBodyChanged) {
            if (this.isEquivalent(latest, original)) {
                if (my != null && my.isThunk()) {
                    this.thunkAutoMergeSet.add(entry);
                } else {
                    this.merge(entry, 4, monitor);
                }
            } else {
                this.bodySet.addRange(entry, entry);
            }
        } else if (latestBodyChanged && !this.isEquivalent(my, original)) {
            this.bodySet.addRange(entry, entry);
        }
    }

    private void determineRemoveConflicts(AddressSet possibleConflicts, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        AddressSet myRemoveConflicts = this.removeMy.intersect((AddressSetView)this.changeLatest).intersect((AddressSetView)possibleConflicts);
        AddressSet latestRemoveConflicts = this.removeLatest.intersect((AddressSetView)this.changeMy).intersect((AddressSetView)possibleConflicts);
        this.autoRemoveSet = this.removeMy.subtract((AddressSetView)myRemoveConflicts);
        this.mergeFunctions(this.listingMergeManager.mergeMy, this.autoRemoveSet, monitor);
        this.removeSet.add((AddressSetView)myRemoveConflicts);
        this.removeSet.add((AddressSetView)latestRemoveConflicts);
    }

    private void determineThunkConflicts(Function[] functions, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        boolean latestIsThunk = functions[1].isThunk();
        boolean myIsThunk = functions[2].isThunk();
        if (latestIsThunk != myIsThunk) {
            this.saveThunkConflict(functions[0]);
            return;
        }
        if (latestIsThunk && myIsThunk) {
            this.determineThunkNameConflicts(functions, monitor);
            this.determineThunkedFunctionConflicts(functions);
        }
    }

    private void determineThunkNameConflicts(Function[] functions, TaskMonitor monitor) {
        boolean changedMy;
        int originalMyChanges;
        boolean sameFunctionNames = ProgramDiff.sameFunctionNames(functions[1], functions[2]);
        if (sameFunctionNames) {
            return;
        }
        int latestMyChanges = 32;
        boolean changedLatest = !ProgramDiff.sameFunctionNames(functions[3], functions[1]);
        int originalLatestChanges = changedLatest ? 32 : 0;
        int functionConflictFlags = this.determineFunctionConflict(functions, 32, latestMyChanges, originalLatestChanges, originalMyChanges = (changedMy = !ProgramDiff.sameFunctionNames(functions[3], functions[2])) ? 32 : 0, monitor);
        if (functionConflictFlags != 0) {
            this.saveFunctionDetailConflict(functions, functionConflictFlags);
        }
    }

    private void determineThunkedFunctionConflicts(Function[] functions) {
        Function latestThunkedFunction = functions[1].getThunkedFunction(false);
        Address latestThunkedEntry = latestThunkedFunction.getEntryPoint();
        Function myThunkedFunction = functions[2].getThunkedFunction(false);
        Address myThunkedEntry = myThunkedFunction.getEntryPoint();
        Address myThunkedEntryAsLatest = SimpleDiffUtility.getCompatibleAddress((Program)functions[2].getProgram(), (Address)myThunkedEntry, (Program)functions[1].getProgram());
        if (!latestThunkedEntry.equals((Object)myThunkedEntryAsLatest)) {
            this.saveThunkConflict(functions[0]);
        }
    }

    private void saveThunkConflict(Function result) {
        this.thunkConflictSet.add(result.getEntryPoint());
    }

    @Override
    protected void saveFunctionDetailConflict(Function[] functions, int type) {
        Address entry = functions[1] != null ? functions[1].getEntryPoint() : (functions[2] != null ? functions[2].getEntryPoint() : functions[3].getEntryPoint());
        int bits = 0;
        try {
            bits = this.funcConflicts.get((Object)entry);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.funcConflicts.put((Object)entry, bits |= type);
        this.funcSet.addRange(entry, entry);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictSet.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        int count = 0;
        if (this.overlapConflictSet.contains(addr) || this.bodySet.contains(addr) || this.removeSet.contains(addr)) {
            return 1;
        }
        if (this.funcSet.contains(addr)) {
            try {
                int bits = this.funcConflicts.get((Object)addr);
                count += this.countSetBits(bits);
            }
            catch (NoValueException e) {
                return 0;
            }
        }
        return count;
    }

    private void merge(Address entryPt, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Merging function @ " + entryPt.toString(true));
        ProgramMerge pgmMerge = this.getProgramListingMerge(chosenConflictOption);
        if (pgmMerge == null) {
            return;
        }
        Program origPgm = pgmMerge.getOriginProgram();
        if (origPgm == null) {
            return;
        }
        Function f = pgmMerge.mergeFunction(entryPt, monitor);
        if (f != null) {
            try {
                Function origF = origPgm.getFunctionManager().getFunctionAt(entryPt);
                if (origF != null) {
                    Namespace ns = this.listingMergeManager.resolveNamespace(origPgm, origF.getParentNamespace());
                    f.setParentNamespace(ns);
                }
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
            catch (CircularDependencyException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
        }
    }

    private void mergeOverlap(Address address, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        AddressSet resolveSet = this.overlapConflicts.get(this.currentAddress);
        if (resolveSet != null) {
            this.mergeEntireFunctions(resolveSet, chosenConflictOption, monitor);
        }
    }

    private void mergeEntireFunctions(AddressSet addressSet, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        ProgramMerge pgmMerge = this.getProgramListingMerge(chosenConflictOption);
        if (pgmMerge != null) {
            this.mergeFunctions(pgmMerge, addressSet, monitor);
        }
    }

    private void mergeFunctions(ProgramMerge pgmMerge, AddressSet addressSet, TaskMonitor monitor) throws CancelledException {
        this.updateProgress(60);
        pgmMerge.mergeFunctions((AddressSetView)addressSet, monitor);
        FunctionMerge.replaceFunctionsNames(pgmMerge, (AddressSetView)addressSet, monitor);
        this.setFunctionsNamespaces(pgmMerge, addressSet, monitor);
        this.updateProgress(85);
        if (!monitor.isCancelled()) {
            this.handleProgramMergeMessages(pgmMerge);
        }
    }

    private void setFunctionsNamespaces(ProgramMerge pgmMerge, AddressSet addressSet, TaskMonitor monitor) {
        monitor.setMessage("Setting function namespaces...");
        Program resultP = pgmMerge.getResultProgram();
        Program origP = pgmMerge.getOriginProgram();
        FunctionManager resultFM = resultP.getFunctionManager();
        FunctionManager origFM = origP.getFunctionManager();
        FunctionIterator iter = resultFM.getFunctions((AddressSetView)addressSet, true);
        while (iter.hasNext()) {
            Function resultF = (Function)iter.next();
            Address entryPoint = resultF.getEntryPoint();
            Function origF = origFM.getFunctionAt(entryPoint);
            if (origF == null) continue;
            monitor.setMessage("Setting namespace for function @ " + entryPoint.toString(true));
            try {
                Namespace ns = this.listingMergeManager.resolveNamespace(origP, origF.getParentNamespace());
                resultF.setParentNamespace(ns);
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
            catch (CircularDependencyException e) {
                Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Error Setting Function Namespace", (Object)e.getMessage());
            }
        }
    }

    private void handleProgramMergeMessages(ProgramMerge pm) {
        this.errorBuf.append(pm.getErrorMessage());
        pm.clearErrorMessage();
        this.infoBuf.append(pm.getInfoMessage());
        pm.clearInfoMessage();
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int currentConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (!this.hasConflict(addr)) {
            return;
        }
        this.clearResolveInfo();
        monitor.setMessage("Resolving Function conflicts.");
        this.currentAddress = addr;
        this.currentMonitor = monitor;
        Function[] functions = this.getFunctions(addr);
        if (this.overlapConflictSet.contains(addr)) {
            this.handleOverlappingFunctionsConflict(listingPanel, addr, currentConflictOption, monitor);
        } else if (this.bodySet.contains(addr)) {
            this.handleFunctionBodyConflict(listingPanel, addr, currentConflictOption, monitor);
        } else if (this.removeSet.contains(addr)) {
            this.handleFunctionRemovalConflict(listingPanel, addr, currentConflictOption, monitor);
        } else if (this.funcConflicts.contains((Object)addr)) {
            this.handleFunctionDetailConflicts(listingPanel, addr, functions, currentConflictOption, monitor);
        }
    }

    private void handleOverlappingFunctionsConflict(ListingMergePanel listingPanel, Address addr, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        boolean askUser;
        this.currentConflictType = FunctionConflictType.FUNCTION_OVERLAP_CONFLICT;
        boolean bl = askUser = this.overlapChoice == 0 && currentConflictOption == 0;
        if (askUser && this.mergeManager != null) {
            VariousChoicesPanel choicesPanel = this.createOverlapConflictPanel(addr, monitor);
            boolean useForAll = this.overlapChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("Function Overlap");
            this.setupAddressSetConflictPanel(listingPanel, choicesPanel, addr, (AddressSetView)this.overlapConflicts.get(addr), monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.overlapChoice == 0 ? currentConflictOption : this.overlapChoice;
            this.mergeOverlap(addr, optionToUse, monitor);
        }
    }

    private void handleFunctionBodyConflict(ListingMergePanel listingPanel, Address addr, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        boolean askUser;
        this.currentConflictType = FunctionConflictType.FUNCTION_BODY_CONFLICT;
        boolean bl = askUser = this.bodyChoice == 0 && currentConflictOption == 0;
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createBodyConflictPanel(addr, monitor);
            boolean useForAll = this.bodyChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("Function Body");
            this.setupAddressSetConflictPanel(listingPanel, choicesPanel, addr, this.getBodySet(addr), monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.bodyChoice == 0 ? currentConflictOption : this.bodyChoice;
            this.merge(addr, optionToUse, monitor);
        }
    }

    private void handleFunctionRemovalConflict(ListingMergePanel listingPanel, Address addr, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        boolean askUser;
        this.currentConflictType = FunctionConflictType.FUNCTION_REMOVE_CONFLICT;
        boolean bl = askUser = this.removeChoice == 0 && currentConflictOption == 0;
        if (askUser && this.mergeManager != null) {
            VerticalChoicesPanel choicesPanel = this.createRemoveConflictPanel(this.getFunctions(addr), monitor);
            boolean useForAll = this.removeChoice != 0;
            choicesPanel.setUseForAll(useForAll);
            choicesPanel.setConflictType("Function Removal");
            this.setupConflictPanel(listingPanel, choicesPanel, addr, monitor);
            monitor.checkCancelled();
        } else {
            int optionToUse = this.removeChoice == 0 ? currentConflictOption : this.removeChoice;
            this.merge(addr, optionToUse, monitor);
        }
    }

    private void handleFunctionDetailConflicts(ListingMergePanel listingPanel, Address addr, Function[] functions, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        ConflictPanel choicesPanel;
        boolean useForAll;
        int conflicts;
        this.currentConflictType = FunctionConflictType.FUNCTION_DETAILS_CONFLICT;
        boolean askUser = currentConflictOption == 0;
        try {
            conflicts = this.funcConflicts.get((Object)addr);
        }
        catch (NoValueException e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
        if ((conflicts & 0x8000) != 0) {
            this.mergeHigherPrioritySignatureSource(functions, monitor);
        }
        if ((conflicts & 0x1F2) != 0) {
            if (this.detailsChoice != 0) {
                this.mergeFunctionDetails(functions, this.detailsChoice, monitor);
            } else if (askUser && this.mergeManager != null) {
                VariousChoicesPanel choicesPanel2 = this.createFunctionConflictPanel(this.getFunctions(addr), monitor);
                boolean useForAll2 = this.detailsChoice != 0;
                choicesPanel2.setUseForAll(useForAll2);
                choicesPanel2.setConflictType("Function Detail");
                this.setupConflictPanel(listingPanel, choicesPanel2, addr, monitor);
                monitor.checkCancelled();
            } else {
                this.mergeFunctionDetails(functions, currentConflictOption, monitor);
            }
        }
        FunctionVariableStorageConflicts variableStorageConflicts = null;
        List<AbstractFunctionMerger.ParamInfoConflict> paramInfoConflicts = null;
        List<AbstractFunctionMerger.LocalVariableConflict> localVarConflicts = null;
        if ((conflicts & 0x100) != 0) {
            boolean skipParamChecks;
            variableStorageConflicts = this.determineStorageConflict(functions, monitor);
            boolean bl = skipParamChecks = variableStorageConflicts != null && variableStorageConflicts.hasParameterConflict();
            if (!skipParamChecks && this.determineSignatureConflicts(functions, monitor)) {
                paramInfoConflicts = this.determineParameterInfoConflicts(functions, true, monitor);
            }
            this.determineReturnConflict(functions, true, monitor);
            localVarConflicts = this.determineLocalVariableInfoConflicts(functions, true, variableStorageConflicts, monitor);
            try {
                conflicts = this.funcConflicts.get((Object)addr);
            }
            catch (NoValueException e) {
                throw new RuntimeException("Unexpected Exception", e);
            }
        }
        if ((conflicts & 1) != 0) {
            this.currentConflictType = FunctionConflictType.FUNCTION_RETURN_CONFLICT;
            if (this.functionReturnChoice != 0) {
                this.mergeFunctionReturn(functions, this.functionReturnChoice, monitor);
            } else if (askUser && this.mergeManager != null) {
                VerticalChoicesPanel choicesPanel3 = this.createFunctionReturnConflictPanel(this.getFunctions(addr), monitor);
                boolean useForAll3 = this.functionReturnChoice != 0;
                choicesPanel3.setUseForAll(useForAll3);
                choicesPanel3.setConflictType("Function Return");
                this.setupConflictPanel(listingPanel, choicesPanel3, addr, monitor);
                monitor.checkCancelled();
            } else {
                this.mergeFunctionReturn(functions, currentConflictOption, monitor);
            }
        }
        if ((conflicts & 0x400) != 0) {
            this.currentConflictType = FunctionConflictType.VARIABLE_STORAGE_CONFLICT;
            if (variableStorageConflicts == null) {
                variableStorageConflicts = this.determineStorageConflict(functions, monitor);
            }
            if (this.variableStorageChoice != 0) {
                for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                    monitor.checkCancelled();
                    this.mergeVariableStorage(addr, (Pair<List<Variable>, List<Variable>>)pair, this.variableStorageChoice, monitor);
                }
            } else if (askUser && this.mergeManager != null) {
                for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                    monitor.checkCancelled();
                    boolean bl = useForAll = this.variableStorageChoice != 0;
                    if (useForAll) {
                        this.mergeVariableStorage(addr, (Pair<List<Variable>, List<Variable>>)pair, this.variableStorageChoice, monitor);
                        continue;
                    }
                    choicesPanel = this.createStorageConflictPanel(addr, (Pair<List<Variable>, List<Variable>>)pair, monitor);
                    choicesPanel.setUseForAll(useForAll);
                    choicesPanel.setConflictType("Function Variable Storage");
                    this.setupConflictPanel(listingPanel, choicesPanel, addr, monitor);
                }
            } else {
                for (Pair pair : variableStorageConflicts.getOverlappingVariables()) {
                    monitor.checkCancelled();
                    this.mergeVariableStorage(addr, (Pair<List<Variable>, List<Variable>>)pair, currentConflictOption, monitor);
                }
            }
        }
        if ((conflicts & 0x800) != 0) {
            this.currentConflictType = FunctionConflictType.PARAMETER_SIGNATURE_CONFLICT;
            if (this.parameterSignatureChoice != 0) {
                this.mergeParameters(addr, this.parameterSignatureChoice, monitor);
            } else if (askUser && this.mergeManager != null) {
                VerticalChoicesPanel choicesPanel4 = this.createParameterSigConflictPanel(this.getFunctions(addr), monitor);
                boolean useForAll4 = this.parameterSignatureChoice != 0;
                choicesPanel4.setUseForAll(useForAll4);
                choicesPanel4.setConflictType("Function Parameter Signature");
                this.setupConflictPanel(listingPanel, choicesPanel4, addr, monitor);
                monitor.checkCancelled();
            } else {
                this.mergeParameters(addr, currentConflictOption, monitor);
            }
        }
        if ((conflicts & 0x2000) != 0) {
            this.currentConflictType = FunctionConflictType.PARAMETER_INFO_CONFLICT;
            if (paramInfoConflicts == null) {
                paramInfoConflicts = this.determineParameterInfoConflicts(functions, false, monitor);
            }
            if (this.parameterInfoChoice != 0) {
                this.mergeParamInfo(addr, paramInfoConflicts, this.parameterInfoChoice, monitor);
            } else if (askUser && this.mergeManager != null) {
                Iterator<AbstractFunctionMerger.ParamInfoConflict> iter = paramInfoConflicts.iterator();
                while (iter.hasNext()) {
                    monitor.checkCancelled();
                    AbstractFunctionMerger.ParamInfoConflict pc = iter.next();
                    boolean bl = useForAll = this.parameterInfoChoice != 0;
                    if (useForAll) {
                        this.mergeParamInfo(addr, pc, this.parameterInfoChoice, monitor);
                        continue;
                    }
                    choicesPanel = this.createParamInfoConflictPanel(pc, monitor);
                    choicesPanel.setUseForAll(useForAll);
                    choicesPanel.setConflictType("Function Parameter Info");
                    this.setupConflictPanel(listingPanel, choicesPanel, pc.entry, monitor);
                    monitor.checkCancelled();
                }
            } else {
                this.mergeParamInfo(addr, paramInfoConflicts, currentConflictOption, monitor);
            }
        }
        if ((conflicts & 0x1000) != 0) {
            this.currentConflictType = FunctionConflictType.LOCAL_VARIABLE_DETAIL_CONFLICT;
            if (localVarConflicts == null) {
                localVarConflicts = this.determineLocalVariableInfoConflicts(functions, false, variableStorageConflicts, monitor);
            }
            if (askUser && this.mergeManager != null) {
                for (AbstractFunctionMerger.LocalVariableConflict localVariableConflict : localVarConflicts) {
                    monitor.checkCancelled();
                    ConflictPanel choicesPanel5 = null;
                    if ((localVariableConflict.varConflicts & 0x200) != 0) {
                        this.currentConflictType = FunctionConflictType.REMOVED_LOCAL_VARIABLE_CONFLICT;
                        if (this.removedLocalVariableChoice != 0) {
                            this.mergeLocalVariable(512, addr, localVariableConflict.vars, this.removedLocalVariableChoice, monitor);
                            continue;
                        }
                        choicesPanel5 = this.createRemovedVarConflictPanel(localVariableConflict, monitor);
                        useForAll = this.removedLocalVariableChoice != 0;
                        choicesPanel5.setUseForAll(useForAll);
                        choicesPanel5.setConflictType("Local Variable Removal");
                    } else {
                        this.currentConflictType = FunctionConflictType.LOCAL_VARIABLE_DETAIL_CONFLICT;
                        if (this.localVariableDetailChoice != 0) {
                            this.mergeLocal(addr, localVariableConflict, this.localVariableDetailChoice, monitor);
                            continue;
                        }
                        choicesPanel5 = this.createLocalVariableConflictPanel(localVariableConflict, monitor);
                        useForAll = this.localVariableDetailChoice != 0;
                        choicesPanel5.setUseForAll(useForAll);
                        choicesPanel5.setConflictType("Local Variable Detail");
                    }
                    this.setupConflictPanel(listingPanel, choicesPanel5, localVariableConflict.entry, monitor);
                }
            } else {
                this.mergeLocals(addr, localVarConflicts, currentConflictOption, monitor);
            }
        }
    }

    public void mergeThunks(ListingMergePanel listingPanel, int currentConflictOption, TaskMonitor monitor) throws CancelledException {
        this.currentConflictType = FunctionConflictType.THUNK_CONFLICT;
        boolean askUser = currentConflictOption == 0;
        this.currentMonitor = monitor;
        this.mergeEntireFunctions(this.thunkAutoMergeSet, 4, monitor);
        AddressIterator conflictIter = this.thunkConflictSet.getAddresses(true);
        while (conflictIter.hasNext()) {
            boolean myIsInvalidThunk;
            Address thunkConflictAddress;
            this.currentAddress = thunkConflictAddress = conflictIter.next();
            Function latestFunction = this.functionManagers[1].getFunctionAt(thunkConflictAddress);
            Function myFunction = this.functionManagers[2].getFunctionAt(thunkConflictAddress);
            boolean latestIsInvalidThunk = latestFunction != null && latestFunction.isThunk() && latestFunction.getThunkedFunction(false) == null;
            boolean bl = myIsInvalidThunk = myFunction != null && myFunction.isThunk() && myFunction.getThunkedFunction(false) == null;
            if (latestIsInvalidThunk && myIsInvalidThunk || myIsInvalidThunk) continue;
            if (latestIsInvalidThunk) {
                ProgramMerge programListingMerge = this.getProgramListingMerge(4);
                programListingMerge.mergeFunction(thunkConflictAddress, monitor);
                continue;
            }
            if (this.thunkChoice != 0) {
                this.merge(thunkConflictAddress, this.thunkChoice, monitor);
            } else if (askUser && this.mergeManager != null) {
                VerticalChoicesPanel choicesPanel = this.createThunkConflictPanel(thunkConflictAddress, monitor);
                boolean useForAll = this.thunkChoice != 0;
                choicesPanel.setUseForAll(useForAll);
                choicesPanel.setConflictType("Thunk Function");
                this.setupConflictPanel(listingPanel, choicesPanel, thunkConflictAddress, monitor);
                monitor.checkCancelled();
            } else {
                this.merge(thunkConflictAddress, currentConflictOption, monitor);
            }
            monitor.checkCancelled();
        }
        this.showResolveErrors(ERROR_TITLE);
        this.showResolveInfo(INFO_TITLE);
    }

    private Function[] getFunctions(Address entryPoint) {
        Function[] functions = new Function[]{this.functionManagers[0].getFunctionAt(entryPoint), this.functionManagers[1].getFunctionAt(entryPoint), this.functionManagers[2].getFunctionAt(entryPoint), this.functionManagers[3].getFunctionAt(entryPoint)};
        return functions;
    }

    private AddressSetView getBodySet(Address addr) {
        AddressSet set = new AddressSet(addr);
        Function latest = this.functionManagers[1].getFunctionAt(addr);
        Function my = this.functionManagers[2].getFunctionAt(addr);
        Function original = this.functionManagers[3].getFunctionAt(addr);
        if (latest != null) {
            set.add(latest.getBody());
        }
        if (my != null) {
            set.add(my.getBody());
        }
        if (original != null) {
            set.add(original.getBody());
        }
        return set;
    }

    private VariousChoicesPanel createOverlapConflictPanel(Address addr, TaskMonitor monitor) {
        AddressSet resolveSet = this.overlapConflicts.get(addr);
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        this.runSwing(() -> {
            panel.setTitle("Function Overlap");
            StringBuffer buf = new StringBuffer();
            buf.append("Function @ ");
            ConflictUtility.addAddress(buf, addr);
            buf.append(" overlaps with different function(s) in other program.");
            buf.append("<br>");
            buf.append("The overlap address set is " + ConflictUtility.getEmphasizeString(resolveSet.toString()) + ".");
            panel.setHeader(buf.toString());
            FunctionOverlapConflictChangeListener changeListener = new FunctionOverlapConflictChangeListener(1, addr, panel, monitor);
            panel.addSingleChoice("Choose the version of functions to keep: ", new String[]{"Latest", "Checked Out"}, changeListener);
        });
        return panel;
    }

    private VerticalChoicesPanel createBodyConflictPanel(Address addr, TaskMonitor monitor) {
        Function latestFunction = this.functionManagers[1].getFunctionAt(addr);
        Function myFunction = this.functionManagers[2].getFunctionAt(addr);
        String latest = "'Latest' version";
        String my = "'Checked Out' version";
        String latestBody = latestFunction.getBody().toString();
        String myBody = myFunction.getBody().toString();
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("Function Body");
            StringBuffer buf = new StringBuffer();
            buf.append("Functions @ ");
            ConflictUtility.addAddress(buf, addr);
            buf.append(" have different bodies defined.");
            panel.setHeader(buf.toString());
            AbstractFunctionMerger.FunctionConflictChangeListener changeListener = new AbstractFunctionMerger.FunctionConflictChangeListener(2, addr, panel, monitor);
            panel.setRowHeader(new String[]{"Option", "Body"});
            panel.addRadioButtonRow(new String[]{latest, latestBody}, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(new String[]{my, myBody}, "CheckedOutVersionRB", 4, changeListener);
        });
        return panel;
    }

    private VerticalChoicesPanel createThunkConflictPanel(Address addr, TaskMonitor monitor) {
        Function latestFunction = this.functionManagers[1].getFunctionAt(addr);
        Function myFunction = this.functionManagers[2].getFunctionAt(addr);
        boolean bothThunks = latestFunction.isThunk() && myFunction.isThunk();
        String latest = "Keep" + (latestFunction.isThunk() ? " thunk " : " ") + "function '" + latestFunction.getName() + "' as in 'Latest' version.";
        String my = "Keep" + (myFunction.isThunk() ? " thunk " : " ") + "function '" + myFunction.getName() + "' as in 'Checked Out' version.";
        VerticalChoicesPanel panel = this.getEmptyVerticalPanel();
        this.runSwing(() -> {
            panel.setTitle("Thunk Function");
            StringBuffer buf = new StringBuffer();
            if (bothThunks) {
                buf.append("Thunks are to different functions @ ");
            } else {
                buf.append("One function is a thunk and the other is not @ ");
            }
            ConflictUtility.addAddress(buf, addr);
            buf.append(".");
            panel.setHeader(buf.toString());
            AbstractFunctionMerger.FunctionConflictChangeListener changeListener = new AbstractFunctionMerger.FunctionConflictChangeListener(8, addr, panel, monitor);
            panel.addRadioButtonRow(new String[]{latest}, "LatestVersionRB", 2, changeListener);
            panel.addRadioButtonRow(new String[]{my}, "CheckedOutVersionRB", 4, changeListener);
        });
        return panel;
    }

    protected void mergeParameters(Address entryPtAddress, int chosenConflictOption, TaskMonitor monitor) {
        Function resultFunction = this.listingMergeManager.mergeLatest.getResultProgram().getFunctionManager().getFunctionAt(entryPtAddress);
        if (resultFunction == null) {
            return;
        }
        ProgramMerge pgmMerge = null;
        if ((chosenConflictOption & 2) != 0) {
            pgmMerge = this.listingMergeManager.mergeLatest;
        } else if ((chosenConflictOption & 4) != 0) {
            pgmMerge = this.listingMergeManager.mergeMy;
        } else {
            return;
        }
        if (pgmMerge != null) {
            pgmMerge.replaceFunctionParameters(this.currentAddress, monitor);
            Function f = pgmMerge.getOriginProgram().getFunctionManager().getFunctionAt(entryPtAddress);
            if (f == null) {
                return;
            }
        }
    }

    private void setupAddressSetConflictPanel(ListingMergePanel listingPanel, JPanel conflictPanel, Address entryPt, AddressSetView addrSet, TaskMonitor monitor) {
        this.currentAddress = entryPt;
        this.currentMonitor = monitor;
        try {
            SwingUtilities.invokeAndWait(() -> listingPanel.setBottomComponent(conflictPanel));
            SwingUtilities.invokeLater(() -> {
                listingPanel.clearAllBackgrounds();
                listingPanel.paintAllBackgrounds(addrSet);
            });
        }
        catch (InterruptedException e) {
            this.showOverlapException(entryPt, e);
            return;
        }
        catch (InvocationTargetException e) {
            this.showOverlapException(entryPt, e);
            return;
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    private void showOverlapException(Address entryPt, Exception e) {
        String message = "Couldn't display body address set conflict for function at " + entryPt.toString(true) + ".\n " + e.getMessage();
        Msg.showError((Object)this, (Component)this.mergeManager.getMergeTool().getToolFrame(), (String)"Function Merge Error", (Object)message, (Throwable)e);
    }

    private VariousChoicesPanel createParamInfoConflictPanel(AbstractFunctionMerger.ParamInfoConflict pc, TaskMonitor monitor) {
        Address entryPt = pc.entry;
        int ordinal = pc.ordinal;
        int conflicts = pc.paramConflicts;
        Function latestFunc = this.functionManagers[1].getFunctionAt(entryPt);
        Function myFunc = this.functionManagers[2].getFunctionAt(entryPt);
        Parameter latestParam = latestFunc.getParameter(ordinal);
        Parameter myParam = myFunc.getParameter(ordinal);
        VariousChoicesPanel panel = this.getEmptyVariousPanel();
        this.runSwing(() -> {
            String my;
            String latest;
            panel.setTitle("Function Parameter");
            Parameter param = latestParam != null ? latestParam : myParam;
            String varInfo = "Storage: " + ConflictUtility.getEmphasizeString(param.getVariableStorage().toString());
            String text = "Function: " + ConflictUtility.getEmphasizeString(this.functionManagers[0].getFunctionAt(entryPt).getName()) + ConflictUtility.spaces(4) + "EntryPoint: " + ConflictUtility.getAddressString(entryPt) + ConflictUtility.spaces(4) + "Parameter #" + ConflictUtility.getNumberString(param.getOrdinal() + 1) + ConflictUtility.spaces(4) + varInfo;
            panel.setHeader(text);
            panel.addInfoRow("Conflict", new String[]{"Latest", "Checked Out"}, true);
            if ((conflicts & 2) != 0) {
                latest = latestParam.getName();
                my = myParam.getName();
                panel.addSingleChoice("Parameter Name", new String[]{latest, my}, new ParameterChangeListener(2, entryPt, ordinal, panel, monitor));
            }
            if ((conflicts & 4) != 0) {
                latest = latestParam.getDataType().getName();
                my = myParam.getDataType().getName();
                panel.addSingleChoice("Parameter Data Type", new String[]{latest, my}, new ParameterChangeListener(4, entryPt, ordinal, panel, monitor));
            }
            if ((conflicts & 0x10) != 0) {
                latest = latestParam.getComment();
                my = myParam.getComment();
                panel.addSingleChoice("Parameter Comment", new String[]{latest, my}, new ParameterChangeListener(16, entryPt, ordinal, panel, monitor));
            }
        });
        return panel;
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictSet;
    }

    @Override
    ProgramMerge getMergeLatest() {
        return this.listingMergeManager.mergeLatest;
    }

    @Override
    ProgramMerge getMergeMy() {
        return this.listingMergeManager.mergeMy;
    }

    @Override
    ProgramMerge getMergeOriginal() {
        return this.listingMergeManager.mergeOriginal;
    }

    protected void initListingMerge() {
        this.mergeManager = this.listingMergeManager.mergeManager;
        this.errorBuf = new StringBuffer();
        this.infoBuf = new StringBuffer();
        this.programs[0] = this.listingMergeManager.programs[0];
        this.programs[3] = this.listingMergeManager.programs[3];
        this.programs[1] = this.listingMergeManager.programs[1];
        this.programs[2] = this.listingMergeManager.programs[2];
        this.functionManagers[1] = this.programs[1].getFunctionManager();
        this.functionManagers[2] = this.programs[2].getFunctionManager();
        this.functionManagers[3] = this.programs[3].getFunctionManager();
        this.functionManagers[0] = this.programs[0].getFunctionManager();
        this.resultAddressFactory = this.programs[0].getAddressFactory();
        this.diffOriginalLatest = this.listingMergeManager.diffOriginalLatest;
        this.diffOriginalMy = this.listingMergeManager.diffOriginalMy;
        this.diffLatestMy = this.listingMergeManager.diffLatestMy;
    }

    protected void initializeAutoMerge(String progressMessage, int progressMin, int progressMax, TaskMonitor monitor) {
        this.minPhaseProgressPercentage = progressMin;
        this.maxPhaseProgressPercentage = progressMax;
        this.totalChanges = 0;
        this.changeNum = 0;
        this.mergeManager.updateProgress(progressMin, progressMessage);
        monitor.setMessage(progressMessage);
    }

    int getProgramIndex(Program pgm) {
        if (pgm == this.programs[0]) {
            return 0;
        }
        if (pgm == this.programs[1]) {
            return 1;
        }
        if (pgm == this.programs[2]) {
            return 2;
        }
        if (pgm == this.programs[3]) {
            return 3;
        }
        return -1;
    }

    Program getProgramForConflictOption(int chosenConflictOption) {
        switch (chosenConflictOption) {
            case 2: {
                return this.programs[1];
            }
            case 4: {
                return this.programs[2];
            }
            case 1: {
                return this.programs[3];
            }
        }
        return null;
    }

    AddressSet limitToStartofCodeUnits(Program program, AddressSetView initialSet) {
        Listing listing = program.getListing();
        AddressSet returnSet = new AddressSet();
        AddressIterator iter = initialSet.getAddresses(true);
        while (iter.hasNext()) {
            Address address = iter.next();
            CodeUnit cu = listing.getCodeUnitAt(address);
            if (cu == null) continue;
            returnSet.addRange(address, address);
        }
        return returnSet;
    }

    protected AddressSetView getCodeUnitAddressSet(Address addr) {
        return this.getCodeUnitAddressSet(new AddressSet(addr, addr));
    }

    protected AddressSetView getCodeUnitAddressSet(AddressSet addrs) {
        AddressSet codeSet = new AddressSet();
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.programs[1]));
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.programs[2]));
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.programs[3]));
        return codeSet;
    }

    @Override
    public boolean apply() {
        this.numConflictsResolved = 0;
        if (this.currentConflictPanel != null) {
            this.numConflictsResolved = this.currentConflictPanel.getNumConflictsResolved();
            if (this.currentConflictPanel.allChoicesAreResolved()) {
                this.currentConflictPanel.removeAllListeners();
                int useForAllChoice = this.currentConflictPanel.getUseForAllChoice();
                if (this.currentConflictPanel.getUseForAll()) {
                    this.setChoiceForFunctionConflictType(this.currentConflictType, useForAllChoice);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void setChoiceForFunctionConflictType(FunctionConflictType functionConflictType, int choiceForFunctionConflict) {
        switch (functionConflictType) {
            case FUNCTION_OVERLAP_CONFLICT: {
                this.overlapChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case FUNCTION_BODY_CONFLICT: {
                this.bodyChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_REMOVE_CONFLICT: {
                this.removeChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_RETURN_CONFLICT: {
                this.functionReturnChoice = choiceForFunctionConflict;
                break;
            }
            case FUNCTION_DETAILS_CONFLICT: {
                this.detailsChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case VARIABLE_STORAGE_CONFLICT: {
                this.variableStorageChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case PARAMETER_SIGNATURE_CONFLICT: {
                this.parameterSignatureChoice = choiceForFunctionConflict;
                break;
            }
            case PARAMETER_INFO_CONFLICT: {
                this.parameterInfoChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case REMOVED_LOCAL_VARIABLE_CONFLICT: {
                this.removedLocalVariableChoice = choiceForFunctionConflict;
                break;
            }
            case LOCAL_VARIABLE_DETAIL_CONFLICT: {
                this.localVariableDetailChoice = this.getOptionForChoice(choiceForFunctionConflict);
                break;
            }
            case THUNK_CONFLICT: {
                this.thunkChoice = choiceForFunctionConflict;
                break;
            }
            default: {
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"Unrecognized Function Conflict Type", (Object)("Unrecognized indicator (" + functionConflictType + ") for function conflict type to merge."));
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public int getNumConflictsResolved() {
        return this.numConflictsResolved;
    }

    protected void incrementProgress(int increment) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        this.changeNum += increment;
        int granularity = this.totalChanges / progressRange + 1;
        if (this.changeNum % granularity == 0) {
            if (this.totalChanges <= 0) {
                this.totalChanges = 1;
            }
            this.mergeManager.updateProgress(this.minPhaseProgressPercentage + this.changeNum * progressRange / this.totalChanges);
        }
    }

    protected void updateProgress(int myPercentComplete) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        int myProgress = myPercentComplete * progressRange / 100;
        this.mergeManager.updateProgress(this.minPhaseProgressPercentage + myProgress);
    }

    protected void updateProgress(int myPercentComplete, String message) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        int myProgress = myPercentComplete * progressRange / 100;
        this.mergeManager.updateProgress(this.minPhaseProgressPercentage + myProgress);
        this.mergeManager.updateProgress(message);
    }

    @Override
    protected String getInfoTitle() {
        return INFO_TITLE;
    }

    @Override
    protected String getErrorTitle() {
        return ERROR_TITLE;
    }

    private boolean isEquivalent(Function function1, Function function2) {
        Parameter returnParam2;
        if (function1 == function2) {
            return true;
        }
        if (function1 == null || function2 == null) {
            return false;
        }
        if (!function1.getName().equals(function2.getName())) {
            return false;
        }
        if (function1.isExternal() ? !SystemUtilities.isEqual((Object)function1.getExternalLocation(), (Object)function2.getExternalLocation()) : function2.isExternal()) {
            return false;
        }
        if (!function1.getEntryPoint().equals((Object)function2.getEntryPoint())) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)function1.getBody(), (Object)function2.getBody())) {
            return false;
        }
        Function thunkedFunction1 = function1.getThunkedFunction(false);
        Function thunkedFunction2 = function2.getThunkedFunction(false);
        if (thunkedFunction1 != null) {
            if (thunkedFunction2 == null) {
                return false;
            }
            if (thunkedFunction1.isExternal() != thunkedFunction2.isExternal()) {
                return false;
            }
            if (!thunkedFunction1.isExternal()) {
                return thunkedFunction1.getEntryPoint().equals((Object)thunkedFunction2.getEntryPoint());
            }
            return this.isEquivalent(thunkedFunction1, thunkedFunction2);
        }
        if (thunkedFunction2 != null) {
            return false;
        }
        Parameter returnParam1 = function1.getReturn();
        if (!returnParam1.equals(returnParam2 = function2.getReturn())) {
            return false;
        }
        if (function1.getStackPurgeSize() != function2.getStackPurgeSize()) {
            return false;
        }
        if (function1.getStackFrame().getReturnAddressOffset() != function2.getStackFrame().getReturnAddressOffset()) {
            return false;
        }
        if (!function1.getCallingConventionName().equals(function2.getCallingConventionName())) {
            return false;
        }
        if (function1.hasVarArgs() != function2.hasVarArgs()) {
            return false;
        }
        if (function1.isInline() != function2.isInline()) {
            return false;
        }
        if (function1.hasNoReturn() != function2.hasNoReturn()) {
            return false;
        }
        if (function1.hasCustomVariableStorage() != function2.hasCustomVariableStorage()) {
            return false;
        }
        if (function1.getSignatureSource() != function2.getSignatureSource()) {
            return false;
        }
        if (!VariableUtilities.equivalentVariableArrays((Variable[])function1.getParameters(), (Variable[])function2.getParameters())) {
            return false;
        }
        return VariableUtilities.equivalentVariableArrays((Variable[])function1.getLocalVariables(), (Variable[])function2.getLocalVariables());
    }

    protected static enum FunctionConflictType {
        FUNCTION_OVERLAP_CONFLICT,
        FUNCTION_BODY_CONFLICT,
        FUNCTION_REMOVE_CONFLICT,
        FUNCTION_RETURN_CONFLICT,
        FUNCTION_DETAILS_CONFLICT,
        VARIABLE_STORAGE_CONFLICT,
        PARAMETER_SIGNATURE_CONFLICT,
        PARAMETER_INFO_CONFLICT,
        REMOVED_LOCAL_VARIABLE_CONFLICT,
        LOCAL_VARIABLE_DETAIL_CONFLICT,
        THUNK_CONFLICT,
        TAG_CONFLICT;

    }

    class ParameterChangeListener
    implements ChangeListener {
        int type;
        Address entryPt;
        int ordinal;
        TaskMonitor monitor;
        VariousChoicesPanel vPanel;

        ParameterChangeListener(int type, Address entryPt, int ordinal, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.entryPt = entryPt;
            this.ordinal = ordinal;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            FunctionMerger.this.mergeParameter(this.type, this.entryPt, this.ordinal, FunctionMerger.this.getOptionForChoice(choice), this.monitor);
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (FunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (FunctionMerger.this.mergeManager != null) {
                FunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }

    class FunctionOverlapConflictChangeListener
    implements ChangeListener {
        int type;
        Address entryPt;
        TaskMonitor monitor;
        VariousChoicesPanel vPanel;

        FunctionOverlapConflictChangeListener(int type, Address entryPt, VariousChoicesPanel vPanel, TaskMonitor monitor) {
            this.type = type;
            this.entryPt = entryPt;
            this.monitor = monitor;
            this.vPanel = vPanel;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
            int choice = re.getChoice();
            try {
                FunctionMerger.this.mergeOverlap(this.entryPt, FunctionMerger.this.getOptionForChoice(choice), FunctionMerger.this.currentMonitor);
            }
            catch (CancelledException e1) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
            }
            this.adjustUseForAll();
            this.adjustApply();
        }

        void adjustUseForAll() {
            if (FunctionMerger.this.mergeManager != null) {
                this.vPanel.adjustUseForAllEnablement();
            }
        }

        void adjustApply() {
            if (FunctionMerger.this.mergeManager != null) {
                FunctionMerger.this.mergeManager.setApplyEnabled(this.vPanel.allChoicesAreResolved());
            }
        }
    }
}

