/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.graph.CodeBlockEdge;
import ghidra.program.model.block.graph.CodeBlockVertex;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractModularizationCmd
extends BackgroundCommand {
    protected Program program;
    private GroupPath groupPath;
    private String treeName;
    private CodeBlockModel codeBlockModel;
    private ProgramSelection selection;
    private String name;
    private boolean processEntireProgram;
    private Group selectedGroup;
    protected ProgramModule destinationModule;
    private AddressSetView validAddresses;
    protected TaskMonitor monitor;

    public AbstractModularizationCmd(String name, GroupPath path, String treeName, ProgramSelection selection, CodeBlockModel blockModel) {
        super(name, true, true, false);
        this.name = name;
        this.groupPath = path;
        this.treeName = treeName;
        this.selection = selection;
        this.codeBlockModel = blockModel;
    }

    protected abstract void applyModel() throws CancelledException;

    public boolean applyTo(DomainObject obj, TaskMonitor taskMonitor) {
        this.program = (Program)obj;
        this.monitor = taskMonitor;
        this.monitor.setIndeterminate(true);
        ProgramModule rootModule = this.program.getListing().getRootModule(this.treeName);
        this.selectedGroup = this.groupPath.getGroup(this.program, this.treeName);
        this.processEntireProgram = this.selectedGroup.equals(rootModule);
        this.destinationModule = this.selectedGroup instanceof ProgramModule ? (ProgramModule)this.selectedGroup : rootModule;
        this.processEntireProgram = this.selectedGroup.equals(rootModule);
        this.validAddresses = this.getAddressesForGroup();
        try {
            this.applyModel();
            this.cleanEmpty();
            return true;
        }
        catch (CancelledException e) {
            this.setStatusMsg("Cancelled");
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected exception modularizing the program tree", (Throwable)e);
            this.setStatusMsg("Unexpected Exception (see console)");
        }
        return false;
    }

    protected void cleanEmpty() throws NotEmptyException {
        ProgramModule rootModule = this.program.getListing().getRootModule(this.treeName);
        this.cleanTreeWithoutRename(rootModule);
    }

    private AddressSetView getAddressesForGroup() {
        if (this.processEntireProgram) {
            return this.program.getMemory();
        }
        if (this.selectedGroup instanceof ProgramModule) {
            ProgramModule module = (ProgramModule)this.selectedGroup;
            return this.getModuleAddresses(module);
        }
        return (ProgramFragment)this.selectedGroup;
    }

    private AddressSet getModuleAddresses(ProgramModule mod) {
        AddressSet set = new AddressSet();
        this.getAddressSet((Group)mod, set);
        return set;
    }

    private void getAddressSet(Group group, AddressSet set) {
        if (group instanceof ProgramFragment) {
            AddressRangeIterator iter = ((ProgramFragment)group).getAddressRanges();
            while (iter.hasNext() && !this.monitor.isCancelled()) {
                AddressRange range = (AddressRange)iter.next();
                set.add(range);
            }
        } else {
            Group[] groups;
            for (Group g : groups = ((ProgramModule)group).getChildren()) {
                this.getAddressSet(g, set);
            }
        }
    }

    protected GDirectedGraph<CodeBlockVertex, CodeBlockEdge> createCallGraph() throws CancelledException {
        HashMap<CodeBlock, CodeBlockVertex> instanceMap = new HashMap<CodeBlock, CodeBlockVertex>();
        GDirectedGraph graph = GraphFactory.createDirectedGraph();
        CodeBlockIterator codeBlocks = this.getCallGraphBlocks();
        while (codeBlocks.hasNext()) {
            CodeBlock block = codeBlocks.next();
            if (this.selection != null && !this.selection.contains(block.getFirstStartAddress())) continue;
            CodeBlockVertex fromVertex = (CodeBlockVertex)instanceMap.get(block);
            if (fromVertex == null) {
                fromVertex = new CodeBlockVertex(block);
                instanceMap.put(block, fromVertex);
                graph.addVertex((Object)fromVertex);
            }
            this.addEdgesForDestinations((GDirectedGraph<CodeBlockVertex, CodeBlockEdge>)graph, fromVertex, block, instanceMap);
        }
        return graph;
    }

    private void addEdgesForDestinations(GDirectedGraph<CodeBlockVertex, CodeBlockEdge> graph, CodeBlockVertex fromVertex, CodeBlock sourceBlock, Map<CodeBlock, CodeBlockVertex> instanceMap) throws CancelledException {
        CodeBlockReferenceIterator iterator = sourceBlock.getDestinations(this.monitor);
        while (iterator.hasNext()) {
            this.monitor.checkCancelled();
            CodeBlockReference destination = iterator.next();
            CodeBlock targetBlock = this.getDestinationBlock(destination);
            if (targetBlock == null) continue;
            CodeBlockVertex targetVertex = instanceMap.get(targetBlock);
            if (targetVertex == null) {
                targetVertex = new CodeBlockVertex(targetBlock);
                instanceMap.put(targetBlock, targetVertex);
            }
            graph.addVertex((Object)targetVertex);
            graph.addEdge((GEdge)new CodeBlockEdge(fromVertex, targetVertex));
        }
    }

    private CodeBlock getDestinationBlock(CodeBlockReference destination) throws CancelledException {
        Address targetAddress = destination.getDestinationAddress();
        CodeBlock targetBlock = this.codeBlockModel.getFirstCodeBlockContaining(targetAddress, this.monitor);
        if (targetBlock == null) {
            return null;
        }
        Address blockAddress = targetBlock.getFirstStartAddress();
        if (this.skipAddress(blockAddress)) {
            return null;
        }
        return targetBlock;
    }

    private boolean skipAddress(Address address) {
        if (this.processEntireProgram) {
            return false;
        }
        return !this.validAddresses.contains(address);
    }

    private CodeBlockIterator getCallGraphBlocks() throws CancelledException {
        if (this.processEntireProgram) {
            return this.codeBlockModel.getCodeBlocks(this.monitor);
        }
        if (this.selectedGroup instanceof ProgramModule) {
            ProgramModule module = (ProgramModule)this.selectedGroup;
            this.setModuleName(module, module.getName() + " [" + this.name + "]");
        }
        return this.codeBlockModel.getCodeBlocksContaining(this.validAddresses, this.monitor);
    }

    protected void makeFragment(Program p, ProgramModule module, CodeBlockVertex vertex) {
        if (vertex.isDummy()) {
            return;
        }
        CodeBlock block = vertex.getCodeBlock();
        ProgramFragment fragment = this.createFragment(module, block);
        AddressRangeIterator iter = block.getAddressRanges();
        while (iter.hasNext() && !this.monitor.isCancelled()) {
            AddressRange range = (AddressRange)iter.next();
            try {
                fragment.move(range.getMinAddress(), range.getMaxAddress());
            }
            catch (NotFoundException e) {
                Msg.error((Object)((Object)this), (Object)("Error moving addresses to fragment: " + fragment.getName()), (Throwable)e);
            }
        }
    }

    protected ProgramFragment createFragment(ProgramModule root, CodeBlock block) {
        boolean done = false;
        Object blockName = block.getName();
        while (!done) {
            try {
                return root.createFragment((String)blockName);
            }
            catch (DuplicateNameException e) {
                blockName = (String)blockName + "*";
            }
        }
        return null;
    }

    protected ProgramModule createModule(ProgramModule parent, String moduleName) {
        int index = 0;
        while (true) {
            try {
                return parent.createModule((String)moduleName);
            }
            catch (DuplicateNameException e) {
                moduleName = (String)moduleName + "(" + ++index + ")";
                continue;
            }
            break;
        }
    }

    private void setModuleName(ProgramModule module, String name) {
        Object attemptedName = name;
        int count = 0;
        while (true) {
            try {
                module.setName((String)attemptedName);
                return;
            }
            catch (DuplicateNameException e) {
                attemptedName = name + "_" + ++count;
                continue;
            }
            break;
        }
    }

    private void cleanTreeWithoutRename(ProgramModule module) throws NotEmptyException {
        Consumer<ProgramModule> doNotRename = m -> {};
        HashSet<ProgramModule> moduleSet = new HashSet<ProgramModule>();
        AbstractModularizationCmd.cleanTree(module, doNotRename, moduleSet);
    }

    static void cleanTree(ProgramModule module) throws NotEmptyException {
        Consumer<ProgramModule> renamer = m -> AbstractModularizationCmd.rename(module);
        HashSet<ProgramModule> moduleSet = new HashSet<ProgramModule>();
        AbstractModularizationCmd.cleanTree(module, renamer, moduleSet);
    }

    private static void cleanTree(ProgramModule module, Consumer<ProgramModule> renamer, Set<ProgramModule> visited) throws NotEmptyException {
        Group[] children;
        if (module == null || visited.contains(module)) {
            return;
        }
        visited.add(module);
        if (module.getNumChildren() == 0) {
            return;
        }
        for (Group child : children = module.getChildren()) {
            if (child instanceof ProgramModule) {
                ProgramModule childModule = (ProgramModule)child;
                AbstractModularizationCmd.cleanTree(childModule, renamer, visited);
                if (childModule.getNumChildren() != 0) continue;
                module.removeChild(childModule.getName());
                continue;
            }
            ProgramFragment fragment = (ProgramFragment)child;
            if (!fragment.isEmpty()) continue;
            module.removeChild(fragment.getName());
        }
        renamer.accept(module);
    }

    private static void rename(ProgramModule module) {
        try {
            String numKidsPrefix = "   [";
            String currentName = module.getName();
            int prefix = currentName.indexOf(numKidsPrefix);
            String baseName = prefix < 0 ? currentName : currentName.substring(0, prefix);
            module.setName(baseName + numKidsPrefix + module.getNumChildren() + "]");
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }
}

