/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaStateListener;
import agent.frida.model.AbstractFridaModel;
import agent.frida.model.iface1.FridaModelTargetAccessConditioned;
import agent.frida.model.iface1.FridaModelTargetExecutionStateful;
import agent.frida.model.iface2.FridaModelTargetObject;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetSession;
import agent.frida.model.iface2.FridaModelTargetThread;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class FridaModelTargetObjectImpl
extends DefaultTargetObject<TargetObject, TargetObject>
implements FridaModelTargetObject {
    protected boolean accessible = true;
    protected final FridaStateListener accessListener = this::checkExited;
    private boolean modified;
    private Object modelObject;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();

    public FridaModelTargetObjectImpl(AbstractFridaModel impl, TargetObject parent, String name, String typeHint) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint);
        this.setModelObject(((FridaModelTargetObject)parent).getModelObject());
        this.getManager().addStateListener(this.accessListener);
    }

    public FridaModelTargetObjectImpl(AbstractFridaModel impl, TargetObject parent, String name, Object modelObject, String typeHint) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint);
        this.setModelObject(modelObject);
        this.getManager().addStateListener(this.accessListener);
    }

    public FridaModelTargetObjectImpl(AbstractFridaModel impl, TargetObject parent, String name, Object modelObject, String typeHint, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint, schema);
        this.setModelObject(modelObject);
        this.getManager().addStateListener(this.accessListener);
    }

    public void setAttribute(String key, String value) {
        this.changeAttributes(List.of(), List.of(), Map.of(key, value), "Initialized");
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        super.doInvalidate(branch, reason);
        this.getManager().removeStateListener(this.accessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessible(boolean accessible) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.accessible == accessible) {
                return;
            }
            this.accessible = accessible;
        }
        if (this instanceof FridaModelTargetAccessConditioned) {
            this.changeAttributes(List.of(), List.of(), Map.of("_accessible", accessible), "Accessibility changed");
        }
    }

    @Override
    public AbstractFridaModel getModel() {
        return (AbstractFridaModel)this.model;
    }

    public void onRunning() {
        this.setAccessible(false);
    }

    public void onStopped() {
        this.setAccessible(true);
    }

    public void onExit() {
        this.setAccessible(true);
    }

    protected void checkExited(FridaState state, FridaCause cause) {
        TargetExecutionStateful.TargetExecutionState exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
        switch (state) {
            case FRIDA_THREAD_WAITING: {
                exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
                break;
            }
            case FRIDA_THREAD_UNINTERRUPTIBLE: {
                exec = TargetExecutionStateful.TargetExecutionState.ALIVE;
                break;
            }
            case FRIDA_THREAD_STOPPED: {
                exec = TargetExecutionStateful.TargetExecutionState.STOPPED;
                this.onStopped();
                break;
            }
            case FRIDA_THREAD_RUNNING: {
                exec = TargetExecutionStateful.TargetExecutionState.RUNNING;
                this.resetModified();
                this.onRunning();
                break;
            }
            case FRIDA_THREAD_HALTED: {
                exec = TargetExecutionStateful.TargetExecutionState.TERMINATED;
                if (this.getParentProcess() != null || this instanceof TargetProcess) {
                    this.getManager().removeStateListener(this.accessListener);
                }
                this.onExit();
            }
        }
        if (this instanceof FridaModelTargetExecutionStateful) {
            FridaModelTargetExecutionStateful stateful = (FridaModelTargetExecutionStateful)((Object)this);
            stateful.setExecutionState(exec, "Refreshed");
        }
    }

    @Override
    public CompletableFuture<? extends Map<String, ?>> requestNativeAttributes() {
        throw new AssertionError();
    }

    @Override
    public CompletableFuture<List<TargetObject>> requestNativeElements() {
        throw new AssertionError();
    }

    @Override
    public FridaModelTargetSession getParentSession() {
        FridaModelTargetObject test;
        for (test = (FridaModelTargetObject)this.parent; test != null && !(test instanceof FridaModelTargetSession); test = (FridaModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (FridaModelTargetSession)test;
    }

    @Override
    public FridaModelTargetProcess getParentProcess() {
        FridaModelTargetObject test;
        for (test = (FridaModelTargetObject)this.parent; test != null && !(test instanceof TargetProcess); test = (FridaModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (FridaModelTargetProcess)test;
    }

    @Override
    public FridaModelTargetThread getParentThread() {
        FridaModelTargetObject test;
        for (test = (FridaModelTargetObject)this.parent; test != null && !(test instanceof TargetThread); test = (FridaModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (FridaModelTargetThread)test;
    }

    @Override
    public void setModified(Map<String, Object> map, boolean b) {
        if (this.modified) {
            map.put("_modified", this.modified);
        }
    }

    @Override
    public void setModified(boolean modified) {
        if (modified) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", modified), "Refreshed");
        }
    }

    @Override
    public void resetModified() {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
    }

    public TargetObject searchForSuitable(Class<? extends TargetObject> type) {
        List pathToClass = this.model.getRootSchema().searchForSuitable(type, this.path);
        return this.model.getModelObject(pathToClass);
    }

    public String getDescription(int level) {
        return this.getName();
    }

    @Override
    public Object getModelObject() {
        return this.modelObject;
    }

    @Override
    public void setModelObject(Object modelObject) {
        if (modelObject != null) {
            ((FridaModelTargetObject)this.parent).addMapObject(modelObject, (TargetObject)this);
        }
        this.modelObject = modelObject;
    }

    @Override
    public void addMapObject(Object object, TargetObject targetObject) {
        if (object == null) {
            return;
        }
        this.objectMap.put(FridaClient.getModelKey(object), targetObject);
    }

    @Override
    public TargetObject getMapObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.objectMap.get(FridaClient.getModelKey(object));
    }

    @Override
    public void deleteMapObject(Object object) {
        if (object == null) {
            return;
        }
        this.objectMap.remove(FridaClient.getModelKey(object));
    }
}

