/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaSection;
import agent.frida.model.iface2.FridaModelTargetModuleSection;
import agent.frida.model.impl.FridaModelTargetModuleSectionContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Section", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class FridaModelTargetModuleSectionImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModuleSection {
    protected static final String OBJFILE_ATTRIBUTE_NAME = "_objfile";
    protected AddressRange range;

    protected static String keySection(FridaSection section) {
        return PathUtils.makeKey((String)section.getRangeAddress());
    }

    public FridaModelTargetModuleSectionImpl(FridaModelTargetModuleSectionContainerImpl sections, FridaSection section) {
        super(sections.getModel(), (TargetObject)sections, FridaModelTargetModuleSectionImpl.keySection(section), section, "Section");
        AddressSpace space = this.getModel().getAddressSpace("ram");
        Address min = space.getAddress(0L);
        long lval = Long.decode(section.getRangeAddress());
        if (lval != -1L) {
            min = space.getAddress(lval);
        }
        long sz = section.getRangeSize();
        Address max = min.add(sz);
        this.range = new AddressRangeImpl(min, max);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", this.range), "Initialized");
        }
        this.changeAttributes(List.of(), List.of(), Map.of("_module", sections.getParent(), "_display", this.getDescription(2), "Address", min, "File Offset", section.getFileOffset(), "Size", Long.toHexString(sz), "Permissions", section.getProtection()), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        FridaSection section = (FridaSection)this.getModelObject();
        Object description = section.getRangeAddress();
        if (level > 0) {
            description = (String)description + " " + section.getProtection();
        }
        if (level > 1) {
            description = (String)description + " " + Long.toHexString(section.getFileOffset());
        }
        if (level > 2) {
            description = (String)description + " " + section.getFilePath();
        }
        return description;
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }
}

