/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.frida;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaFileSpec;
import agent.frida.manager.FridaKernelMemoryRegionInfo;
import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaProcess;
import java.util.HashMap;
import java.util.Map;

public class FridaRegionInfo {
    private FridaProcess process;
    private long numRegions;
    private Map<Integer, FridaMemoryRegionInfo> regions = new HashMap<Integer, FridaMemoryRegionInfo>();

    public FridaRegionInfo(FridaProcess process, FridaMemoryRegionInfo region) {
        this.process = process;
        this.numRegions = 1L;
        this.regions.put(0, region);
    }

    public FridaRegionInfo(FridaKernelMemoryRegionInfo region) {
        this.process = null;
        this.numRegions = 1L;
        this.regions.put(0, region);
    }

    public Long getNumberOfRegions() {
        return this.numRegions;
    }

    public FridaMemoryRegionInfo getRegion(int index) {
        return this.regions.get(index);
    }

    public String toString(int index) {
        FridaMemoryRegionInfo region = this.regions.get(index);
        return region.toString();
    }

    public String getRegionName(int index) {
        FridaMemoryRegionInfo region = this.regions.get(index);
        return FridaClient.getId(region);
    }

    public void setRegionName(int index, String regionName) {
        FridaMemoryRegionInfo region = this.regions.get(index);
        FridaFileSpec filespec = region.getFileSpec();
        if (filespec != null) {
            filespec.setPath(regionName);
        }
    }

    public FridaProcess getProcess() {
        return this.process;
    }
}

