/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.frida;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaKernelModule;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import java.util.HashMap;
import java.util.Map;

public class FridaModuleInfo {
    private FridaProcess process;
    private long numModules;
    private Map<Integer, FridaModule> modules = new HashMap<Integer, FridaModule>();

    public FridaModuleInfo(FridaProcess process, FridaModule module) {
        this.process = process;
        this.numModules = 1L;
        this.modules.put(0, module);
    }

    public FridaModuleInfo(FridaKernelModule module) {
        this.process = null;
        this.numModules = 1L;
        this.modules.put(0, module);
    }

    public Long getNumberOfModules() {
        return this.numModules;
    }

    public FridaModule getModule(int index) {
        return this.modules.get(index);
    }

    public String toString(int index) {
        FridaModule module = this.modules.get(index);
        return module.toString();
    }

    public String getModuleName(int index) {
        FridaModule module = this.modules.get(index);
        return FridaClient.getId(module);
    }

    public void setModuleName(int index, String moduleName) {
        FridaModule module = this.modules.get(index);
        module.setName(moduleName);
    }

    public String getImageName(int index) {
        FridaModule module = this.modules.get(index);
        return module.getPath();
    }

    public void setImageName(int index, String dirName, String imageName) {
        FridaModule module = this.modules.get(index);
        module.setPath(imageName);
    }

    public FridaProcess getProcess() {
        return this.process;
    }
}

