/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbStackFrameImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import agent.gdb.manager.parsing.GdbMiParser;
import java.util.ArrayList;
import java.util.List;

public class GdbStackListFramesCommand
extends AbstractGdbCommandWithThreadId<List<GdbStackFrame>> {
    protected final GdbThreadImpl thread;

    public GdbStackListFramesCommand(GdbManagerImpl manager, GdbThreadImpl thread) {
        super(manager, thread.getId());
        this.thread = thread;
    }

    @Override
    protected String encode(String threadPart) {
        return "-stack-list-frames" + threadPart;
    }

    @Override
    public List<GdbStackFrame> complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        GdbMiParser.GdbMiFieldList stack = done.assumeStack();
        ArrayList<GdbStackFrame> result = new ArrayList<GdbStackFrame>(stack.size());
        for (Object obj : stack.get("frame")) {
            GdbMiParser.GdbMiFieldList f = (GdbMiParser.GdbMiFieldList)obj;
            GdbStackFrameImpl frame = GdbStackFrameImpl.fromFieldList(this.thread, f);
            result.add(frame);
        }
        return result;
    }
}

