/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadAndFrameId;
import agent.gdb.manager.parsing.GdbCValueParser;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import ghidra.pcode.utils.Utils;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GdbReadRegistersCommand
extends AbstractGdbCommandWithThreadAndFrameId<Map<GdbRegister, BigInteger>> {
    private final Set<GdbRegister> regs;
    private final GdbThreadImpl thread;

    protected static BigInteger tryStructPatterns(GdbCValueParser.GdbCompositeValue cv, int byteCount, ByteOrder endianness) {
        for (Map.Entry ent : cv.entrySet()) {
            switch ((String)ent.getKey()) {
                case "v1_int8": 
                case "v2_int8": 
                case "v4_int8": 
                case "v8_int8": 
                case "v16_int8": 
                case "v32_int8": 
                case "v64_int8": 
                case "u8": {
                    BigInteger result;
                    Object v = ent.getValue();
                    if (v instanceof GdbCValueParser.GdbArrayValue) {
                        GdbCValueParser.GdbArrayValue arr = (GdbCValueParser.GdbArrayValue)v;
                        v0 = GdbReadRegistersCommand.packElements(arr, byteCount, 1, endianness);
                    } else {
                        v0 = result = null;
                    }
                    if (result != null) {
                        return result;
                    }
                }
                case "b": {
                    BigInteger result;
                    Object v = ent.getValue();
                    if (v instanceof GdbCValueParser.GdbCompositeValue) {
                        GdbCValueParser.GdbCompositeValue nested = (GdbCValueParser.GdbCompositeValue)v;
                        v1 = GdbReadRegistersCommand.tryStructPatternsB(nested, byteCount, endianness);
                    } else {
                        v1 = result = null;
                    }
                    if (result == null) break;
                    return result;
                }
            }
        }
        return null;
    }

    protected static BigInteger tryStructPatternsB(GdbCValueParser.GdbCompositeValue cv, int byteCount, ByteOrder endianness) {
        for (Map.Entry ent : cv.entrySet()) {
            switch ((String)ent.getKey()) {
                case "u": {
                    BigInteger result;
                    Object v = ent.getValue();
                    if (v instanceof GdbCValueParser.GdbArrayValue) {
                        GdbCValueParser.GdbArrayValue arr = (GdbCValueParser.GdbArrayValue)v;
                        v0 = GdbReadRegistersCommand.packElements(arr, byteCount, 1, endianness);
                    } else {
                        v0 = result = null;
                    }
                    if (result == null) break;
                    return result;
                }
            }
        }
        return null;
    }

    public GdbReadRegistersCommand(GdbManagerImpl manager, GdbThreadImpl thread, Integer frameId, Set<GdbRegister> regs) {
        super(manager, thread.getId(), frameId);
        this.thread = thread;
        this.regs = regs;
    }

    @Override
    protected String encode(String threadPart, String framePart) {
        if (this.regs.isEmpty()) {
            return "-interpreter-exec console echo";
        }
        StringBuilder b = new StringBuilder();
        b.append("-data-list-register-values");
        b.append(threadPart);
        b.append(framePart);
        b.append(" x");
        for (GdbRegister r : this.regs) {
            b.append(" ");
            b.append(r.getNumber());
        }
        return b.toString();
    }

    public static BigInteger packElements(GdbCValueParser.GdbArrayValue av, int byteCount, int bytesPer, ByteOrder endianness) {
        assert (bytesPer * av.size() == byteCount);
        List<BigInteger> elems = av.expectBigInts();
        byte[] packed = new byte[byteCount];
        ByteBuffer buf = ByteBuffer.wrap(packed);
        int i = endianness == ByteOrder.BIG_ENDIAN ? 0 : packed.length - bytesPer;
        int step = endianness == ByteOrder.BIG_ENDIAN ? bytesPer : -bytesPer;
        for (BigInteger elem : elems) {
            buf.position(i);
            switch (bytesPer) {
                case 1: {
                    buf.put(elem.byteValue());
                    break;
                }
                case 2: {
                    buf.putShort(elem.shortValue());
                    break;
                }
                case 4: {
                    buf.putInt(elem.intValue());
                    break;
                }
                case 8: {
                    buf.putLong(elem.longValue());
                    break;
                }
                default: {
                    buf.put(Utils.bigIntegerToBytes((BigInteger)elem, (int)bytesPer, (boolean)true));
                }
            }
            i += step;
        }
        return new BigInteger(1, packed);
    }

    public static BigInteger parseAndFindInteger(String val, int byteCount, ByteOrder endianness) throws GdbParsingUtils.GdbParseError {
        if (val.contains("lbound")) {
            return BigInteger.ZERO;
        }
        GdbCValueParser.GdbCValue value = GdbCValueParser.parseValue(val);
        if (value instanceof GdbCValueParser.GdbIntValue) {
            GdbCValueParser.GdbIntValue iv = (GdbCValueParser.GdbIntValue)value;
            return iv.getValue();
        }
        if (value instanceof GdbCValueParser.GdbCompositeValue) {
            GdbCValueParser.GdbCompositeValue cv = (GdbCValueParser.GdbCompositeValue)value;
            for (GdbCValueParser.GdbCValue v : cv.values()) {
                if (!(v instanceof GdbCValueParser.GdbIntValue)) continue;
                GdbCValueParser.GdbIntValue iv = (GdbCValueParser.GdbIntValue)v;
                return iv.getValue();
            }
            BigInteger result = GdbReadRegistersCommand.tryStructPatterns(cv, byteCount, endianness);
            if (result != null) {
                return result;
            }
        }
        if (value instanceof GdbCValueParser.GdbArrayValue) {
            GdbCValueParser.GdbArrayValue av = (GdbCValueParser.GdbArrayValue)value;
            if (byteCount % av.size() != 0) {
                throw new AssertionError((Object)("Cannot divide bytes evenly among vector elements. size=" + byteCount + ", value=" + val));
            }
            int bytesPer = byteCount / av.size();
            return GdbReadRegistersCommand.packElements(av, byteCount, bytesPer, endianness);
        }
        throw new AssertionError((Object)("Expected an int, a union containing an int, or an array. Got " + val));
    }

    @Override
    public Map<GdbRegister, BigInteger> complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        if (this.regs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Integer, GdbRegister> regsByNumber = this.regs.stream().collect(Collectors.toMap(GdbRegister::getNumber, r -> r));
        List<GdbMiParser.GdbMiFieldList> valueList = done.assumeRegisterValueList();
        LinkedHashMap<GdbRegister, BigInteger> result = new LinkedHashMap<GdbRegister, BigInteger>();
        ByteOrder endianness = this.thread.getInferior().getEndianness();
        for (GdbMiParser.GdbMiFieldList fields : valueList) {
            int number = Integer.parseInt(fields.getString("number"));
            String value = fields.getString("value");
            GdbRegister r2 = regsByNumber.get(number);
            if (r2 == null) {
                Msg.error((Object)this, (Object)("GDB gave value for non-requested register: " + number));
                continue;
            }
            try {
                result.put(r2, GdbReadRegistersCommand.parseAndFindInteger(value, r2.getSize(), endianness));
            }
            catch (GdbParsingUtils.GdbParseError | AssertionError e) {
                Msg.warn((Object)this, (Object)("Could not figure register value for [" + number + "] = " + value));
            }
        }
        return result;
    }
}

