/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbCommandErrorEvent;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.cmd.GdbCommandError;
import agent.gdb.manager.parsing.GdbMiParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class GdbPendingCommand<T>
extends CompletableFuture<T>
implements GdbCause {
    private final GdbCommand<? extends T> cmd;
    private final Set<GdbEvent<?>> evts = new LinkedHashSet();

    public GdbPendingCommand(GdbCommand<? extends T> cmd) {
        this.cmd = cmd;
    }

    public GdbCommand<? extends T> getCommand() {
        return this.cmd;
    }

    public Integer impliesCurrentThreadId() {
        return this.cmd.impliesCurrentThreadId();
    }

    public Integer impliesCurrentFrameId() {
        return this.cmd.impliesCurrentFrameId();
    }

    public void finish() {
        try {
            T result = this.cmd.complete(this);
            this.complete(result);
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    public boolean handle(GdbEvent<?> evt) {
        return this.cmd.handle(evt, this);
    }

    public void claim(GdbEvent<?> evt) {
        evt.claim(this);
        this.evts.add(evt);
    }

    public void steal(GdbEvent<?> evt) {
        this.claim(evt);
        evt.steal();
    }

    public <E extends GdbEvent<?>> E castSingleEvent(Class<E> cls) {
        if (this.evts.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one event");
        }
        return (E)((GdbEvent)cls.cast(this.evts.iterator().next()));
    }

    public <E extends GdbEvent<?>> E getFirstOf(Class<E> cls) {
        for (GdbEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            return (E)((GdbEvent)cls.cast(evt));
        }
        return null;
    }

    public <E extends GdbEvent<?>> E findFirstOf(Class<E> cls) {
        E first = this.getFirstOf(cls);
        if (first != null) {
            return first;
        }
        throw new IllegalStateException("Command did not claim any " + cls);
    }

    public boolean hasAny(Class<? extends GdbEvent<?>> cls) {
        return this.getFirstOf(cls) != null;
    }

    public <E extends GdbEvent<?>> List<E> findAllOf(Class<E> cls) {
        ArrayList<GdbEvent> found = new ArrayList<GdbEvent>();
        for (GdbEvent<?> evt : this.evts) {
            if (!cls.isAssignableFrom(evt.getClass())) continue;
            found.add((GdbEvent)cls.cast(evt));
        }
        return found;
    }

    public <E extends GdbEvent<?>> E findSingleOf(Class<E> cls) {
        List<E> found = this.findAllOf(cls);
        if (found.size() != 1) {
            throw new IllegalStateException("Command did not claim exactly one " + cls + ". Have " + this.evts);
        }
        return (E)((GdbEvent)found.get(0));
    }

    @SafeVarargs
    public final <E extends AbstractGdbCompletedCommandEvent> E checkCompletion(Class<E> ... classes) {
        AbstractGdbCompletedCommandEvent completion = this.findSingleOf(AbstractGdbCompletedCommandEvent.class);
        for (Class<E> cls : classes) {
            if (cls != completion.getClass()) continue;
            return (E)((AbstractGdbCompletedCommandEvent)cls.cast(completion));
        }
        if (completion instanceof GdbCommandErrorEvent) {
            throw new GdbCommandError((GdbMiParser.GdbMiFieldList)completion.getInfo(), this.cmd);
        }
        for (Class<E> cls : classes) {
            if (!cls.isAssignableFrom(completion.getClass())) continue;
            return (E)((AbstractGdbCompletedCommandEvent)cls.cast(completion));
        }
        throw new IllegalStateException("Command completed with " + completion + ", not any of " + Arrays.asList(classes));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cmd + ")";
    }
}

