/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.CharacterTermSplitter;
import docking.widgets.filter.ContainsTextFilterFactory;
import docking.widgets.filter.MatchesExactlyTextFilterFactory;
import docking.widgets.filter.MultitermEvaluationMode;
import docking.widgets.filter.RegularExpressionTextFilterFactory;
import docking.widgets.filter.StartsWithTextFilterFactory;
import docking.widgets.filter.TermSplitter;
import docking.widgets.filter.TextFilterFactory;
import docking.widgets.filter.TextFilterStrategy;
import generic.theme.GIcon;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class FilterOptions {
    private static final Icon CONTAINS_ICON = new GIcon("icon.filter.options.contains");
    private static final Icon STARTS_WITH_ICON = new GIcon("icon.filter.options.starts.with");
    private static final Icon EXACT_MATCH_ICON = new GIcon("icon.filter.options.exact");
    private static final Icon REG_EX_ICON = new GIcon("icon.filter.options.regex");
    private static final Icon NOT_ICON = new GIcon("icon.filter.options.not");
    static final Map<Character, String> DELIMITER_NAME_MAP = new HashMap<Character, String>(20);
    public static final String VALID_MULTITERM_DELIMITERS;
    public static final String[] VALID_MULTITERM_DELIMITERS_ARRAY;
    public static final Character DEFAULT_DELIMITER;
    private final boolean caseSensitive;
    private final boolean inverted;
    private final boolean usePath;
    private final TextFilterStrategy textFilterStrategy;
    private final boolean allowGlobbing;
    private final boolean multiTerm;
    private final char delimitingCharacter;
    private final MultitermEvaluationMode evalMode;

    public FilterOptions() {
        this(TextFilterStrategy.CONTAINS, true, false, false);
    }

    public FilterOptions(TextFilterStrategy textFilterStrategy, boolean allowGlobbing, boolean caseSensitive, boolean inverted) {
        this(textFilterStrategy, allowGlobbing, caseSensitive, inverted, false, false, DEFAULT_DELIMITER.charValue(), MultitermEvaluationMode.AND);
    }

    public FilterOptions(TextFilterStrategy textFilterStrategy, boolean allowGlobbing, boolean caseSensitive, boolean inverted, boolean multiTerm, char delimiterCharacter) {
        this(textFilterStrategy, allowGlobbing, caseSensitive, inverted, false, multiTerm, delimiterCharacter, MultitermEvaluationMode.AND);
    }

    public FilterOptions(TextFilterStrategy textFilterStrategy, boolean allowGlobbing, boolean caseSensitive, boolean inverted, boolean usePath, boolean multiTerm, char delimiterCharacter, MultitermEvaluationMode mode) {
        if (textFilterStrategy == null) {
            throw new NullPointerException("TextFilterStrategy Cannot be null");
        }
        if (multiTerm && VALID_MULTITERM_DELIMITERS.indexOf(delimiterCharacter) < 0) {
            throw new IllegalArgumentException("Delimiter character '" + delimiterCharacter + "' not among '" + VALID_MULTITERM_DELIMITERS + "'");
        }
        this.textFilterStrategy = textFilterStrategy;
        this.allowGlobbing = allowGlobbing;
        this.caseSensitive = caseSensitive;
        this.inverted = inverted;
        this.usePath = usePath;
        this.multiTerm = textFilterStrategy == TextFilterStrategy.REGULAR_EXPRESSION ? false : multiTerm;
        this.delimitingCharacter = delimiterCharacter;
        this.evalMode = mode;
    }

    public static FilterOptions restoreFromXML(Element element) {
        String filtertypeName = element.getAttributeValue("FILTER_TYPE");
        TextFilterStrategy textFilterStrategy = FilterOptions.getTextFilterStrategy(filtertypeName);
        String globValue = element.getAttributeValue("GLOBBING");
        boolean globbing = globValue == null ? true : Boolean.parseBoolean(globValue);
        boolean caseSensitive = Boolean.parseBoolean(element.getAttributeValue("CASE_SENSITIVE"));
        boolean inverted = Boolean.parseBoolean(element.getAttributeValue("INVERTED"));
        boolean usePath = Boolean.parseBoolean(element.getAttributeValue("USE_PATH"));
        boolean multiterm = Boolean.parseBoolean(element.getAttributeValue("MULTITERM"));
        Object delimiterCharacterStr = element.getAttributeValue("TERM_DELIMITER");
        if (delimiterCharacterStr == null) {
            delimiterCharacterStr = "" + DEFAULT_DELIMITER;
        }
        boolean andMode = Boolean.parseBoolean(element.getAttributeValue("AND_EVAL_MODE", "True"));
        return new FilterOptions(textFilterStrategy, globbing, caseSensitive, inverted, usePath, multiterm, ((String)delimiterCharacterStr).charAt(0), andMode ? MultitermEvaluationMode.AND : MultitermEvaluationMode.OR);
    }

    private static TextFilterStrategy getTextFilterStrategy(String filtertypeName) {
        if (filtertypeName == null) {
            return TextFilterStrategy.CONTAINS;
        }
        return TextFilterStrategy.valueOf(filtertypeName);
    }

    public Element toXML() {
        Element xmlElement = new Element("Filter_Options");
        xmlElement.setAttribute("FILTER_TYPE", this.textFilterStrategy.name());
        xmlElement.setAttribute("GLOBBING", Boolean.toString(this.allowGlobbing));
        xmlElement.setAttribute("CASE_SENSITIVE", Boolean.toString(this.caseSensitive));
        xmlElement.setAttribute("INVERTED", Boolean.toString(this.inverted));
        xmlElement.setAttribute("USE_PATH", Boolean.toString(this.usePath));
        xmlElement.setAttribute("MULTITERM", Boolean.toString(this.multiTerm));
        xmlElement.setAttribute("TERM_DELIMITER", "" + this.delimitingCharacter);
        xmlElement.setAttribute("AND_EVAL_MODE", Boolean.toString(this.evalMode == MultitermEvaluationMode.AND));
        return xmlElement;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isGlobbingAllowed() {
        return this.allowGlobbing;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean shouldUsePath() {
        return this.usePath;
    }

    public TextFilterStrategy getTextFilterStrategy() {
        return this.textFilterStrategy;
    }

    public boolean isMultiterm() {
        return this.multiTerm;
    }

    public char getDelimitingCharacter() {
        return this.delimitingCharacter;
    }

    public MultitermEvaluationMode getMultitermEvaluationMode() {
        return this.evalMode;
    }

    public TextFilterFactory getTextFilterFactory() {
        switch (this.textFilterStrategy) {
            case CONTAINS: {
                return new ContainsTextFilterFactory(this.caseSensitive, this.allowGlobbing);
            }
            case MATCHES_EXACTLY: {
                return new MatchesExactlyTextFilterFactory(this.caseSensitive, this.allowGlobbing);
            }
            case STARTS_WITH: {
                return new StartsWithTextFilterFactory(this.caseSensitive, this.allowGlobbing);
            }
            case REGULAR_EXPRESSION: {
                return new RegularExpressionTextFilterFactory();
            }
        }
        return null;
    }

    public TermSplitter getTermSplitter() {
        if (this.isMultiterm()) {
            return new CharacterTermSplitter(this.delimitingCharacter);
        }
        return null;
    }

    public static Icon getIcon(TextFilterStrategy filterStrategy) {
        switch (filterStrategy) {
            case CONTAINS: {
                return CONTAINS_ICON;
            }
            case MATCHES_EXACTLY: {
                return EXACT_MATCH_ICON;
            }
            case STARTS_WITH: {
                return STARTS_WITH_ICON;
            }
            case REGULAR_EXPRESSION: {
                return REG_EX_ICON;
            }
        }
        return CONTAINS_ICON;
    }

    public Icon getFilterStateIcon() {
        Icon icon = FilterOptions.getIcon(this.textFilterStrategy);
        if (this.inverted) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            int notWidth = NOT_ICON.getIconWidth();
            int notHeight = NOT_ICON.getIconHeight();
            icon = new MultiIcon(icon, new Icon[]{new TranslateIcon(NOT_ICON, width - notWidth / 2, height - notHeight / 2)});
        }
        return icon;
    }

    public String getFilterDescription() {
        StringBuffer buf = new StringBuffer("<html>");
        buf.append("<b>Filter Settings:</b>");
        buf.append("<br>");
        buf.append("<table>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append("Match Type: ");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.textFilterStrategy.toString());
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append("Invert Match Results: ");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.inverted ? "YES" : "NO");
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append("Case Sensitive: ");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.caseSensitive ? "YES" : "NO");
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append("Globbing Enabled: ");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.allowGlobbing ? "YES" : "NO");
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append("Multi-Term: ");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.isMultiterm() ? "YES" : "NO");
        buf.append("</td>");
        buf.append("</tr>");
        if (this.isMultiterm()) {
            buf.append("<tr>");
            buf.append("<td>");
            buf.append("&nbsp;");
            buf.append("&nbsp;");
            buf.append("Term Delimiter: ");
            buf.append("</td>");
            buf.append("<td>");
            char delim = this.getDelimitingCharacter();
            String delimName = DELIMITER_NAME_MAP.get(Character.valueOf(delim));
            buf.append("'").append(delim).append("'").append("&nbsp; <i>(").append(delimName).append(")</i>");
            buf.append("</td>");
            buf.append("</tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    static {
        DELIMITER_NAME_MAP.put(Character.valueOf(' '), "Space");
        DELIMITER_NAME_MAP.put(Character.valueOf('~'), "Tilde");
        DELIMITER_NAME_MAP.put(Character.valueOf('`'), "Back quote");
        DELIMITER_NAME_MAP.put(Character.valueOf('!'), "Exclamation point");
        DELIMITER_NAME_MAP.put(Character.valueOf('@'), "At sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('#'), "Pound sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('$'), "Dollar sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('%'), "Percent sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('^'), "Caret");
        DELIMITER_NAME_MAP.put(Character.valueOf('&'), "Ampersand");
        DELIMITER_NAME_MAP.put(Character.valueOf('*'), "Asterisk");
        DELIMITER_NAME_MAP.put(Character.valueOf('-'), "Hyphen");
        DELIMITER_NAME_MAP.put(Character.valueOf('_'), "Underscore");
        DELIMITER_NAME_MAP.put(Character.valueOf('+'), "Plus sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('='), "Equals sign");
        DELIMITER_NAME_MAP.put(Character.valueOf('|'), "Pipe (Bar)");
        DELIMITER_NAME_MAP.put(Character.valueOf(':'), "Colon");
        DELIMITER_NAME_MAP.put(Character.valueOf(';'), "Semi-colon");
        DELIMITER_NAME_MAP.put(Character.valueOf(','), "Comma");
        DELIMITER_NAME_MAP.put(Character.valueOf('.'), "Period (Dot)");
        VALID_MULTITERM_DELIMITERS = DELIMITER_NAME_MAP.keySet().stream().sorted().map(c -> Character.toString(c.charValue())).collect(Collectors.joining(""));
        VALID_MULTITERM_DELIMITERS_ARRAY = DELIMITER_NAME_MAP.keySet().stream().sorted().map(c -> Character.toString(c.charValue())).collect(Collectors.toList()).toArray(new String[DELIMITER_NAME_MAP.size()]);
        DEFAULT_DELIMITER = Character.valueOf(',');
    }
}

