/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.func;

import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import sarif.export.func.ExtFunctionStackVar;

public class ExtFunctionStack
implements IsfObject {
    int localVarSize;
    int parameterOffset;
    int returnAddressOffset;
    int purgeSize;
    List<ExtFunctionStackVar> stackVars = new ArrayList<ExtFunctionStackVar>();

    public ExtFunctionStack(StackFrame stackFrame, boolean hasCustomStorage) {
        this.localVarSize = stackFrame.getLocalSize();
        this.parameterOffset = stackFrame.getParameterOffset();
        this.returnAddressOffset = stackFrame.getReturnAddressOffset();
        Variable[] vars = stackFrame.getStackVariables();
        if (hasCustomStorage) {
            Arrays.sort(vars, new Comparator<Variable>(){

                @Override
                public int compare(Variable o1, Variable o2) {
                    if (o1 instanceof Parameter) {
                        Parameter p1 = (Parameter)o1;
                        if (o2 instanceof Parameter) {
                            Parameter p2 = (Parameter)o2;
                            return p1.getOrdinal() - p2.getOrdinal();
                        }
                    }
                    return o1.getStackOffset() - o2.getStackOffset();
                }
            });
        }
        for (Variable var : vars) {
            this.stackVars.add(new ExtFunctionStackVar(var));
        }
    }

    public void setPurgeSize(int purgeSize) {
        this.purgeSize = purgeSize;
    }
}

