/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.datamodel.script;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScript;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptHostContextInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.IDataModelScriptHostContext;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DataModelScriptHostContextImpl
implements DataModelScriptHostContextInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelScriptHostContext jnaData;

    public DataModelScriptHostContextImpl(IDataModelScriptHostContext jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void notifyScriptChange(DataModelScript script, int changeKind) {
        Pointer pScript = script.getPointer();
        WinDef.ULONG ulChangeKind = new WinDef.ULONG((long)changeKind);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.NotifyScriptChange(pScript, ulChangeKind));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getNamespaceObject() {
        PointerByReference ppNamespaceObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetNamespaceObject(ppNamespaceObject));
        WrapIModelObject wrap = new WrapIModelObject(ppNamespaceObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }
}

