/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;

public abstract class RetypeFieldTask {
    protected Composite composite;
    protected DataType newType = null;
    protected DataType oldType;
    protected String errorMsg = null;
    protected PluginTool tool;
    protected Program program;
    protected DecompilerProvider provider;
    protected ClangToken tokenAtCursor;

    public RetypeFieldTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, Composite composite) {
        this.tool = tool;
        this.program = program;
        this.provider = provider;
        this.tokenAtCursor = token;
        this.composite = composite;
    }

    public abstract String getTransactionName();

    public abstract boolean isValidBefore();

    public abstract boolean isValidAfter();

    public abstract void commit() throws IllegalArgumentException;

    public void runTask() {
        if (!this.isValidBefore()) {
            Msg.showError((Object)this, null, (String)"Retype Failed", (Object)this.errorMsg);
            return;
        }
        this.newType = AbstractDecompilerAction.chooseDataType(this.tool, this.program, this.oldType);
        if (this.newType == null || this.newType.isEquivalent(this.oldType)) {
            return;
        }
        int transaction = this.program.startTransaction(this.getTransactionName());
        try {
            ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
            this.newType = dtm.resolve(this.newType, null);
            if (!this.isValidAfter()) {
                Msg.showError((Object)this, null, (String)"Retype Failed", (Object)("Cannot retype field in '" + this.composite.getName() + "': " + this.errorMsg));
                return;
            }
            this.commit();
        }
        catch (IllegalArgumentException e) {
            Msg.showError((Object)this, null, (String)"Retype Failed", (Object)("Failed to retype field in '" + this.composite.getName() + "': " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.program.endTransaction(transaction, true);
        }
    }
}

