/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBHandle;
import ghidra.framework.data.DBDomainObjectSupport;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.database.DBOpenMode;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class DBCachedDomainObjectAdapter
extends DBDomainObjectSupport {
    protected ReadWriteLock rwLock;

    protected DBCachedDomainObjectAdapter(DBHandle dbh, DBOpenMode openMode, TaskMonitor monitor, String name, int timeInterval, int bufSize, Object consumer) {
        super(dbh, openMode, monitor, name, timeInterval, bufSize, consumer);
        this.rwLock = new GhidraLockWrappingRWLock(this.lock);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.rwLock;
    }

    static class GhidraLockWrappingRWLock
    implements ReadWriteLock {
        private final GhidraLockWrappingLock oneLock;

        public GhidraLockWrappingRWLock(Lock ghidraLock) {
            this.oneLock = new GhidraLockWrappingLock(ghidraLock);
        }

        @Override
        public java.util.concurrent.locks.Lock readLock() {
            return this.oneLock;
        }

        @Override
        public java.util.concurrent.locks.Lock writeLock() {
            return this.oneLock;
        }
    }

    static class GhidraLockWrappingLock
    implements java.util.concurrent.locks.Lock {
        private final Lock ghidraLock;

        public GhidraLockWrappingLock(Lock ghidraLock) {
            this.ghidraLock = ghidraLock;
        }

        @Override
        public void lock() {
            this.ghidraLock.acquire();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock() {
            Lock lock = this.ghidraLock;
            synchronized (lock) {
                Thread lockOwner = this.ghidraLock.getOwner();
                if (lockOwner == null || lockOwner == Thread.currentThread()) {
                    this.ghidraLock.acquire();
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            this.ghidraLock.release();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    static class SwingAwareReadWriteLock
    extends ReentrantReadWriteLock {
        private SwingAwareReadLock readerLock = new SwingAwareReadLock(this);
        private SwingAwareWriteLock writerLock = new SwingAwareWriteLock(this);

        SwingAwareReadWriteLock() {
        }

        @Override
        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readerLock;
        }

        @Override
        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writerLock;
        }

        static class SwingAwareReadLock
        extends ReentrantReadWriteLock.ReadLock {
            protected SwingAwareReadLock(ReentrantReadWriteLock lock) {
                super(lock);
            }

            @Override
            public void lock() {
                long blockStartTime = System.currentTimeMillis();
                super.lock();
                long blockEndTime = System.currentTimeMillis();
                long lapsed = blockEndTime - blockStartTime;
                if (Swing.isSwingThread() && lapsed > 30L) {
                    Msg.warn((Object)this, (Object)("Read-Locked the swing thread for " + lapsed + " ms!"));
                }
            }
        }

        static class SwingAwareWriteLock
        extends ReentrantReadWriteLock.WriteLock {
            protected SwingAwareWriteLock(ReentrantReadWriteLock lock) {
                super(lock);
            }

            @Override
            public void lock() {
                long blockStartTime = System.currentTimeMillis();
                super.lock();
                long blockEndTime = System.currentTimeMillis();
                long lapsed = blockEndTime - blockStartTime;
                if (Swing.isSwingThread() && lapsed > 30L) {
                    Msg.warn((Object)this, (Object)("Write-Locked the swing thread for " + lapsed + " ms!"));
                }
            }
        }
    }
}

