/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.SaveToolConfigDialog;
import ghidra.util.Msg;
import java.io.File;

public class DialogManager {
    private PluginTool tool;

    public DialogManager(PluginTool tool) {
        this.tool = tool;
    }

    public boolean saveToolAs() {
        SaveToolConfigDialog saveToolDialog = new SaveToolConfigDialog(this.tool, this.tool.getToolServices());
        saveToolDialog.show(this.tool.getName(), this.tool.getToolName());
        return !saveToolDialog.didCancel();
    }

    public void exportTool() {
        ToolTemplate template = this.tool.getToolTemplate(true);
        this.exportTool(template);
    }

    public void exportDefaultTool() {
        ToolTemplate template = this.tool.getToolTemplate(false);
        this.exportTool(template);
    }

    private void exportTool(ToolTemplate template) {
        ToolServices services = this.tool.getProject().getToolServices();
        try {
            File savedFile = services.exportTool(template);
            if (savedFile != null) {
                Msg.info((Object)this, (Object)("Successfully exported " + this.tool.getName() + " to " + savedFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error exporting tool tool", (Throwable)e);
        }
    }
}

