/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.data.DomainObjectFileListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.options.Options;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface DomainObject {
    public static final Object undoLock = new Object();
    public static final int DO_OBJECT_SAVED = 1;
    public static final int DO_DOMAIN_FILE_CHANGED = 2;
    public static final int DO_OBJECT_RENAMED = 3;
    public static final int DO_OBJECT_RESTORED = 4;
    public static final int DO_PROPERTY_CHANGED = 5;
    public static final int DO_OBJECT_CLOSED = 6;
    public static final int DO_OBJECT_ERROR = 8;

    public boolean isChanged();

    public void setTemporary(boolean var1);

    public boolean isTemporary();

    public boolean isChangeable();

    public boolean canSave();

    public void save(String var1, TaskMonitor var2) throws IOException, CancelledException;

    public void saveToPackedFile(File var1, TaskMonitor var2) throws IOException, CancelledException;

    public void release(Object var1);

    public void addListener(DomainObjectListener var1);

    public void removeListener(DomainObjectListener var1);

    public void addCloseListener(DomainObjectClosedListener var1);

    public void removeCloseListener(DomainObjectClosedListener var1);

    public void addDomainFileListener(DomainObjectFileListener var1);

    public void removeDomainFileListener(DomainObjectFileListener var1);

    public EventQueueID createPrivateEventQueue(DomainObjectListener var1, int var2);

    public boolean removePrivateEventQueue(EventQueueID var1);

    public String getDescription();

    public String getName();

    public void setName(String var1);

    public DomainFile getDomainFile();

    public boolean addConsumer(Object var1);

    public List<Object> getConsumerList();

    public boolean isUsedBy(Object var1);

    public void setEventsEnabled(boolean var1);

    public boolean isSendingEvents();

    public void flushEvents();

    public void flushPrivateEventQueue(EventQueueID var1);

    public boolean canLock();

    public boolean isLocked();

    public boolean lock(String var1);

    public void forceLock(boolean var1, String var2);

    public void unlock();

    public List<String> getOptionsNames();

    public Options getOptions(String var1);

    public boolean isClosed();

    public boolean hasExclusiveAccess();

    public Map<String, String> getMetadata();

    public long getModificationNumber();
}

