/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GListCellRenderer;
import generic.theme.GThemeDefaults;
import ghidra.framework.main.ToolConnectionDialog;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ToolConnectionPanel
extends JPanel
implements ListSelectionListener {
    private ToolConnectionDialog toolDialog;
    private ToolManager toolManager;
    private JList<PluginTool> consumerList;
    private JList<PluginTool> producerList;
    private JList<JCheckBox> eventList;
    private DefaultListModel<PluginTool> producerModel;
    private DefaultListModel<PluginTool> consumerModel;
    private GCheckBox[] checkboxes;
    private String[] eventNames;
    private static final String msgSource = "Tool Connection";

    ToolConnectionPanel(ToolConnectionDialog toolDialog, ToolManager toolManager) {
        this.toolDialog = toolDialog;
        this.toolManager = toolManager;
        this.initialize();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.toolDialog.setStatusText("");
        this.toolDialog.setConnectAllEnabled(false);
        this.toolDialog.setDisconnectAllEnabled(false);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.processSelection();
    }

    void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
        this.updateDisplay();
    }

    void updateDisplay() {
        PluginTool producer = this.producerList.getSelectedValue();
        PluginTool consumer = this.consumerList.getSelectedValue();
        this.showData();
        if (producer != null && consumer != null) {
            ListSelectionModel sm;
            int index = this.producerModel.indexOf((Object)producer);
            if (index >= 0) {
                sm = this.producerList.getSelectionModel();
                sm.addSelectionInterval(index, index);
            }
            if ((index = this.consumerModel.indexOf((Object)consumer)) >= 0) {
                sm = this.consumerList.getSelectionModel();
                sm.addSelectionInterval(index, index);
            }
        }
        this.validate();
    }

    void showData() {
        this.eventList.setModel(new DefaultListModel());
        this.clearSelection();
        this.populateConsumerList();
        this.populateProducerList();
    }

    void clear() {
        this.consumerModel.clear();
        this.producerModel.clear();
    }

    void toolAdded(PluginTool tool) {
        String[] consumedEvents = tool.getConsumedToolEventNames();
        String[] producedEvents = tool.getToolEventNames();
        if (consumedEvents.length > 0) {
            this.consumerModel.addElement(tool);
        }
        if (producedEvents.length > 0) {
            this.producerModel.addElement(tool);
        }
        this.validate();
    }

    void toolRemoved(PluginTool tool) {
        int index = this.producerModel.indexOf((Object)tool);
        if (index >= 0) {
            this.producerModel.remove(index);
        }
        if ((index = this.consumerModel.indexOf((Object)tool)) >= 0) {
            this.consumerModel.remove(index);
        }
        this.processSelection();
        this.validate();
    }

    void connectAll(boolean connect) {
        PluginTool producer = this.producerList.getSelectedValue();
        PluginTool consumer = this.consumerList.getSelectedValue();
        this.eventList.setModel(new DefaultListModel());
        if (consumer == null || producer == null) {
            return;
        }
        if (producer.getName().equals(consumer.getName())) {
            return;
        }
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        for (String eventName : this.eventNames = tc.getEvents()) {
            this.doConnect(producer, consumer, eventName, connect);
        }
        tc = this.toolManager.getConnection(consumer, producer);
        for (String eventName : this.eventNames = tc.getEvents()) {
            this.doConnect(consumer, producer, eventName, connect);
        }
        this.updateDisplay();
    }

    private void initialize() {
        JPanel panel = this.createListPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)panel, "Center");
        this.producerList.setSelectionMode(0);
        this.consumerList.setSelectionMode(0);
        this.eventList.setSelectionMode(0);
        ListSelectionModel sm = this.producerList.getSelectionModel();
        sm.addListSelectionListener(this);
        sm = this.consumerList.getSelectionModel();
        sm.addListSelectionListener(this);
        this.eventList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolConnectionPanel.this.processMouseClicked(e);
            }
        });
        this.eventList.setCellRenderer(new DataCellRenderer());
        this.producerList.setCellRenderer((ListCellRenderer<PluginTool>)GListCellRenderer.createDefaultCellTextRenderer(tool -> tool.getName()));
        this.consumerList.setCellRenderer((ListCellRenderer<PluginTool>)GListCellRenderer.createDefaultCellTextRenderer(tool -> tool.getName()));
        this.producerModel = (DefaultListModel)this.producerList.getModel();
        this.consumerModel = (DefaultListModel)this.consumerList.getModel();
    }

    private void processMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (!this.checkboxes[index].isEnabled()) {
                return;
            }
            boolean selected = this.checkboxes[index].isSelected();
            this.checkboxes[index].setSelected(!selected);
            this.refreshList((JCheckBox[])this.checkboxes);
            PluginTool producer = this.producerList.getSelectedValue();
            PluginTool consumer = this.consumerList.getSelectedValue();
            this.doConnect(producer, consumer, this.eventNames[index], !selected);
            int connectedCount = 0;
            for (GCheckBox checkboxe : this.checkboxes) {
                if (!checkboxe.isSelected()) continue;
                ++connectedCount;
            }
            this.updateButtonEnablement(connectedCount);
        }
    }

    private void doConnect(PluginTool producer, PluginTool consumer, String eventName, boolean connect) {
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        if (tc.isConnected(eventName) == connect) {
            return;
        }
        if (connect) {
            tc.connect(eventName);
            Msg.info((Object)this, (Object)("Tool Connection: Connected consumer " + consumer.getName() + " to producer " + producer.getName() + " for event " + eventName));
        } else {
            tc.disconnect(eventName);
            Msg.info((Object)this, (Object)("Tool Connection: Disconnected consumer " + consumer.getName() + " from producer " + producer.getName() + " for event " + eventName));
        }
    }

    private void populateConsumerList() {
        this.consumerModel.removeAllElements();
        PluginTool[] tools = this.toolManager.getConsumerTools();
        Arrays.sort(tools, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (PluginTool tool : tools) {
            this.consumerModel.addElement(tool);
        }
        if (tools.length == 0) {
            Msg.info((Object)this, (Object)"Tool Connection: No Tool consumes any events.");
        }
    }

    private void populateProducerList() {
        this.producerModel.removeAllElements();
        PluginTool[] tools = this.toolManager.getProducerTools();
        Arrays.sort(tools, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (PluginTool tool : tools) {
            this.producerModel.addElement(tool);
        }
        if (tools.length == 0) {
            Msg.info((Object)this, (Object)"Tool Connection: No Tool generates events.");
        }
    }

    private void processSelection() {
        this.eventList.setModel(new DefaultListModel());
        PluginTool producer = this.producerList.getSelectedValue();
        if (producer == null) {
            this.toolDialog.setStatusText("Please select an Event Producer");
            return;
        }
        PluginTool consumer = this.consumerList.getSelectedValue();
        if (consumer == null) {
            this.toolDialog.setStatusText("Please select an Event Consumer");
            return;
        }
        if (producer.getName().equals(consumer.getName())) {
            this.toolDialog.setStatusText("The selected Event Producer Consumer must be different");
            return;
        }
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        this.eventNames = tc.getEvents();
        this.checkboxes = new GCheckBox[this.eventNames.length];
        int connectedCount = 0;
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i] = new GCheckBox(this.eventNames[i]);
            this.checkboxes[i].setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            boolean isConnected = tc.isConnected(this.eventNames[i]);
            this.checkboxes[i].setSelected(isConnected);
            this.checkboxes[i].setEnabled(true);
            if (!isConnected) continue;
            ++connectedCount;
        }
        this.refreshList((JCheckBox[])this.checkboxes);
        this.updateButtonEnablement(connectedCount);
        this.toolDialog.setStatusText("Please select on the events to be connected or disconnected");
    }

    private void updateButtonEnablement(int connectedCount) {
        this.toolDialog.setConnectAllEnabled(connectedCount < this.eventNames.length);
        this.toolDialog.setDisconnectAllEnabled(connectedCount > 0);
    }

    private void clearSelection() {
        this.consumerList.clearSelection();
        this.producerList.clearSelection();
        this.eventList.clearSelection();
    }

    private void refreshList(JCheckBox[] dataList) {
        this.eventList.setListData((JCheckBox[])dataList);
        this.eventList.clearSelection();
    }

    private JPanel createListPanel() {
        int i;
        this.consumerList = new JList(new DefaultListModel());
        this.consumerList.setName("Consumers");
        JScrollPane consumerListScrollPane = new JScrollPane(this.consumerList);
        this.producerList = new JList(new DefaultListModel());
        this.producerList.setName("Producers");
        JScrollPane producerListScrollPane = new JScrollPane(this.producerList);
        this.eventList = new JList(new DefaultListModel());
        this.eventList.setName("Events");
        JScrollPane eventListScrollPane = new JScrollPane(this.eventList);
        Dimension minimumSize = new Dimension(150, 150);
        consumerListScrollPane.setMinimumSize(minimumSize);
        consumerListScrollPane.setPreferredSize(minimumSize);
        producerListScrollPane.setMinimumSize(minimumSize);
        producerListScrollPane.setPreferredSize(minimumSize);
        eventListScrollPane.setMinimumSize(minimumSize);
        eventListScrollPane.setPreferredSize(minimumSize);
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        JComponent[] row1 = null;
        JComponent[] row2 = null;
        GDLabel producerLabel = new GDLabel("Event Producer:");
        GDLabel consumerLabel = new GDLabel("Event Consumer:");
        GDLabel eventLabel = new GDLabel("Event Names:");
        JComponent[] c1 = new JComponent[]{producerLabel, consumerLabel, eventLabel};
        JComponent[] c2 = new JComponent[]{producerListScrollPane, consumerListScrollPane, eventListScrollPane};
        row1 = c1;
        row2 = c2;
        GridBagConstraints gbc = null;
        for (i = 0; i < row1.length; ++i) {
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.gridx = i;
            gbc.gridy = 0;
            gbc.insets.top = 10;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weightx = 1.0;
            gbl.setConstraints(row1[i], gbc);
            panel.add(row1[i]);
        }
        for (i = 0; i < row2.length; ++i) {
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.gridx = i;
            gbc.gridy = 1;
            gbc.insets.top = 5;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(row2[i], gbc);
            panel.add(row2[i]);
        }
        return panel;
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return null;
                }
                index = selected;
            }
            return ToolConnectionPanel.this.checkboxes[index];
        }
    }
}

