/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BaseProduction;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.production.BuildingProductionCalculator;
import net.sf.freecol.common.model.production.WorkerAssignment;
import net.sf.freecol.common.util.CollectionUtils;

public final class BuildingType
extends BuildableType
implements BaseProduction {
    public static final String TAG = "building-type";
    private int level = 1;
    private int workPlaces = 3;
    private int minSkill = Integer.MIN_VALUE;
    private int maxSkill = Integer.MAX_VALUE;
    private int upkeep = 0;
    private int priority = 800;
    private int expertConnectionProduction = 0;
    private float competenceFactor = 1.0f;
    private float rebelFactor = 1.0f;
    private BuildingType upgradesFrom = null;
    private BuildingType upgradesTo = null;
    private final List<ProductionType> productionTypes = new ArrayList<ProductionType>();
    private static final String COMPETENCE_FACTOR_TAG = "competence-factor";
    private static final String EXPERTS_WITH_CONNECTION_PRODUCTION_TAG = "experts-with-connections-production";
    private static final String MAXIMUM_SKILL_TAG = "maximum-skill";
    private static final String MINIMUM_SKILL_TAG = "minimum-skill";
    private static final String PRIORITY_TAG = "priority";
    private static final String PRODUCTION_TAG = "production";
    private static final String REBEL_FACTOR_TAG = "rebel-factor";
    private static final String UPGRADES_FROM_TAG = "upgrades-from";
    private static final String UPKEEP_TAG = "upkeep";
    private static final String WORKPLACES_TAG = "workplaces";
    private static final String OLD_MAX_SKILL_TAG = "maxSkill";
    private static final String OLD_MIN_SKILL_TAG = "minSkill";
    private static final String OLD_UPGRADES_FROM_TAG = "upgradesFrom";

    public BuildingType(String id, Specification specification) {
        super(id, specification);
    }

    public int getLevel() {
        return this.level;
    }

    public int getWorkPlaces() {
        return this.workPlaces;
    }

    public int getMinimumSkill() {
        return this.minSkill;
    }

    public int getMaximumSkill() {
        return this.maxSkill;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getExpertConnectionProduction() {
        return this.expertConnectionProduction;
    }

    public float getCompetenceFactor() {
        return this.competenceFactor;
    }

    public float getRebelFactor() {
        return this.rebelFactor;
    }

    public int getPriority() {
        return this.priority;
    }

    public UnitLocation.NoAddReason getNoAddReason(UnitType unitType) {
        return this.workPlaces == 0 ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : (!unitType.hasSkill() ? UnitLocation.NoAddReason.MISSING_SKILL : (unitType.getSkill() < this.minSkill ? UnitLocation.NoAddReason.MINIMUM_SKILL : (unitType.getSkill() > this.maxSkill ? UnitLocation.NoAddReason.MAXIMUM_SKILL : UnitLocation.NoAddReason.NONE)));
    }

    public boolean canAdd(UnitType unitType) {
        return this.getNoAddReason(unitType) == UnitLocation.NoAddReason.NONE;
    }

    public FreeColSpecObjectType getType() {
        return this;
    }

    public BuildingType getUpgradesFrom() {
        return this.upgradesFrom;
    }

    public BuildingType getUpgradesTo() {
        return this.upgradesTo;
    }

    public BuildingType getFirstLevel() {
        BuildingType buildingType = this;
        while (buildingType.getUpgradesFrom() != null) {
            buildingType = buildingType.getUpgradesFrom();
        }
        return buildingType;
    }

    public boolean isAutomaticBuild() {
        return !this.needsGoodsToBuild() && this.getUpgradesFrom() == null;
    }

    protected List<ProductionType> getProductionTypes() {
        return this.productionTypes;
    }

    protected void setProductionTypes(List<ProductionType> productionTypes) {
        this.productionTypes.clear();
        this.productionTypes.addAll(productionTypes);
    }

    public void addProductionType(ProductionType productionType) {
        if (productionType != null) {
            this.productionTypes.add(productionType);
        }
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.getAvailableProductionTypes(unattended, null);
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended, String level) {
        return CollectionUtils.transform(this.productionTypes, pt -> pt.getUnattended() == unattended && pt.appliesTo(level));
    }

    public GoodsType getProducedGoodsType() {
        if (this.productionTypes.isEmpty()) {
            return null;
        }
        AbstractGoods ag = CollectionUtils.first(CollectionUtils.first(this.productionTypes).getOutputs());
        return ag == null ? null : ag.getType();
    }

    public boolean isDefenceType() {
        return this.containsModifierKey("model.modifier.defence");
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return goodsType != null && ProductionType.canProduce(goodsType, this.getAvailableProductionTypes(unitType == null));
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        BuildingProductionCalculator bpc = new BuildingProductionCalculator(null, new FeatureContainer(), 0);
        ProductionType productionType = ProductionType.getBestProductionType(goodsType, this.getAvailableProductionTypes(unitType == null));
        int MORE_THAN_ENOUGH_INPUT_GOODS = 1000;
        int MORE_THAN_ENOUGH_WAREHOUSE_CAPACITY = 10000;
        List<AbstractGoods> inputGoods = productionType.getInputList().stream().map(ag -> new AbstractGoods(ag.getType(), 1000)).collect(Collectors.toList());
        Turn turn = this.getGame() != null && this.getGame().getTurn() != null ? this.getGame().getTurn() : new Turn(1);
        ProductionInfo pi = bpc.getAdjustedProductionInfo(this, turn, List.of(new WorkerAssignment(unitType, productionType)), inputGoods, List.of(), 10000);
        return pi.getProduction().stream().filter(a -> a.getType().equals(goodsType)).map(AbstractGoods::getAmount).findFirst().orElse(0);
    }

    @Override
    public Colony.NoBuildReason canBeBuiltInColony(Colony colony, List<BuildableType> assumeBuilt) {
        BuildingType from;
        Building colonyBuilding = colony.getBuilding(this);
        if (colonyBuilding == null ? (from = this.getUpgradesFrom()) != null && !assumeBuilt.contains(from) : (from = colonyBuilding.getType().getUpgradesTo()) != this && !assumeBuilt.contains(from)) {
            return Colony.NoBuildReason.WRONG_UPGRADE;
        }
        return Colony.NoBuildReason.NONE;
    }

    @Override
    public int getMinimumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        BuildingType buildingType;
        ListModel<BuildableType> buildQueue = buildQueueList.getModel();
        BuildingType upgradesFrom = this.getUpgradesFrom();
        if (upgradesFrom == null) {
            return 0;
        }
        Building building = colony.getBuilding(this);
        BuildingType buildingType2 = buildingType = building == null ? null : building.getType();
        if (buildingType == upgradesFrom) {
            return 0;
        }
        for (int index = 0; index < buildQueue.getSize(); ++index) {
            if (!upgradesFrom.equals(buildQueue.getElementAt(index))) continue;
            return index + 1;
        }
        return UNABLE_TO_BUILD;
    }

    @Override
    public int getMaximumIndex(Colony colony, JList<BuildableType> buildQueueList, int UNABLE_TO_BUILD) {
        ListModel<BuildableType> buildQueue = buildQueueList.getModel();
        int buildQueueLastPos = buildQueue.getSize();
        boolean canBuild = false;
        if (colony.canBuild(this)) {
            canBuild = true;
        }
        BuildingType upgradesFrom = this.getUpgradesFrom();
        BuildingType upgradesTo = this.getUpgradesTo();
        if (!canBuild && upgradesFrom == null) {
            return UNABLE_TO_BUILD;
        }
        if (canBuild && upgradesTo == null) {
            return buildQueueLastPos;
        }
        boolean foundUpgradesFrom = canBuild;
        for (int index = 0; index < buildQueue.getSize(); ++index) {
            BuildableType toBuild = buildQueue.getElementAt(index);
            if (toBuild == this) continue;
            if (!canBuild && !foundUpgradesFrom && upgradesFrom.equals(toBuild)) {
                foundUpgradesFrom = true;
                if (upgradesTo == null) {
                    return buildQueueLastPos;
                }
            }
            if (foundUpgradesFrom && upgradesTo != null && upgradesTo.equals(toBuild)) {
                return index;
            }
            if (!this.hasAbility("model.ability.build", toBuild)) continue;
            return index;
        }
        return buildQueueLastPos;
    }

    public Stream<Modifier> getCompetenceModifiers(String id, UnitType unitType, Turn turn) {
        float competence = this.getCompetenceFactor();
        return competence == 1.0f ? unitType.getModifiers(id, this.getType(), turn) : CollectionUtils.map(unitType.getModifiers(id, this.getType(), turn), m -> m.getType() == Modifier.ModifierType.ADDITIVE ? Modifier.makeModifier(m).setValue(m.getValue() * competence) : m);
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof BuildingType) {
            BuildingType bt = (BuildingType)other;
            cmp = this.getIndex() - bt.getIndex();
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        BuildingType o = this.copyInCast(other, BuildingType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.level = o.getLevel();
        this.workPlaces = o.getWorkPlaces();
        this.minSkill = o.getMinimumSkill();
        this.maxSkill = o.getMaximumSkill();
        this.upkeep = o.getUpkeep();
        this.priority = o.getPriority();
        this.expertConnectionProduction = o.getExpertConnectionProduction();
        this.competenceFactor = o.getCompetenceFactor();
        this.rebelFactor = o.getRebelFactor();
        this.upgradesFrom = o.getUpgradesFrom();
        this.upgradesTo = o.getUpgradesTo();
        this.setProductionTypes(o.getProductionTypes());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.upgradesFrom != null) {
            xw.writeAttribute(UPGRADES_FROM_TAG, this.upgradesFrom);
        }
        xw.writeAttribute(WORKPLACES_TAG, this.workPlaces);
        if (this.minSkill != Integer.MIN_VALUE) {
            xw.writeAttribute(MINIMUM_SKILL_TAG, this.minSkill);
        }
        if (this.maxSkill < Integer.MAX_VALUE) {
            xw.writeAttribute(MAXIMUM_SKILL_TAG, this.maxSkill);
        }
        if (this.upkeep > 0) {
            xw.writeAttribute(UPKEEP_TAG, this.upkeep);
        }
        if (this.priority != 800) {
            xw.writeAttribute(PRIORITY_TAG, this.priority);
        }
        xw.writeAttribute(EXPERTS_WITH_CONNECTION_PRODUCTION_TAG, this.expertConnectionProduction);
        xw.writeAttribute(COMPETENCE_FACTOR_TAG, this.competenceFactor);
        xw.writeAttribute(REBEL_FACTOR_TAG, this.rebelFactor);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (ProductionType productionType : this.productionTypes) {
            productionType.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        BuildingType parent = xr.getAlreadyInitializedType(spec, "extends", BuildingType.class, this);
        this.upgradesFrom = xr.hasAttribute(OLD_UPGRADES_FROM_TAG) ? xr.getType(spec, OLD_UPGRADES_FROM_TAG, BuildingType.class, null) : xr.getType(spec, UPGRADES_FROM_TAG, BuildingType.class, null);
        if (this.upgradesFrom == null) {
            this.level = 1;
        } else {
            this.upgradesFrom.upgradesTo = this;
            this.level = this.upgradesFrom.level + 1;
        }
        this.workPlaces = xr.getAttribute(WORKPLACES_TAG, parent.workPlaces);
        this.minSkill = xr.hasAttribute(OLD_MIN_SKILL_TAG) ? xr.getAttribute(OLD_MIN_SKILL_TAG, parent.minSkill) : xr.getAttribute(MINIMUM_SKILL_TAG, parent.minSkill);
        this.maxSkill = xr.hasAttribute(OLD_MAX_SKILL_TAG) ? xr.getAttribute(OLD_MAX_SKILL_TAG, parent.maxSkill) : xr.getAttribute(MAXIMUM_SKILL_TAG, parent.maxSkill);
        this.upkeep = xr.getAttribute(UPKEEP_TAG, parent.upkeep);
        this.priority = xr.getAttribute(PRIORITY_TAG, parent.priority);
        this.expertConnectionProduction = xr.getAttribute(EXPERTS_WITH_CONNECTION_PRODUCTION_TAG, parent.expertConnectionProduction);
        this.competenceFactor = xr.getAttribute(COMPETENCE_FACTOR_TAG, parent.competenceFactor);
        this.rebelFactor = xr.getAttribute(REBEL_FACTOR_TAG, parent.rebelFactor);
        if (parent != this) {
            if (!xr.hasAttribute("required-population")) {
                this.setRequiredPopulation(parent.getRequiredPopulation());
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (PRODUCTION_TAG.equals(tag)) {
            if (xr.getAttribute("delete", false)) {
                this.productionTypes.clear();
                xr.closeTag(PRODUCTION_TAG);
            } else {
                this.addProductionType(new ProductionType(xr, spec));
            }
        } else {
            super.readChild(xr);
        }
        if (this.expertConnectionProduction == 0 && this.hasAbility("model.ability.expertsUseConnections")) {
            this.expertConnectionProduction = 4;
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

