/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialects;
import io.cucumber.gherkin.ParserException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class GherkinDialectProvider {
    private final String defaultDialectName;

    public GherkinDialectProvider(String defaultDialectName) {
        this.defaultDialectName = Objects.requireNonNull(defaultDialectName);
    }

    public GherkinDialectProvider() {
        this("en");
    }

    public GherkinDialect getDefaultDialect() {
        return this.getDialect(this.defaultDialectName).orElseThrow(() -> new ParserException.NoSuchLanguageException(this.defaultDialectName, null));
    }

    public Optional<GherkinDialect> getDialect(String language) {
        Objects.requireNonNull(language);
        return Optional.ofNullable(GherkinDialects.DIALECTS.get(language));
    }

    public Set<String> getLanguages() {
        return GherkinDialects.DIALECTS.keySet();
    }
}

