﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/AssociationState.h>
#include <aws/workspaces/model/AssociationStateReason.h>
#include <aws/workspaces/model/WorkSpaceAssociatedResourceType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {

/**
 * <p>Describes the association between an application and a WorkSpace
 * resource.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceResourceAssociation">AWS
 * API Reference</a></p>
 */
class WorkspaceResourceAssociation {
 public:
  AWS_WORKSPACES_API WorkspaceResourceAssociation() = default;
  AWS_WORKSPACES_API WorkspaceResourceAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API WorkspaceResourceAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the associated resource.</p>
   */
  inline const Aws::String& GetAssociatedResourceId() const { return m_associatedResourceId; }
  inline bool AssociatedResourceIdHasBeenSet() const { return m_associatedResourceIdHasBeenSet; }
  template <typename AssociatedResourceIdT = Aws::String>
  void SetAssociatedResourceId(AssociatedResourceIdT&& value) {
    m_associatedResourceIdHasBeenSet = true;
    m_associatedResourceId = std::forward<AssociatedResourceIdT>(value);
  }
  template <typename AssociatedResourceIdT = Aws::String>
  WorkspaceResourceAssociation& WithAssociatedResourceId(AssociatedResourceIdT&& value) {
    SetAssociatedResourceId(std::forward<AssociatedResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource types of the associated resource.</p>
   */
  inline WorkSpaceAssociatedResourceType GetAssociatedResourceType() const { return m_associatedResourceType; }
  inline bool AssociatedResourceTypeHasBeenSet() const { return m_associatedResourceTypeHasBeenSet; }
  inline void SetAssociatedResourceType(WorkSpaceAssociatedResourceType value) {
    m_associatedResourceTypeHasBeenSet = true;
    m_associatedResourceType = value;
  }
  inline WorkspaceResourceAssociation& WithAssociatedResourceType(WorkSpaceAssociatedResourceType value) {
    SetAssociatedResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association is created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreated() const { return m_created; }
  inline bool CreatedHasBeenSet() const { return m_createdHasBeenSet; }
  template <typename CreatedT = Aws::Utils::DateTime>
  void SetCreated(CreatedT&& value) {
    m_createdHasBeenSet = true;
    m_created = std::forward<CreatedT>(value);
  }
  template <typename CreatedT = Aws::Utils::DateTime>
  WorkspaceResourceAssociation& WithCreated(CreatedT&& value) {
    SetCreated(std::forward<CreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association status was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  WorkspaceResourceAssociation& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the WorkSpace resource association.</p>
   */
  inline AssociationState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(AssociationState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline WorkspaceResourceAssociation& WithState(AssociationState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason the association deployment failed.</p>
   */
  inline const AssociationStateReason& GetStateReason() const { return m_stateReason; }
  inline bool StateReasonHasBeenSet() const { return m_stateReasonHasBeenSet; }
  template <typename StateReasonT = AssociationStateReason>
  void SetStateReason(StateReasonT&& value) {
    m_stateReasonHasBeenSet = true;
    m_stateReason = std::forward<StateReasonT>(value);
  }
  template <typename StateReasonT = AssociationStateReason>
  WorkspaceResourceAssociation& WithStateReason(StateReasonT&& value) {
    SetStateReason(std::forward<StateReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the WorkSpace.</p>
   */
  inline const Aws::String& GetWorkspaceId() const { return m_workspaceId; }
  inline bool WorkspaceIdHasBeenSet() const { return m_workspaceIdHasBeenSet; }
  template <typename WorkspaceIdT = Aws::String>
  void SetWorkspaceId(WorkspaceIdT&& value) {
    m_workspaceIdHasBeenSet = true;
    m_workspaceId = std::forward<WorkspaceIdT>(value);
  }
  template <typename WorkspaceIdT = Aws::String>
  WorkspaceResourceAssociation& WithWorkspaceId(WorkspaceIdT&& value) {
    SetWorkspaceId(std::forward<WorkspaceIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associatedResourceId;
  bool m_associatedResourceIdHasBeenSet = false;

  WorkSpaceAssociatedResourceType m_associatedResourceType{WorkSpaceAssociatedResourceType::NOT_SET};
  bool m_associatedResourceTypeHasBeenSet = false;

  Aws::Utils::DateTime m_created{};
  bool m_createdHasBeenSet = false;

  Aws::Utils::DateTime m_lastUpdatedTime{};
  bool m_lastUpdatedTimeHasBeenSet = false;

  AssociationState m_state{AssociationState::NOT_SET};
  bool m_stateHasBeenSet = false;

  AssociationStateReason m_stateReason;
  bool m_stateReasonHasBeenSet = false;

  Aws::String m_workspaceId;
  bool m_workspaceIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
