﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/textract/Textract_EXPORTS.h>
#include <aws/textract/model/DocumentMetadata.h>
#include <aws/textract/model/JobStatus.h>
#include <aws/textract/model/LendingResult.h>
#include <aws/textract/model/Warning.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Textract {
namespace Model {
class GetLendingAnalysisResult {
 public:
  AWS_TEXTRACT_API GetLendingAnalysisResult() = default;
  AWS_TEXTRACT_API GetLendingAnalysisResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TEXTRACT_API GetLendingAnalysisResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const DocumentMetadata& GetDocumentMetadata() const { return m_documentMetadata; }
  template <typename DocumentMetadataT = DocumentMetadata>
  void SetDocumentMetadata(DocumentMetadataT&& value) {
    m_documentMetadataHasBeenSet = true;
    m_documentMetadata = std::forward<DocumentMetadataT>(value);
  }
  template <typename DocumentMetadataT = DocumentMetadata>
  GetLendingAnalysisResult& WithDocumentMetadata(DocumentMetadataT&& value) {
    SetDocumentMetadata(std::forward<DocumentMetadataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The current status of the lending analysis job.</p>
   */
  inline JobStatus GetJobStatus() const { return m_jobStatus; }
  inline void SetJobStatus(JobStatus value) {
    m_jobStatusHasBeenSet = true;
    m_jobStatus = value;
  }
  inline GetLendingAnalysisResult& WithJobStatus(JobStatus value) {
    SetJobStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the response is truncated, Amazon Textract returns this token. You can use
   * this token in the subsequent request to retrieve the next set of lending
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetLendingAnalysisResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Holds the information returned by one of AmazonTextract's document analysis
   * operations for the pinstripe.</p>
   */
  inline const Aws::Vector<LendingResult>& GetResults() const { return m_results; }
  template <typename ResultsT = Aws::Vector<LendingResult>>
  void SetResults(ResultsT&& value) {
    m_resultsHasBeenSet = true;
    m_results = std::forward<ResultsT>(value);
  }
  template <typename ResultsT = Aws::Vector<LendingResult>>
  GetLendingAnalysisResult& WithResults(ResultsT&& value) {
    SetResults(std::forward<ResultsT>(value));
    return *this;
  }
  template <typename ResultsT = LendingResult>
  GetLendingAnalysisResult& AddResults(ResultsT&& value) {
    m_resultsHasBeenSet = true;
    m_results.emplace_back(std::forward<ResultsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A list of warnings that occurred during the lending analysis operation. </p>
   */
  inline const Aws::Vector<Warning>& GetWarnings() const { return m_warnings; }
  template <typename WarningsT = Aws::Vector<Warning>>
  void SetWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings = std::forward<WarningsT>(value);
  }
  template <typename WarningsT = Aws::Vector<Warning>>
  GetLendingAnalysisResult& WithWarnings(WarningsT&& value) {
    SetWarnings(std::forward<WarningsT>(value));
    return *this;
  }
  template <typename WarningsT = Warning>
  GetLendingAnalysisResult& AddWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings.emplace_back(std::forward<WarningsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Returns if the lending analysis job could not be completed. Contains
   * explanation for what error occurred. </p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  GetLendingAnalysisResult& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The current model version of the Analyze Lending API.</p>
   */
  inline const Aws::String& GetAnalyzeLendingModelVersion() const { return m_analyzeLendingModelVersion; }
  template <typename AnalyzeLendingModelVersionT = Aws::String>
  void SetAnalyzeLendingModelVersion(AnalyzeLendingModelVersionT&& value) {
    m_analyzeLendingModelVersionHasBeenSet = true;
    m_analyzeLendingModelVersion = std::forward<AnalyzeLendingModelVersionT>(value);
  }
  template <typename AnalyzeLendingModelVersionT = Aws::String>
  GetLendingAnalysisResult& WithAnalyzeLendingModelVersion(AnalyzeLendingModelVersionT&& value) {
    SetAnalyzeLendingModelVersion(std::forward<AnalyzeLendingModelVersionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetLendingAnalysisResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DocumentMetadata m_documentMetadata;
  bool m_documentMetadataHasBeenSet = false;

  JobStatus m_jobStatus{JobStatus::NOT_SET};
  bool m_jobStatusHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<LendingResult> m_results;
  bool m_resultsHasBeenSet = false;

  Aws::Vector<Warning> m_warnings;
  bool m_warningsHasBeenSet = false;

  Aws::String m_statusMessage;
  bool m_statusMessageHasBeenSet = false;

  Aws::String m_analyzeLendingModelVersion;
  bool m_analyzeLendingModelVersionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Textract
}  // namespace Aws
