﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sso/SSO_EXPORTS.h>
#include <aws/sso/model/AccountInfo.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSO {
namespace Model {
class ListAccountsResult {
 public:
  AWS_SSO_API ListAccountsResult() = default;
  AWS_SSO_API ListAccountsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSO_API ListAccountsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The page token client that is used to retrieve the list of accounts.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAccountsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A paginated response with the list of account information and the next token
   * if more results are available.</p>
   */
  inline const Aws::Vector<AccountInfo>& GetAccountList() const { return m_accountList; }
  template <typename AccountListT = Aws::Vector<AccountInfo>>
  void SetAccountList(AccountListT&& value) {
    m_accountListHasBeenSet = true;
    m_accountList = std::forward<AccountListT>(value);
  }
  template <typename AccountListT = Aws::Vector<AccountInfo>>
  ListAccountsResult& WithAccountList(AccountListT&& value) {
    SetAccountList(std::forward<AccountListT>(value));
    return *this;
  }
  template <typename AccountListT = AccountInfo>
  ListAccountsResult& AddAccountList(AccountListT&& value) {
    m_accountListHasBeenSet = true;
    m_accountList.emplace_back(std::forward<AccountListT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAccountsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<AccountInfo> m_accountList;
  bool m_accountListHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSO
}  // namespace Aws
